/*
 * Decompiled with CFR 0.152.
 */
package gigaherz.survivalist.rack;

import gigaherz.survivalist.Dryable;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.ITickable;
import net.minecraftforge.common.capabilities.Capability;
import net.minecraftforge.items.CapabilityItemHandler;
import net.minecraftforge.items.ItemStackHandler;

public class TileRack
extends TileEntity
implements ITickable {
    public int[] dryTimeRemaining = new int[4];
    public ItemStackHandler items = new ItemStackHandler(4){

        protected int getStackLimit(int slot, ItemStack stack) {
            return 1;
        }

        protected void onContentsChanged(int slot) {
            super.onContentsChanged(slot);
            TileRack.this.func_70296_d();
        }
    };

    public void func_73660_a() {
        if (this.field_145850_b.field_72995_K) {
            return;
        }
        for (int i = 0; i < 4; ++i) {
            ItemStack stack = this.items.getStackInSlot(i);
            int dryTime = Dryable.getDryingTime(stack);
            if (dryTime >= 0) {
                if (this.dryTimeRemaining[i] <= 0) {
                    this.dryTimeRemaining[i] = dryTime;
                    continue;
                }
                int n = i;
                this.dryTimeRemaining[n] = this.dryTimeRemaining[n] - 1;
                if (this.dryTimeRemaining[i] > 0) continue;
                stack = Dryable.getDryingResult(stack);
                this.items.setStackInSlot(i, stack);
                continue;
            }
            this.dryTimeRemaining[i] = 0;
        }
    }

    public boolean hasCapability(Capability<?> capability, EnumFacing facing) {
        if (capability == CapabilityItemHandler.ITEM_HANDLER_CAPABILITY) {
            return true;
        }
        return super.hasCapability(capability, facing);
    }

    public <T> T getCapability(Capability<T> capability, EnumFacing facing) {
        if (capability == CapabilityItemHandler.ITEM_HANDLER_CAPABILITY) {
            return (T)this.items;
        }
        return (T)super.getCapability(capability, facing);
    }

    public boolean isUseableByPlayer(EntityPlayer player) {
        return this.field_145850_b.func_175625_s(this.field_174879_c) == this && player.func_70092_e((double)this.field_174879_c.func_177958_n() + 0.5, (double)this.field_174879_c.func_177956_o() + 0.5, (double)this.field_174879_c.func_177952_p() + 0.5) <= 64.0;
    }

    public void func_145841_b(NBTTagCompound compound) {
        super.func_145841_b(compound);
        compound.func_74782_a("Items", (NBTBase)this.items.serializeNBT());
    }

    public void func_145839_a(NBTTagCompound compound) {
        super.func_145839_a(compound);
        this.items.deserializeNBT(compound.func_74775_l("Items"));
    }
}

