/*
 * Decompiled with CFR 0.152.
 */
package gigaherz.survivalist;

import com.google.common.collect.Lists;
import gigaherz.survivalist.ConfigManager;
import gigaherz.survivalist.GuiHandler;
import gigaherz.survivalist.ISidedProxy;
import gigaherz.survivalist.api.Choppable;
import gigaherz.survivalist.api.Dryable;
import gigaherz.survivalist.base.BlockRegistered;
import gigaherz.survivalist.base.ItemRegistered;
import gigaherz.survivalist.base.ItemRegisteredArmor;
import gigaherz.survivalist.base.ItemRegisteredFood;
import gigaherz.survivalist.chopblock.BlockChopping;
import gigaherz.survivalist.chopblock.TileChopping;
import gigaherz.survivalist.rack.BlockRack;
import gigaherz.survivalist.rack.TileRack;
import gigaherz.survivalist.rocks.EntityRock;
import gigaherz.survivalist.rocks.ItemNugget;
import gigaherz.survivalist.rocks.ItemOreRock;
import gigaherz.survivalist.rocks.ItemRock;
import gigaherz.survivalist.rocks.RocksEventHandling;
import gigaherz.survivalist.scraping.EnchantmentScraping;
import gigaherz.survivalist.scraping.ItemBreakingTracker;
import gigaherz.survivalist.scraping.MessageScraping;
import gigaherz.survivalist.torchfire.TorchFireEventHandling;
import java.util.ArrayList;
import java.util.List;
import net.minecraft.block.Block;
import net.minecraft.creativetab.CreativeTabs;
import net.minecraft.init.Blocks;
import net.minecraft.init.Items;
import net.minecraft.init.SoundEvents;
import net.minecraft.inventory.EntityEquipmentSlot;
import net.minecraft.item.Item;
import net.minecraft.item.ItemArmor;
import net.minecraft.item.ItemStack;
import net.minecraft.item.crafting.CraftingManager;
import net.minecraft.item.crafting.IRecipe;
import net.minecraft.item.crafting.ShapedRecipes;
import net.minecraft.item.crafting.ShapelessRecipes;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.SoundEvent;
import net.minecraftforge.common.config.Configuration;
import net.minecraftforge.common.util.EnumHelper;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.fml.common.SidedProxy;
import net.minecraftforge.fml.common.event.FMLInitializationEvent;
import net.minecraftforge.fml.common.event.FMLPostInitializationEvent;
import net.minecraftforge.fml.common.event.FMLPreInitializationEvent;
import net.minecraftforge.fml.common.network.IGuiHandler;
import net.minecraftforge.fml.common.network.NetworkRegistry;
import net.minecraftforge.fml.common.network.simpleimpl.SimpleNetworkWrapper;
import net.minecraftforge.fml.common.registry.EntityRegistry;
import net.minecraftforge.fml.common.registry.GameRegistry;
import net.minecraftforge.fml.common.registry.IForgeRegistryEntry;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.oredict.OreDictionary;
import net.minecraftforge.oredict.ShapedOreRecipe;
import net.minecraftforge.oredict.ShapelessOreRecipe;
import org.apache.logging.log4j.Logger;

@Mod(modid="survivalist", version="1.6.6", acceptedMinecraftVersions="[1.9.4,1.11.0)", dependencies="required-after:Forge@[12.17.0.1916,)")
public class Survivalist {
    public static final String MODID = "survivalist";
    public static final String VERSION = "1.6.6";
    private static final String CHANNEL = "survivalist";
    @Mod.Instance(value="survivalist")
    public static Survivalist instance;
    @SidedProxy(clientSide="gigaherz.survivalist.client.ClientProxy", serverSide="gigaherz.survivalist.server.ServerProxy")
    public static ISidedProxy proxy;
    public static Logger logger;
    private GuiHandler guiHandler = new GuiHandler();
    public static EnchantmentScraping scraping;
    public static Item chainmail;
    public static Item tanned_leather;
    public static Item jerky;
    public static Item nugget;
    public static Item rock;
    public static Item rock_ore;
    public static Item dough;
    public static Item round_bread;
    public static Item tanned_helmet;
    public static Item tanned_chestplate;
    public static Item tanned_leggings;
    public static Item tanned_boots;
    public static ItemStack rock_normal;
    public static ItemStack rock_andesite;
    public static ItemStack rock_diorite;
    public static ItemStack rock_granite;
    public static ItemStack iron_ore_rock;
    public static ItemStack gold_ore_rock;
    public static ItemStack copper_ore_rock;
    public static ItemStack tin_ore_rock;
    public static ItemStack lead_ore_rock;
    public static ItemStack silver_ore_rock;
    public static ItemStack iron_nugget;
    public static ItemStack copper_nugget;
    public static ItemStack tin_nugget;
    public static ItemStack lead_nugget;
    public static ItemStack silver_nugget;
    public static BlockRegistered rack;
    public static BlockRegistered chopping_block;
    public static ItemArmor.ArmorMaterial TANNED_LEATHER;
    public static SimpleNetworkWrapper channel;

    @Mod.EventHandler
    public void preInit(FMLPreInitializationEvent event) {
        logger = event.getModLog();
        ConfigManager.loadConfig(new Configuration(event.getSuggestedConfigurationFile()));
        if (ConfigManager.instance.enableScraping) {
            ItemBreakingTracker.register();
            scraping = EnchantmentScraping.register();
        }
        if (ConfigManager.instance.enableTorchFire) {
            TorchFireEventHandling.register();
        }
        if (ConfigManager.instance.enableChainmailCrafting) {
            chainmail = new ItemRegistered("chainmail").func_77637_a(CreativeTabs.field_78035_l);
            GameRegistry.register((IForgeRegistryEntry)chainmail);
        }
        if (ConfigManager.instance.enableDryingRack) {
            rack = new BlockRack("rack");
            GameRegistry.register((IForgeRegistryEntry)rack);
            GameRegistry.register((IForgeRegistryEntry)rack.createItemBlock());
            GameRegistry.registerTileEntity(TileRack.class, (String)"tileRack");
        }
        if (ConfigManager.instance.enableLeatherTanning) {
            tanned_leather = new ItemRegistered("tanned_leather").func_77637_a(CreativeTabs.field_78035_l);
            GameRegistry.register((IForgeRegistryEntry)tanned_leather);
            OreDictionary.registerOre((String)"materialLeather", (Item)tanned_leather);
            OreDictionary.registerOre((String)"materialTannedLeather", (Item)tanned_leather);
            OreDictionary.registerOre((String)"materialHardenedLeather", (Item)tanned_leather);
            tanned_helmet = new ItemRegisteredArmor("tanned_helmet", TANNED_LEATHER, 0, EntityEquipmentSlot.HEAD);
            GameRegistry.register((IForgeRegistryEntry)tanned_helmet);
            tanned_chestplate = new ItemRegisteredArmor("tanned_chestplate", TANNED_LEATHER, 0, EntityEquipmentSlot.CHEST);
            GameRegistry.register((IForgeRegistryEntry)tanned_chestplate);
            tanned_leggings = new ItemRegisteredArmor("tanned_leggings", TANNED_LEATHER, 0, EntityEquipmentSlot.LEGS);
            GameRegistry.register((IForgeRegistryEntry)tanned_leggings);
            tanned_boots = new ItemRegisteredArmor("tanned_boots", TANNED_LEATHER, 0, EntityEquipmentSlot.FEET);
            GameRegistry.register((IForgeRegistryEntry)tanned_boots);
        }
        if (ConfigManager.instance.enableJerky) {
            jerky = new ItemRegisteredFood("jerky", 4, 1.0f, true);
            GameRegistry.register((IForgeRegistryEntry)jerky);
        }
        if (ConfigManager.instance.enableNuggets) {
            nugget = new ItemNugget("nugget").func_77637_a(CreativeTabs.field_78035_l);
            GameRegistry.register((IForgeRegistryEntry)nugget);
            iron_nugget = new ItemStack(nugget, 1, 0);
            copper_nugget = new ItemStack(nugget, 1, 1);
            tin_nugget = new ItemStack(nugget, 1, 2);
            lead_nugget = new ItemStack(nugget, 1, 3);
            silver_nugget = new ItemStack(nugget, 1, 4);
            OreDictionary.registerOre((String)"nuggetIron", (ItemStack)iron_nugget);
            OreDictionary.registerOre((String)"nuggetCopper", (ItemStack)copper_nugget);
            OreDictionary.registerOre((String)"nuggetTin", (ItemStack)tin_nugget);
            OreDictionary.registerOre((String)"nuggetLead", (ItemStack)lead_nugget);
            OreDictionary.registerOre((String)"nuggetSilver", (ItemStack)silver_nugget);
        }
        if (ConfigManager.instance.enableRocks) {
            RocksEventHandling.register();
            rock = new ItemRock("rock").func_77637_a(CreativeTabs.field_78035_l);
            GameRegistry.register((IForgeRegistryEntry)rock);
            rock_ore = new ItemOreRock("rock_ore").func_77637_a(CreativeTabs.field_78035_l);
            GameRegistry.register((IForgeRegistryEntry)rock_ore);
            iron_ore_rock = new ItemStack(rock_ore, 1, 0);
            gold_ore_rock = new ItemStack(rock_ore, 1, 1);
            copper_ore_rock = new ItemStack(rock_ore, 1, 2);
            tin_ore_rock = new ItemStack(rock_ore, 1, 3);
            lead_ore_rock = new ItemStack(rock_ore, 1, 4);
            silver_ore_rock = new ItemStack(rock_ore, 1, 5);
            OreDictionary.registerOre((String)"rockOreIron", (ItemStack)iron_ore_rock);
            OreDictionary.registerOre((String)"rockOreGold", (ItemStack)gold_ore_rock);
            OreDictionary.registerOre((String)"rockOreCopper", (ItemStack)copper_ore_rock);
            OreDictionary.registerOre((String)"rockOreTin", (ItemStack)tin_ore_rock);
            OreDictionary.registerOre((String)"rockOreLead", (ItemStack)lead_ore_rock);
            OreDictionary.registerOre((String)"rockOreSilver", (ItemStack)silver_ore_rock);
            rock_normal = new ItemStack(rock, 1, 0);
            rock_andesite = new ItemStack(rock, 1, 1);
            rock_diorite = new ItemStack(rock, 1, 2);
            rock_granite = new ItemStack(rock, 1, 3);
            OreDictionary.registerOre((String)"rock", (ItemStack)rock_normal);
            OreDictionary.registerOre((String)"rock", (ItemStack)rock_andesite);
            OreDictionary.registerOre((String)"rock", (ItemStack)rock_diorite);
            OreDictionary.registerOre((String)"rock", (ItemStack)rock_granite);
            OreDictionary.registerOre((String)"rockAndesite", (ItemStack)rock_andesite);
            OreDictionary.registerOre((String)"rockDiorite", (ItemStack)rock_diorite);
            OreDictionary.registerOre((String)"rockGranite", (ItemStack)rock_granite);
        }
        if (ConfigManager.instance.enableBread) {
            dough = new ItemRegisteredFood("dough", 5, 0.6f, true);
            GameRegistry.register((IForgeRegistryEntry)dough);
            round_bread = new ItemRegisteredFood("round_bread", 8, 0.6f, true);
            GameRegistry.register((IForgeRegistryEntry)round_bread);
        }
        if (ConfigManager.instance.enableChopping) {
            chopping_block = new BlockChopping("chopping_block");
            GameRegistry.register((IForgeRegistryEntry)chopping_block);
            GameRegistry.register((IForgeRegistryEntry)chopping_block.createItemBlock());
            GameRegistry.registerTileEntity(TileChopping.class, (String)"tile_chopping_block");
        }
        this.registerNetwork();
        proxy.preInit();
    }

    private void registerNetwork() {
        logger.info("Registering network channel...");
        channel = NetworkRegistry.INSTANCE.newSimpleChannel("survivalist");
        int messageNumber = 0;
        channel.registerMessage(MessageScraping.Handler.class, MessageScraping.class, messageNumber++, Side.CLIENT);
        logger.debug("Final message number: " + messageNumber);
    }

    @Mod.EventHandler
    public void init(FMLInitializationEvent event) {
        int entityId = 1;
        NetworkRegistry.INSTANCE.registerGuiHandler((Object)this, (IGuiHandler)this.guiHandler);
        if (ConfigManager.instance.enableBread) {
            if (ConfigManager.instance.removeVanillaBread) {
                List recipes = CraftingManager.func_77594_a().func_77592_b();
                int i = 0;
                while (i < recipes.size()) {
                    ItemStack output;
                    boolean removed = false;
                    IRecipe r = (IRecipe)recipes.get(i);
                    if (r instanceof ShapedOreRecipe && (output = r.func_77571_b()) != null && output.func_77973_b() == Items.field_151025_P) {
                        recipes.remove(r);
                        removed = true;
                    }
                    if (removed) continue;
                    ++i;
                }
            }
            GameRegistry.addShapelessRecipe((ItemStack)new ItemStack(dough), (Object[])new Object[]{Items.field_151015_O, Items.field_151015_O, Items.field_151015_O, Items.field_151015_O});
            GameRegistry.addSmelting((Item)dough, (ItemStack)new ItemStack(round_bread), (float)0.0f);
        }
        if (ConfigManager.instance.enableDryingRack) {
            GameRegistry.addRecipe((IRecipe)new ShapedOreRecipe(new ItemStack((Block)rack), new Object[]{"sss", " p ", "p p", Character.valueOf('s'), "stickWood", Character.valueOf('p'), "plankWood"}));
            Dryable.register();
            if (ConfigManager.instance.enableLeatherTanning && ConfigManager.instance.enableSaddleCrafting) {
                GameRegistry.addRecipe((IRecipe)new ShapedOreRecipe(new ItemStack(Items.field_151141_av), new Object[]{"ttt", "tst", "i i", Character.valueOf('t'), "materialTannedLeather", Character.valueOf('s'), new ItemStack(Items.field_151007_F), Character.valueOf('i'), "ingotIron"}));
            }
        }
        if (ConfigManager.instance.sticksFromLeaves) {
            GameRegistry.addRecipe((IRecipe)new ShapelessOreRecipe(Items.field_151055_y, new Object[]{"treeLeaves"}));
        }
        if (ConfigManager.instance.sticksFromSaplings) {
            GameRegistry.addRecipe((IRecipe)new ShapelessOreRecipe(Items.field_151055_y, new Object[]{"treeSapling"}));
        }
        if (ConfigManager.instance.enableNuggetRecipes) {
            this.addIngotToNuggets("ingotIron", "nuggetIron");
            this.addIngotToNuggets("ingotCopper", "nuggetCopper");
            this.addIngotToNuggets("ingotTin", "nuggetTin");
            this.addIngotToNuggets("ingotLead", "nuggetLead");
            this.addIngotToNuggets("ingotSilver", "nuggetSilver");
        }
        if (ConfigManager.instance.enableChainmailCrafting) {
            if (ConfigManager.instance.enableNuggets) {
                GameRegistry.addRecipe((IRecipe)new ShapedOreRecipe(new ItemStack(chainmail), new Object[]{" n ", "n n", " n ", Character.valueOf('n'), "nuggetIron"}));
            }
            GameRegistry.addRecipe((IRecipe)new ShapedOreRecipe(new ItemStack(chainmail, 9), new Object[]{" n ", "n n", " n ", Character.valueOf('n'), "ingotIron"}));
            GameRegistry.addRecipe((ItemStack)new ItemStack((Item)Items.field_151020_U), (Object[])new Object[]{"ccc", "c c", Character.valueOf('c'), chainmail});
            GameRegistry.addRecipe((ItemStack)new ItemStack((Item)Items.field_151023_V), (Object[])new Object[]{"c c", "ccc", "ccc", Character.valueOf('c'), chainmail});
            GameRegistry.addRecipe((ItemStack)new ItemStack((Item)Items.field_151022_W), (Object[])new Object[]{"ccc", "c c", "c c", Character.valueOf('c'), chainmail});
            GameRegistry.addRecipe((ItemStack)new ItemStack((Item)Items.field_151029_X), (Object[])new Object[]{"c c", "c c", Character.valueOf('c'), chainmail});
        }
        if (ConfigManager.instance.enableRocks) {
            EntityRegistry.registerModEntity(EntityRock.class, (String)"ThrownRock", (int)entityId++, (Object)this, (int)80, (int)3, (boolean)true);
            logger.debug("Last used id: %i", new Object[]{entityId});
            this.addSmeltingNugget(iron_ore_rock, "nuggetIron");
            this.addSmeltingNugget(gold_ore_rock, "nuggetGold");
            this.addSmeltingNugget(copper_ore_rock, "nuggetCopper");
            this.addSmeltingNugget(tin_ore_rock, "nuggetTin");
            this.addSmeltingNugget(lead_ore_rock, "nuggetLead");
            this.addSmeltingNugget(silver_ore_rock, "nuggetSilver");
            GameRegistry.addRecipe((ItemStack)new ItemStack(Blocks.field_150347_e), (Object[])new Object[]{"rrr", "rcr", "rrr", Character.valueOf('r'), rock_normal, Character.valueOf('c'), Items.field_151119_aD});
            GameRegistry.addRecipe((ItemStack)new ItemStack(Blocks.field_150348_b, 1, 5), (Object[])new Object[]{"rrr", "rcr", "rrr", Character.valueOf('r'), rock_andesite, Character.valueOf('c'), Items.field_151119_aD});
            GameRegistry.addRecipe((ItemStack)new ItemStack(Blocks.field_150348_b, 1, 3), (Object[])new Object[]{"rrr", "rcr", "rrr", Character.valueOf('r'), rock_diorite, Character.valueOf('c'), Items.field_151119_aD});
            GameRegistry.addRecipe((ItemStack)new ItemStack(Blocks.field_150348_b, 1, 1), (Object[])new Object[]{"rrr", "rcr", "rrr", Character.valueOf('r'), rock_granite, Character.valueOf('c'), Items.field_151119_aD});
            GameRegistry.addRecipe((IRecipe)new ShapedOreRecipe(new ItemStack(Blocks.field_150351_n), new Object[]{"rr", "rr", Character.valueOf('r'), "rock"}));
            GameRegistry.addShapelessRecipe((ItemStack)new ItemStack(rock, 4, 0), (Object[])new Object[]{Blocks.field_150351_n});
            GameRegistry.addShapelessRecipe((ItemStack)new ItemStack(Items.field_151145_ak), (Object[])new Object[]{Blocks.field_150351_n, Blocks.field_150351_n, Blocks.field_150351_n, Blocks.field_150351_n});
        }
    }

    @Mod.EventHandler
    public void postInit(FMLPostInitializationEvent event) {
        ItemStack output;
        IRecipe r;
        boolean removed;
        int i;
        List recipes;
        if (ConfigManager.instance.removeSticksFromPlanks) {
            recipes = CraftingManager.func_77594_a().func_77592_b();
            i = 0;
            while (i < recipes.size()) {
                removed = false;
                r = (IRecipe)recipes.get(i);
                if (r instanceof ShapedOreRecipe && (output = r.func_77571_b()) != null && output.func_77973_b() == Items.field_151055_y) {
                    recipes.remove(r);
                    removed = true;
                }
                if (removed) continue;
                ++i;
            }
        }
        if (ConfigManager.instance.enableChopping) {
            if (ConfigManager.instance.importPlanksRecipes || ConfigManager.instance.removePlanksRecipes) {
                recipes = CraftingManager.func_77594_a().func_77592_b();
                i = 0;
                while (i < recipes.size()) {
                    removed = false;
                    r = (IRecipe)recipes.get(i);
                    output = r.func_77571_b();
                    if (output != null && Survivalist.hasOreName(output, "plankWood")) {
                        ShapedRecipes rcp;
                        ArrayList inputs = null;
                        if (r instanceof ShapedRecipes) {
                            rcp = (ShapedRecipes)r;
                            inputs = Lists.newArrayList((Object[])rcp.field_77574_d);
                        } else if (r instanceof ShapelessRecipes) {
                            rcp = (ShapelessRecipes)r;
                            inputs = Lists.newArrayList((Iterable)rcp.field_77579_b);
                        } else if (r instanceof ShapedOreRecipe) {
                            rcp = (ShapedOreRecipe)r;
                            inputs = Lists.newArrayList((Object[])rcp.getInput());
                        } else if (r instanceof ShapelessOreRecipe) {
                            rcp = (ShapelessOreRecipe)r;
                            inputs = Lists.newArrayList((Iterable)rcp.getInput());
                        } else {
                            logger.warn("Unknown recipe type with planks output (" + output.func_77973_b().getRegistryName() + "): " + r.getClass().getName());
                        }
                        if (inputs != null) {
                            ItemStack logInput = null;
                            Object oreInput = null;
                            for (Object input : inputs) {
                                if (input instanceof ItemStack) {
                                    ItemStack stack = (ItemStack)input;
                                    if (!Survivalist.hasOreName(stack, "logWood") || logInput != null || oreInput != null) {
                                        logInput = null;
                                        oreInput = null;
                                        break;
                                    }
                                    logInput = stack;
                                    continue;
                                }
                                if (!(input instanceof String)) continue;
                                logger.warn("A recipe with planks output uses ore dictionary string as input. This is not supported yet.");
                                logInput = null;
                                oreInput = null;
                                break;
                            }
                            if (logInput != null) {
                                if (ConfigManager.instance.removePlanksRecipes) {
                                    removed = recipes.remove(r);
                                }
                                if (ConfigManager.instance.importPlanksRecipes) {
                                    Choppable.registerRecipe(logInput.func_77946_l(), output.func_77946_l());
                                }
                            } else if (oreInput != null) {
                                if (ConfigManager.instance.removePlanksRecipes) {
                                    removed = recipes.remove(r);
                                }
                                if (ConfigManager.instance.importPlanksRecipes) {
                                    Choppable.registerRecipe(logInput.func_77946_l(), output.func_77946_l());
                                }
                            }
                        }
                    }
                    if (removed) continue;
                    ++i;
                }
                GameRegistry.addRecipe((IRecipe)new ShapelessOreRecipe(new ItemStack((Block)chopping_block), new Object[]{"logWood"}));
            }
            if (ConfigManager.instance.removeSticksFromPlanks) {
                Choppable.registerStockRecipes();
            }
        }
    }

    public static boolean hasOreName(ItemStack stack, String oreName) {
        if (stack.func_77973_b() == null) {
            logger.warn("Detected ItemStack with null item inside!");
            return false;
        }
        int id = OreDictionary.getOreID((String)oreName);
        for (int i : OreDictionary.getOreIDs((ItemStack)stack)) {
            if (i != id) continue;
            return true;
        }
        return false;
    }

    private void addIngotToNuggets(String oreIngot, String oreNugget) {
        List matches2;
        List matches1 = OreDictionary.getOres((String)oreIngot);
        if (matches1.size() > 0) {
            GameRegistry.addRecipe((IRecipe)new ShapedOreRecipe((ItemStack)matches1.get(0), new Object[]{"nnn", "nnn", "nnn", Character.valueOf('n'), oreNugget}));
        }
        if ((matches2 = OreDictionary.getOres((String)oreNugget)).size() > 0) {
            ItemStack output = ((ItemStack)matches2.get(0)).func_77946_l();
            output.field_77994_a = 9;
            GameRegistry.addRecipe((IRecipe)new ShapelessOreRecipe(output, new Object[]{oreIngot}));
        }
    }

    private void addSmeltingNugget(ItemStack stack, String ore) {
        List matches = OreDictionary.getOres((String)ore);
        if (matches.size() > 0) {
            GameRegistry.addSmelting((ItemStack)stack, (ItemStack)((ItemStack)matches.get(0)), (float)0.1f);
        }
    }

    public static ResourceLocation location(String path) {
        return new ResourceLocation("survivalist", path);
    }

    static {
        TANNED_LEATHER = EnumHelper.addArmorMaterial((String)"tanned_leather", (String)"survivalist:tanned_leather", (int)12, (int[])new int[]{2, 4, 3, 1}, (int)15, (SoundEvent)SoundEvents.field_187728_s, (float)1.0f);
    }
}

