/*
 * Decompiled with CFR 0.152.
 */
package gigaherz.survivalist.api;

import com.google.common.collect.Lists;
import gigaherz.survivalist.Survivalist;
import java.util.List;
import net.minecraft.init.Items;
import net.minecraft.item.ItemStack;
import net.minecraftforge.oredict.OreDictionary;
import org.apache.commons.lang3.tuple.Pair;
import org.apache.commons.lang3.tuple.Triple;

public class Choppable {
    public static final List<Triple<ItemStack, ItemStack, Double>> RECIPES = Lists.newArrayList();
    public static final List<Triple<String, ItemStack, Double>> ORE_RECIPES = Lists.newArrayList();

    public static boolean isValidInput(ItemStack stack) {
        for (Triple<ItemStack, ItemStack, Double> triple : RECIPES) {
            if (!OreDictionary.itemMatches((ItemStack)((ItemStack)triple.getLeft()), (ItemStack)stack, (boolean)false)) continue;
            return true;
        }
        for (Triple triple : ORE_RECIPES) {
            if (!Survivalist.hasOreName(stack, (String)triple.getLeft())) continue;
            return true;
        }
        return false;
    }

    public static Pair<ItemStack, Double> getResults(ItemStack stack) {
        for (Triple<ItemStack, ItemStack, Double> triple : RECIPES) {
            if (!OreDictionary.itemMatches((ItemStack)((ItemStack)triple.getLeft()), (ItemStack)stack, (boolean)false)) continue;
            return Pair.of((Object)((ItemStack)triple.getMiddle()).func_77946_l(), (Object)triple.getRight());
        }
        for (Triple triple : ORE_RECIPES) {
            if (!Survivalist.hasOreName(stack, (String)triple.getLeft())) continue;
            return Pair.of((Object)((ItemStack)triple.getMiddle()).func_77946_l(), (Object)triple.getRight());
        }
        return null;
    }

    public static void registerStockRecipes() {
        Choppable.registerRecipe("plankWood", new ItemStack(Items.field_151055_y), 2.0);
    }

    public static void registerRecipe(ItemStack input, ItemStack output) {
        Choppable.registerRecipe(input, output, 1.0);
    }

    public static void registerRecipe(ItemStack input, ItemStack output, double outputMultiplier) {
        RECIPES.add((Triple<ItemStack, ItemStack, Double>)Triple.of((Object)input, (Object)output, (Object)outputMultiplier));
    }

    public static void registerRecipe(String input, ItemStack output) {
        Choppable.registerRecipe(input, output, 1.0);
    }

    public static void registerRecipe(String input, ItemStack output, double outputMultiplier) {
        ORE_RECIPES.add((Triple<String, ItemStack, Double>)Triple.of((Object)input, (Object)output, (Object)outputMultiplier));
    }
}

