/*
 * Decompiled with CFR 0.152.
 */
package gigaherz.survivalist.api;

import com.google.common.collect.Lists;
import gigaherz.survivalist.ConfigManager;
import gigaherz.survivalist.Survivalist;
import java.util.List;
import javax.annotation.Nullable;
import net.minecraft.init.Items;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import org.apache.commons.lang3.tuple.Triple;

public class Dryable {
    public static final List<Triple<ItemStack, Integer, ItemStack>> RECIPES = Lists.newArrayList();

    public static void register() {
        if (ConfigManager.instance.enableLeatherTanning) {
            Dryable.registerDryingRecipe(Items.field_151116_aA, Survivalist.tanned_leather, 600);
        }
        if (ConfigManager.instance.enableMeatRotting) {
            Dryable.registerDryingRecipe(Items.field_151082_bd, Items.field_151078_bh, 300);
            Dryable.registerDryingRecipe(Items.field_179561_bm, Items.field_151078_bh, 300);
            Dryable.registerDryingRecipe(Items.field_151147_al, Items.field_151078_bh, 300);
        }
        if (ConfigManager.instance.enableJerky) {
            if (ConfigManager.instance.enableRottenDrying) {
                Dryable.registerDryingRecipe(Items.field_151078_bh, Survivalist.jerky, 300);
            }
            if (ConfigManager.instance.enableMeatDrying) {
                Dryable.registerDryingRecipe(Items.field_151083_be, Survivalist.jerky, 300);
                Dryable.registerDryingRecipe(Items.field_179557_bn, Survivalist.jerky, 300);
                Dryable.registerDryingRecipe(Items.field_151157_am, Survivalist.jerky, 300);
            }
        }
    }

    public static void registerDryingRecipe(Item input, Item output, int time) {
        Dryable.registerDryingRecipe(new ItemStack(input), new ItemStack(output), time);
    }

    public static void registerDryingRecipe(Item input, ItemStack output, int time) {
        Dryable.registerDryingRecipe(new ItemStack(input), output, time);
    }

    public static void registerDryingRecipe(ItemStack input, Item output, int time) {
        Dryable.registerDryingRecipe(input, new ItemStack(output), time);
    }

    public static void registerDryingRecipe(ItemStack input, ItemStack output, int time) {
        RECIPES.add((Triple<ItemStack, Integer, ItemStack>)Triple.of((Object)input, (Object)time, (Object)output));
    }

    public static int getDryingTime(@Nullable ItemStack stack) {
        if (stack == null) {
            return 0;
        }
        for (Triple<ItemStack, Integer, ItemStack> scraping : RECIPES) {
            ItemStack source = (ItemStack)scraping.getLeft();
            if (!ItemStack.func_179545_c((ItemStack)source, (ItemStack)stack)) continue;
            return (Integer)scraping.getMiddle();
        }
        return 0;
    }

    @Nullable
    public static ItemStack getDryingResult(@Nullable ItemStack stack) {
        if (stack == null) {
            return null;
        }
        for (Triple<ItemStack, Integer, ItemStack> scraping : RECIPES) {
            ItemStack source = (ItemStack)scraping.getLeft();
            if (!ItemStack.func_179545_c((ItemStack)source, (ItemStack)stack)) continue;
            return ((ItemStack)scraping.getRight()).func_77946_l();
        }
        return null;
    }
}

