/*
 * Decompiled with CFR 0.152.
 */
package gigaherz.survivalist.client;

import gigaherz.survivalist.ISidedProxy;
import gigaherz.survivalist.Survivalist;
import gigaherz.survivalist.chopblock.RenderChoppingBlock;
import gigaherz.survivalist.chopblock.TileChopping;
import gigaherz.survivalist.rack.RenderRack;
import gigaherz.survivalist.rack.TileRack;
import gigaherz.survivalist.rocks.EntityRock;
import net.minecraft.block.Block;
import net.minecraft.client.Minecraft;
import net.minecraft.client.renderer.block.model.ModelResourceLocation;
import net.minecraft.client.renderer.entity.Render;
import net.minecraft.client.renderer.entity.RenderManager;
import net.minecraft.client.renderer.entity.RenderSnowball;
import net.minecraft.client.renderer.tileentity.TileEntitySpecialRenderer;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.util.ResourceLocation;
import net.minecraftforge.client.model.ModelLoader;
import net.minecraftforge.client.model.obj.OBJLoader;
import net.minecraftforge.fml.client.registry.ClientRegistry;
import net.minecraftforge.fml.client.registry.IRenderFactory;
import net.minecraftforge.fml.client.registry.RenderingRegistry;

public class ClientProxy
implements ISidedProxy {
    @Override
    public void preInit() {
        OBJLoader.INSTANCE.addDomain("survivalist");
        this.registerModels();
        RenderingRegistry.registerEntityRenderingHandler(EntityRock.class, (IRenderFactory)new IRenderFactory<EntityRock>(){

            public Render<? super EntityRock> createRenderFor(RenderManager manager) {
                return new RenderSnowball(manager, Survivalist.rock, Minecraft.func_71410_x().func_175599_af());
            }
        });
        ClientRegistry.bindTileEntitySpecialRenderer(TileRack.class, (TileEntitySpecialRenderer)new RenderRack());
        ClientRegistry.bindTileEntitySpecialRenderer(TileChopping.class, (TileEntitySpecialRenderer)new RenderChoppingBlock());
    }

    public void registerModels() {
        if (Survivalist.iron_nugget != null) {
            this.registerItemModel(Survivalist.iron_nugget, "ore=iron");
        }
        if (Survivalist.copper_nugget != null) {
            this.registerItemModel(Survivalist.copper_nugget, "ore=copper");
        }
        if (Survivalist.tin_nugget != null) {
            this.registerItemModel(Survivalist.tin_nugget, "ore=tin");
        }
        if (Survivalist.lead_nugget != null) {
            this.registerItemModel(Survivalist.lead_nugget, "ore=lead");
        }
        if (Survivalist.silver_nugget != null) {
            this.registerItemModel(Survivalist.silver_nugget, "ore=silver");
        }
        if (Survivalist.chainmail != null) {
            this.registerItemModel(Survivalist.chainmail);
        }
        if (Survivalist.tanned_leather != null) {
            this.registerItemModel(Survivalist.tanned_leather);
        }
        if (Survivalist.jerky != null) {
            this.registerItemModel(Survivalist.jerky);
        }
        if (Survivalist.tanned_helmet != null) {
            this.registerItemModel(Survivalist.tanned_helmet, 0, Survivalist.location("tanned_armor"), "part=helmet");
        }
        if (Survivalist.tanned_chestplate != null) {
            this.registerItemModel(Survivalist.tanned_chestplate, 0, Survivalist.location("tanned_armor"), "part=chestplate");
        }
        if (Survivalist.tanned_leggings != null) {
            this.registerItemModel(Survivalist.tanned_leggings, 0, Survivalist.location("tanned_armor"), "part=leggings");
        }
        if (Survivalist.tanned_boots != null) {
            this.registerItemModel(Survivalist.tanned_boots, 0, Survivalist.location("tanned_armor"), "part=boots");
        }
        if (Survivalist.rock_normal != null) {
            this.registerItemModel(Survivalist.rock_normal, "rock=normal");
        }
        if (Survivalist.rock_andesite != null) {
            this.registerItemModel(Survivalist.rock_andesite, "rock=andesite");
        }
        if (Survivalist.rock_diorite != null) {
            this.registerItemModel(Survivalist.rock_diorite, "rock=diorite");
        }
        if (Survivalist.rock_granite != null) {
            this.registerItemModel(Survivalist.rock_granite, "rock=granite");
        }
        if (Survivalist.iron_ore_rock != null) {
            this.registerItemModel(Survivalist.iron_ore_rock, "ore=iron");
        }
        if (Survivalist.gold_ore_rock != null) {
            this.registerItemModel(Survivalist.gold_ore_rock, "ore=gold");
        }
        if (Survivalist.copper_ore_rock != null) {
            this.registerItemModel(Survivalist.copper_ore_rock, "ore=copper");
        }
        if (Survivalist.tin_ore_rock != null) {
            this.registerItemModel(Survivalist.tin_ore_rock, "ore=tin");
        }
        if (Survivalist.lead_ore_rock != null) {
            this.registerItemModel(Survivalist.lead_ore_rock, "ore=lead");
        }
        if (Survivalist.silver_ore_rock != null) {
            this.registerItemModel(Survivalist.silver_ore_rock, "ore=silver");
        }
        if (Survivalist.rack != null) {
            this.registerBlockModelAsItem(Survivalist.rack);
        }
        if (Survivalist.dough != null) {
            this.registerItemModel(Survivalist.dough);
        }
        if (Survivalist.round_bread != null) {
            this.registerItemModel(Survivalist.round_bread);
        }
        if (Survivalist.chopping_block != null) {
            this.registerBlockModelAsItem(Survivalist.chopping_block, 0, "damage=0");
            this.registerBlockModelAsItem(Survivalist.chopping_block, 1, "damage=1");
            this.registerBlockModelAsItem(Survivalist.chopping_block, 2, "damage=2");
        }
    }

    public void registerBlockModelAsItem(Block block) {
        this.registerBlockModelAsItem(block, 0);
    }

    public void registerBlockModelAsItem(Block block, int meta) {
        this.registerBlockModelAsItem(block, meta, "inventory");
    }

    public void registerBlockModelAsItem(Block block, int meta, String variantName) {
        Item item = Item.func_150898_a((Block)block);
        assert (item != null);
        this.registerItemModel(item, meta, variantName);
    }

    public void registerItemModel(Item item) {
        this.registerItemModel(item, 0, "inventory");
    }

    public void registerItemModel(ItemStack stack) {
        this.registerItemModel(stack.func_77973_b(), stack.func_77960_j(), "inventory");
    }

    public void registerItemModel(ItemStack stack, String variantName) {
        this.registerItemModel(stack.func_77973_b(), stack.func_77960_j(), variantName);
    }

    public void registerItemModel(Item item, int meta, String variantName) {
        this.registerItemModel(item, meta, item.getRegistryName(), variantName);
    }

    public void registerItemModel(Item item, int meta, ResourceLocation blockstatesLocation, String variantName) {
        ModelLoader.setCustomModelResourceLocation((Item)item, (int)meta, (ModelResourceLocation)new ModelResourceLocation(blockstatesLocation, variantName));
    }
}

