/*
 * Decompiled with CFR 0.152.
 */
package gigaherz.survivalist.integration.analyzer;

import com.google.common.collect.Lists;
import gigaherz.survivalist.api.Choppable;
import gigaherz.survivalist.client.StackRenderingHelper;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import javax.annotation.Nonnull;
import mezz.jei.api.recipe.BlankRecipeWrapper;
import net.minecraft.client.Minecraft;
import net.minecraft.client.renderer.GlStateManager;
import net.minecraft.client.renderer.ItemModelMesher;
import net.minecraft.init.Items;
import net.minecraft.item.ItemStack;
import org.apache.commons.lang3.tuple.Triple;

public class ChoppingRecipeWrapper
extends BlankRecipeWrapper {
    private List<Object> inputs;
    private List<ItemStack> outputs;
    private double multiplier;

    public static List<ChoppingRecipeWrapper> getRecipes() {
        ArrayList list = Lists.newArrayList();
        for (Triple<ItemStack, ItemStack, Double> triple : Choppable.RECIPES) {
            list.add(new ChoppingRecipeWrapper(triple.getLeft(), ChoppingRecipeWrapper.copyWithSize((ItemStack)triple.getMiddle()), (Double)triple.getRight()));
        }
        for (Triple triple : Choppable.ORE_RECIPES) {
            list.add(new ChoppingRecipeWrapper(triple.getLeft(), ChoppingRecipeWrapper.copyWithSize((ItemStack)triple.getMiddle()), (Double)triple.getRight()));
        }
        return list;
    }

    private static ItemStack copyWithSize(ItemStack middle) {
        middle = middle.func_77946_l();
        middle.field_77994_a = 1;
        return middle;
    }

    private ChoppingRecipeWrapper(Object input, ItemStack output, double multiplier) {
        this.inputs = Collections.singletonList(input);
        this.outputs = Collections.singletonList(output);
        this.multiplier = multiplier;
    }

    @Nonnull
    public List getInputs() {
        return this.inputs;
    }

    @Nonnull
    public List getOutputs() {
        return this.outputs;
    }

    public void drawInfo(@Nonnull Minecraft mc, int recipeWidth, int recipeHeight, int mouseX, int mouseY) {
        super.drawInfo(mc, recipeWidth, recipeHeight, mouseX, mouseY);
        ItemModelMesher mesher = mc.func_175599_af().func_175037_a();
        GlStateManager.func_179094_E();
        GlStateManager.func_179109_b((float)0.0f, (float)0.0f, (float)100.0f);
        long animTick = mc.field_71441_e.func_82737_E();
        int whichAxe = (int)(animTick / 20L % 5L);
        double amount = 1.0;
        ItemStack stack = null;
        switch (whichAxe) {
            case 0: {
                amount = 0.4 * this.multiplier;
                stack = null;
                break;
            }
            case 1: {
                amount = 1.0 * this.multiplier;
                stack = new ItemStack(Items.field_151053_p);
                break;
            }
            case 2: {
                amount = 2.0 * this.multiplier;
                stack = new ItemStack(Items.field_151049_t);
                break;
            }
            case 3: {
                amount = 3.0 * this.multiplier;
                stack = new ItemStack(Items.field_151036_c);
                break;
            }
            case 4: {
                amount = 4.0 * this.multiplier;
                stack = new ItemStack(Items.field_151056_x);
            }
        }
        if (stack != null) {
            StackRenderingHelper.renderItemStack(mesher, mc.field_71446_o, 28, 4, stack, -1);
        }
        String label = amount + "x";
        GlStateManager.func_179094_E();
        GlStateManager.func_179109_b((float)0.0f, (float)0.0f, (float)150.0f);
        mc.field_71466_p.func_175065_a(label, (float)(58 - mc.field_71466_p.func_78256_a(label)), 14.0f, -1, true);
        GlStateManager.func_179121_F();
        GlStateManager.func_179121_F();
    }
}

