/*
 * Decompiled with CFR 0.152.
 */
package gigaherz.survivalist.integration.drying;

import com.google.common.collect.Lists;
import gigaherz.survivalist.api.Dryable;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import javax.annotation.Nonnull;
import mezz.jei.api.recipe.BlankRecipeWrapper;
import net.minecraft.client.Minecraft;
import net.minecraft.client.renderer.GlStateManager;
import net.minecraft.item.ItemStack;
import org.apache.commons.lang3.tuple.Triple;

public class DryingRecipeWrapper
extends BlankRecipeWrapper {
    List<Object> inputs;
    List<ItemStack> outputs;
    int time;

    public static List<DryingRecipeWrapper> getRecipes() {
        ArrayList list = Lists.newArrayList();
        for (Triple<ItemStack, Integer, ItemStack> pair : Dryable.RECIPES) {
            list.add(new DryingRecipeWrapper(pair.getLeft(), (ItemStack)pair.getRight(), (Integer)pair.getMiddle()));
        }
        return list;
    }

    private DryingRecipeWrapper(Object input, ItemStack output, int time) {
        this.inputs = Collections.singletonList(input);
        this.outputs = Collections.singletonList(output);
        this.time = time;
    }

    @Nonnull
    public List getInputs() {
        return this.inputs;
    }

    @Nonnull
    public List getOutputs() {
        return this.outputs;
    }

    public void drawInfo(@Nonnull Minecraft mc, int recipeWidth, int recipeHeight, int mouseX, int mouseY) {
        super.drawInfo(mc, recipeWidth, recipeHeight, mouseX, mouseY);
        String label = (double)this.time / 20.0 + "s";
        GlStateManager.func_179094_E();
        GlStateManager.func_179109_b((float)0.0f, (float)0.0f, (float)150.0f);
        mc.field_71466_p.func_175065_a(label, (float)(58 - mc.field_71466_p.func_78256_a(label)), 14.0f, -1, true);
        GlStateManager.func_179121_F();
    }
}

