/*
 * Decompiled with CFR 0.152.
 */
package com.swyftgaming.swylands;

import com.mojang.brigadier.CommandDispatcher;
import com.swyftgaming.swylands.commands.CommandSkyblockCreate;
import com.swyftgaming.swylands.worldgen.SkyblockWorldEvents;
import com.swyftgaming.swylands.worldgen.WorldTypeSkyblock;
import java.util.stream.Collectors;
import net.minecraft.command.CommandSource;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.DeferredWorkQueue;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.fml.event.lifecycle.FMLCommonSetupEvent;
import net.minecraftforge.fml.event.lifecycle.InterModProcessEvent;
import net.minecraftforge.fml.event.server.FMLServerStartingEvent;
import net.minecraftforge.fml.javafmlmod.FMLJavaModLoadingContext;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

@Mod(value="swylands")
public class Swylands {
    private static final Logger LOGGER = LogManager.getLogger();

    public Swylands() {
        FMLJavaModLoadingContext.get().getModEventBus().addListener(this::setup);
        FMLJavaModLoadingContext.get().getModEventBus().addListener(this::processIMC);
        MinecraftForge.EVENT_BUS.register((Object)this);
    }

    private void setup(FMLCommonSetupEvent event) {
        MinecraftForge.EVENT_BUS.register(SkyblockWorldEvents.class);
        DeferredWorkQueue.runLater(() -> new WorldTypeSkyblock());
    }

    private void processIMC(InterModProcessEvent event) {
        LOGGER.info("Got IMC {}", event.getIMCStream().map(m -> m.getMessageSupplier().get()).collect(Collectors.toList()));
    }

    @SubscribeEvent
    public void onServerStarting(FMLServerStartingEvent event) {
        CommandSkyblockCreate.register((CommandDispatcher<CommandSource>)event.getCommandDispatcher());
    }
}

