/*
 * Decompiled with CFR 0.152.
 */
package com.swyftgaming.swylands.worldgen;

import com.swyftgaming.swylands.worldgen.WorldTypeSkyblock;
import net.minecraft.block.BlockState;
import net.minecraft.block.Blocks;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.entity.player.ServerPlayerEntity;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.nbt.INBT;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.World;
import net.minecraft.world.dimension.DimensionType;
import net.minecraft.world.server.ServerWorld;
import net.minecraftforge.event.entity.living.LivingEvent;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.server.ServerLifecycleHooks;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class SkyblockWorldEvents {
    private static final Logger LOGGER = LogManager.getLogger();
    private static final String TAG_MADE_ISLAND = "Swylands-MadeIsland";
    private static final String TAG_HAS_OWN_ISLAND = "Swylands-HasOwnIsland";
    private static final String TAG_ISLAND_X = "Swylands-IslandX";
    private static final String TAG_ISLAND_Y = "Swylands-IslandY";
    private static final String TAG_ISLAND_Z = "Swylands-IslandZ";

    private SkyblockWorldEvents() {
    }

    @SubscribeEvent
    public static void onPlayerUpdate(LivingEvent.LivingUpdateEvent event) {
        if (event.getEntityLiving() instanceof PlayerEntity && !event.getEntityLiving().field_70170_p.field_72995_K) {
            PlayerEntity player = (PlayerEntity)event.getEntityLiving();
            CompoundNBT data = player.getPersistentData();
            if (!data.func_74764_b("PlayerPersisted")) {
                data.func_218657_a("PlayerPersisted", (INBT)new CompoundNBT());
            }
            CompoundNBT persist = data.func_74775_l("PlayerPersisted");
            if (player.field_70173_aa > 3 && !persist.func_74767_n(TAG_MADE_ISLAND)) {
                ServerWorld overworld = ServerLifecycleHooks.getCurrentServer().func_71218_a(DimensionType.field_223227_a_);
                World world = player.field_70170_p;
                if (WorldTypeSkyblock.isWorldSkyblock(world)) {
                    BlockPos coords = world.func_175694_M();
                    if (coords.func_177956_o() <= 0) {
                        coords = new BlockPos(coords.func_177958_n(), 64, coords.func_177952_p());
                        world.func_175652_B(coords);
                    }
                    if (world.func_180495_p(coords.func_177979_c(4)).func_177230_c() != Blocks.field_150357_h && world == overworld) {
                        SkyblockWorldEvents.spawnPlayer(player, coords, false);
                    }
                }
                persist.func_74757_a(TAG_MADE_ISLAND, true);
            }
        }
    }

    public static void spawnPlayer(PlayerEntity player, BlockPos pos, boolean fabricated) {
        CompoundNBT persist;
        CompoundNBT data = player.getPersistentData();
        if (!data.func_74764_b("PlayerPersisted")) {
            data.func_218657_a("PlayerPersisted", (INBT)new CompoundNBT());
        }
        if (!(persist = data.func_74775_l("PlayerPersisted")).func_74767_n(TAG_HAS_OWN_ISLAND)) {
            SkyblockWorldEvents.createSkyblock(player.field_70170_p, pos);
            if (player instanceof ServerPlayerEntity) {
                ServerPlayerEntity pmp = (ServerPlayerEntity)player;
                pmp.func_70634_a((double)pos.func_177958_n() + 0.5, (double)pos.func_177956_o() + 1.6, (double)pos.func_177952_p() + 0.5);
                pmp.setSpawnPoint(pos, true, player.field_70170_p.func_201675_m().func_186058_p());
            }
            if (fabricated) {
                persist.func_74757_a(TAG_HAS_OWN_ISLAND, true);
                persist.func_74780_a(TAG_ISLAND_X, player.field_70165_t);
                persist.func_74780_a(TAG_ISLAND_Y, player.field_70163_u);
                persist.func_74780_a(TAG_ISLAND_Z, player.field_70161_v);
            }
        } else {
            double posX = persist.func_74769_h(TAG_ISLAND_X);
            double posY = persist.func_74769_h(TAG_ISLAND_Y);
            double posZ = persist.func_74769_h(TAG_ISLAND_Z);
            if (player instanceof ServerPlayerEntity) {
                ServerPlayerEntity pmp = (ServerPlayerEntity)player;
                pmp.func_70634_a(posX, posY, posZ);
            }
        }
    }

    /*
     * Opcode count of 21918 triggered aggressive code reduction.  Override with --aggressivesizethreshold.
     */
    public static void createSkyblock(World world, BlockPos pos) {
        String[][] blocksToPlace = new String[][]{{"-6", "-2", "2", "minecraft:grass_block"}, {"-6", "-2", "3", "minecraft:grass_block"}, {"-6", "-2", "4", "minecraft:grass_block"}, {"-6", "-1", "4", "minecraft:dandelion"}, {"-5", "-3", "0", "minecraft:dirt"}, {"-5", "-3", "1", "minecraft:stone"}, {"-5", "-3", "2", "minecraft:stone"}, {"-5", "-3", "3", "minecraft:stone"}, {"-5", "-3", "4", "minecraft:stone"}, {"-5", "-3", "6", "minecraft:stone"}, {"-5", "-2", "-1", "minecraft:grass_block"}, {"-5", "-2", "0", "minecraft:grass_block"}, {"-5", "-2", "1", "minecraft:grass_block"}, {"-5", "-2", "2", "minecraft:grass_block"}, {"-5", "-2", "3", "minecraft:grass_block"}, {"-5", "-2", "4", "minecraft:grass_block"}, {"-5", "-2", "5", "minecraft:grass_block"}, {"-5", "-2", "6", "minecraft:grass_block"}, {"-5", "-2", "7", "minecraft:grass_block"}, {"-5", "-1", "3", "minecraft:grass"}, {"-5", "-1", "4", "minecraft:tall_grass"}, {"-5", "-1", "5", "minecraft:poppy"}, {"-5", "0", "4", "minecraft:tall_grass"}, {"-4", "-5", "2", "minecraft:stone"}, {"-4", "-5", "3", "minecraft:stone"}, {"-4", "-4", "1", "minecraft:cobblestone"}, {"-4", "-4", "2", "minecraft:stone"}, {"-4", "-4", "3", "minecraft:stone"}, {"-4", "-4", "4", "minecraft:stone"}, {"-4", "-4", "5", "minecraft:stone"}, {"-4", "-3", "-2", "minecraft:dirt"}, {"-4", "-3", "-1", "minecraft:dirt"}, {"-4", "-3", "0", "minecraft:stone"}, {"-4", "-3", "1", "minecraft:dirt"}, {"-4", "-3", "2", "minecraft:stone"}, {"-4", "-3", "3", "minecraft:stone"}, {"-4", "-3", "4", "minecraft:dirt"}, {"-4", "-3", "5", "minecraft:stone"}, {"-4", "-3", "6", "minecraft:cobblestone"}, {"-4", "-2", "-2", "minecraft:grass_block"}, {"-4", "-2", "-1", "minecraft:cobblestone"}, {"-4", "-2", "0", "minecraft:grass_block"}, {"-4", "-2", "1", "minecraft:stone"}, {"-4", "-2", "2", "minecraft:stone"}, {"-4", "-2", "3", "minecraft:cobblestone"}, {"-4", "-2", "4", "minecraft:dirt"}, {"-4", "-2", "5", "minecraft:dirt"}, {"-4", "-2", "6", "minecraft:dirt"}, {"-4", "-2", "7", "minecraft:dirt"}, {"-4", "-2", "8", "minecraft:dirt"}, {"-4", "-1", "3", "minecraft:grass_block"}, {"-4", "-1", "4", "minecraft:grass_block"}, {"-4", "-1", "5", "minecraft:stone"}, {"-4", "-1", "6", "minecraft:dirt"}, {"-4", "-1", "7", "minecraft:cobblestone"}, {"-4", "-1", "8", "minecraft:stone"}, {"-4", "-1", "9", "minecraft:dirt"}, {"-4", "0", "3", "minecraft:poppy"}, {"-4", "0", "6", "minecraft:grass_block"}, {"-4", "0", "7", "minecraft:grass_block"}, {"-4", "0", "8", "minecraft:stone"}, {"-4", "0", "9", "minecraft:stone"}, {"-3", "-5", "1", "minecraft:stone"}, {"-3", "-5", "2", "minecraft:stone"}, {"-3", "-5", "3", "minecraft:stone"}, {"-3", "-4", "0", "minecraft:stone"}, {"-3", "-4", "1", "minecraft:stone"}, {"-3", "-4", "2", "minecraft:stone"}, {"-3", "-4", "3", "minecraft:stone"}, {"-3", "-4", "4", "minecraft:cobblestone"}, {"-3", "-4", "5", "minecraft:cobblestone"}, {"-3", "-3", "-3", "minecraft:grass_block"}, {"-3", "-3", "-2", "minecraft:stone"}, {"-3", "-3", "-1", "minecraft:stone"}, {"-3", "-3", "0", "minecraft:stone"}, {"-3", "-3", "1", "minecraft:dirt"}, {"-3", "-3", "2", "minecraft:dirt"}, {"-3", "-3", "3", "minecraft:stone"}, {"-3", "-3", "4", "minecraft:stone"}, {"-3", "-3", "5", "minecraft:stone"}, {"-3", "-3", "6", "minecraft:stone"}, {"-3", "-3", "7", "minecraft:stone"}, {"-3", "-2", "-2", "minecraft:grass_block"}, {"-3", "-2", "-1", "minecraft:grass_block"}, {"-3", "-2", "0", "minecraft:dirt"}, {"-3", "-2", "1", "minecraft:stone"}, {"-3", "-2", "2", "minecraft:cobblestone"}, {"-3", "-2", "3", "minecraft:cobblestone"}, {"-3", "-2", "4", "minecraft:dirt"}, {"-3", "-2", "5", "minecraft:dirt"}, {"-3", "-2", "6", "minecraft:stone"}, {"-3", "-2", "7", "minecraft:stone"}, {"-3", "-2", "8", "minecraft:stone"}, {"-3", "-2", "9", "minecraft:stone"}, {"-3", "-1", "0", "minecraft:grass_block"}, {"-3", "-1", "1", "minecraft:grass_block"}, {"-3", "-1", "2", "minecraft:stone"}, {"-3", "-1", "3", "minecraft:dirt"}, {"-3", "-1", "4", "minecraft:dirt"}, {"-3", "-1", "5", "minecraft:dirt"}, {"-3", "-1", "6", "minecraft:stone"}, {"-3", "-1", "7", "minecraft:stone"}, {"-3", "-1", "8", "minecraft:stone"}, {"-3", "-1", "9", "minecraft:dirt"}, {"-3", "-1", "10", "minecraft:dirt"}, {"-3", "0", "2", "minecraft:stone"}, {"-3", "0", "3", "minecraft:grass_block"}, {"-3", "0", "4", "minecraft:grass_block"}, {"-3", "0", "5", "minecraft:grass_block"}, {"-3", "0", "6", "minecraft:stone"}, {"-3", "0", "7", "minecraft:dirt"}, {"-3", "0", "8", "minecraft:stone"}, {"-3", "0", "9", "minecraft:dirt"}, {"-3", "0", "10", "minecraft:grass_block"}, {"-3", "1", "6", "minecraft:grass_block"}, {"-3", "1", "7", "minecraft:stone"}, {"-3", "1", "8", "minecraft:dirt"}, {"-3", "1", "9", "minecraft:dirt"}, {"-3", "1", "10", "minecraft:tall_grass"}, {"-3", "2", "7", "minecraft:grass_block"}, {"-3", "2", "8", "minecraft:grass_block"}, {"-3", "2", "9", "minecraft:grass_block"}, {"-3", "2", "10", "minecraft:tall_grass"}, {"-3", "3", "7", "minecraft:oak_fence"}, {"-3", "3", "8", "minecraft:oak_fence"}, {"-3", "3", "9", "minecraft:oak_fence"}, {"-2", "-6", "1", "minecraft:stone"}, {"-2", "-6", "3", "minecraft:stone"}, {"-2", "-5", "0", "minecraft:stone"}, {"-2", "-5", "1", "minecraft:stone"}, {"-2", "-5", "2", "minecraft:stone"}, {"-2", "-5", "3", "minecraft:stone"}, {"-2", "-5", "6", "minecraft:stone"}, {"-2", "-4", "-2", "minecraft:stone"}, {"-2", "-4", "-1", "minecraft:stone"}, {"-2", "-4", "0", "minecraft:cobblestone"}, {"-2", "-4", "1", "minecraft:cobblestone"}, {"-2", "-4", "2", "minecraft:stone"}, {"-2", "-4", "3", "minecraft:cobblestone"}, {"-2", "-4", "4", "minecraft:cobblestone"}, {"-2", "-4", "5", "minecraft:cobblestone"}, {"-2", "-4", "6", "minecraft:cobblestone"}, {"-2", "-4", "7", "minecraft:stone"}, {"-2", "-3", "-4", "minecraft:stone"}, {"-2", "-3", "-3", "minecraft:dirt"}, {"-2", "-3", "-2", "minecraft:stone"}, {"-2", "-3", "-1", "minecraft:cobblestone"}, {"-2", "-3", "0", "minecraft:stone"}, {"-2", "-3", "1", "minecraft:stone"}, {"-2", "-3", "2", "minecraft:stone"}, {"-2", "-3", "3", "minecraft:stone"}, {"-2", "-3", "4", "minecraft:stone"}, {"-2", "-3", "5", "minecraft:stone"}, {"-2", "-3", "6", "minecraft:stone"}, {"-2", "-3", "7", "minecraft:cobblestone"}, {"-2", "-3", "8", "minecraft:stone"}, {"-2", "-2", "-3", "minecraft:grass_block"}, {"-2", "-2", "-2", "minecraft:stone"}, {"-2", "-2", "-1", "minecraft:dirt"}, {"-2", "-2", "0", "minecraft:dirt"}, {"-2", "-2", "1", "minecraft:dirt"}, {"-2", "-2", "2", "minecraft:stone"}, {"-2", "-2", "3", "minecraft:stone"}, {"-2", "-2", "4", "minecraft:dirt"}, {"-2", "-2", "5", "minecraft:stone"}, {"-2", "-2", "6", "minecraft:stone"}, {"-2", "-2", "7", "minecraft:stone"}, {"-2", "-2", "8", "minecraft:stone"}, {"-2", "-2", "9", "minecraft:stone"}, {"-2", "-2", "10", "minecraft:stone"}, {"-2", "-1", "-3", "minecraft:grass"}, {"-2", "-1", "-1", "minecraft:grass_block"}, {"-2", "-1", "0", "minecraft:dirt"}, {"-2", "-1", "1", "minecraft:stone"}, {"-2", "-1", "2", "minecraft:dirt"}, {"-2", "-1", "3", "minecraft:dirt"}, {"-2", "-1", "4", "minecraft:stone"}, {"-2", "-1", "5", "minecraft:stone"}, {"-2", "-1", "6", "minecraft:stone"}, {"-2", "-1", "7", "minecraft:stone"}, {"-2", "-1", "8", "minecraft:stone"}, {"-2", "-1", "9", "minecraft:cobblestone"}, {"-2", "-1", "10", "minecraft:dirt"}, {"-2", "-1", "11", "minecraft:cobblestone"}, {"-2", "0", "0", "minecraft:grass_block"}, {"-2", "0", "1", "minecraft:stone"}, {"-2", "0", "2", "minecraft:cobblestone"}, {"-2", "0", "3", "minecraft:dirt"}, {"-2", "0", "4", "minecraft:dirt"}, {"-2", "0", "5", "minecraft:dirt"}, {"-2", "0", "6", "minecraft:dirt"}, {"-2", "0", "7", "minecraft:dirt"}, {"-2", "0", "8", "minecraft:stone"}, {"-2", "0", "9", "minecraft:dirt"}, {"-2", "0", "10", "minecraft:dirt"}, {"-2", "0", "11", "minecraft:grass_block"}, {"-2", "1", "0", "minecraft:oak_fence"}, {"-2", "1", "3", "minecraft:oak_slab"}, {"-2", "1", "4", "minecraft:grass_block"}, {"-2", "1", "5", "minecraft:dirt"}, {"-2", "1", "6", "minecraft:dirt"}, {"-2", "1", "7", "minecraft:dirt"}, {"-2", "1", "8", "minecraft:stone"}, {"-2", "1", "9", "minecraft:dirt"}, {"-2", "1", "10", "minecraft:grass_block"}, {"-2", "1", "11", "minecraft:dandelion"}, {"-2", "2", "0", "minecraft:lantern"}, {"-2", "2", "5", "minecraft:grass_block"}, {"-2", "2", "6", "minecraft:grass_block"}, {"-2", "2", "7", "minecraft:grass_block"}, {"-2", "2", "8", "minecraft:stone"}, {"-2", "2", "9", "minecraft:dirt"}, {"-2", "3", "9", "minecraft:cobblestone"}, {"-2", "7", "4", "minecraft:oak_leaves"}, {"-2", "7", "5", "minecraft:oak_leaves"}, {"-2", "7", "6", "minecraft:oak_leaves"}, {"-2", "7", "7", "minecraft:oak_leaves"}, {"-2", "7", "8", "minecraft:oak_leaves"}, {"-2", "8", "5", "minecraft:oak_leaves"}, {"-2", "8", "6", "minecraft:oak_leaves"}, {"-2", "8", "7", "minecraft:oak_leaves"}, {"-2", "8", "8", "minecraft:oak_leaves"}, {"-2", "8", "9", "minecraft:oak_leaves"}, {"-2", "9", "5", "minecraft:oak_leaves"}, {"-2", "9", "6", "minecraft:oak_leaves"}, {"-2", "9", "7", "minecraft:oak_leaves"}, {"-2", "9", "8", "minecraft:oak_leaves"}, {"-1", "-7", "1", "minecraft:cobblestone"}, {"-1", "-6", "0", "minecraft:stone"}, {"-1", "-6", "1", "minecraft:stone"}, {"-1", "-6", "2", "minecraft:stone"}, {"-1", "-5", "-2", "minecraft:stone"}, {"-1", "-5", "-1", "minecraft:stone"}, {"-1", "-5", "0", "minecraft:stone"}, {"-1", "-5", "1", "minecraft:stone"}, {"-1", "-5", "2", "minecraft:stone"}, {"-1", "-5", "3", "minecraft:stone"}, {"-1", "-5", "4", "minecraft:stone"}, {"-1", "-5", "5", "minecraft:stone"}, {"-1", "-5", "6", "minecraft:stone"}, {"-1", "-5", "7", "minecraft:stone"}, {"-1", "-4", "-3", "minecraft:cobblestone"}, {"-1", "-4", "-2", "minecraft:cobblestone"}, {"-1", "-4", "-1", "minecraft:stone"}, {"-1", "-4", "0", "minecraft:stone"}, {"-1", "-4", "1", "minecraft:cobblestone"}, {"-1", "-4", "2", "minecraft:stone"}, {"-1", "-4", "3", "minecraft:stone"}, {"-1", "-4", "4", "minecraft:stone"}, {"-1", "-4", "5", "minecraft:stone"}, {"-1", "-4", "6", "minecraft:cobblestone"}, {"-1", "-4", "7", "minecraft:stone"}, {"-1", "-4", "8", "minecraft:stone"}, {"-1", "-3", "-5", "minecraft:stone"}, {"-1", "-3", "-4", "minecraft:dirt"}, {"-1", "-3", "-3", "minecraft:stone"}, {"-1", "-3", "-2", "minecraft:stone"}, {"-1", "-3", "-1", "minecraft:stone"}, {"-1", "-3", "0", "minecraft:stone"}, {"-1", "-3", "1", "minecraft:cobblestone"}, {"-1", "-3", "2", "minecraft:stone"}, {"-1", "-3", "3", "minecraft:stone"}, {"-1", "-3", "4", "minecraft:stone"}, {"-1", "-3", "5", "minecraft:stone"}, {"-1", "-3", "6", "minecraft:stone"}, {"-1", "-3", "7", "minecraft:stone"}, {"-1", "-3", "8", "minecraft:stone"}, {"-1", "-2", "-4", "minecraft:grass_block"}, {"-1", "-2", "-3", "minecraft:grass_block"}, {"-1", "-2", "-2", "minecraft:grass_block"}, {"-1", "-2", "-1", "minecraft:dirt"}, {"-1", "-2", "0", "minecraft:dirt"}, {"-1", "-2", "1", "minecraft:stone"}, {"-1", "-2", "2", "minecraft:stone"}, {"-1", "-2", "3", "minecraft:stone"}, {"-1", "-2", "4", "minecraft:stone"}, {"-1", "-2", "5", "minecraft:stone"}, {"-1", "-2", "6", "minecraft:stone"}, {"-1", "-2", "7", "minecraft:stone"}, {"-1", "-2", "8", "minecraft:stone"}, {"-1", "-2", "9", "minecraft:stone"}, {"-1", "-2", "10", "minecraft:stone"}, {"-1", "-2", "11", "minecraft:stone"}, {"-1", "-1", "-4", "minecraft:grass"}, {"-1", "-1", "-3", "minecraft:grass"}, {"-1", "-1", "-1", "minecraft:grass_block"}, {"-1", "-1", "0", "minecraft:dirt"}, {"-1", "-1", "1", "minecraft:cobblestone"}, {"-1", "-1", "2", "minecraft:dirt"}, {"-1", "-1", "3", "minecraft:stone"}, {"-1", "-1", "4", "minecraft:stone"}, {"-1", "-1", "5", "minecraft:cobblestone"}, {"-1", "-1", "6", "minecraft:stone"}, {"-1", "-1", "7", "minecraft:cobblestone"}, {"-1", "-1", "8", "minecraft:stone"}, {"-1", "-1", "9", "minecraft:dirt"}, {"-1", "-1", "10", "minecraft:stone"}, {"-1", "-1", "11", "minecraft:dirt"}, {"-1", "-1", "12", "minecraft:stone"}, {"-1", "0", "-1", "minecraft:grass"}, {"-1", "0", "0", "minecraft:grass_block"}, {"-1", "0", "1", "minecraft:grass_block"}, {"-1", "0", "2", "minecraft:grass_block"}, {"-1", "0", "3", "minecraft:dirt"}, {"-1", "0", "4", "minecraft:stone"}, {"-1", "0", "5", "minecraft:dirt"}, {"-1", "0", "6", "minecraft:dirt"}, {"-1", "0", "7", "minecraft:dirt"}, {"-1", "0", "8", "minecraft:dirt"}, {"-1", "0", "9", "minecraft:dirt"}, {"-1", "0", "10", "minecraft:cobblestone"}, {"-1", "0", "11", "minecraft:grass_block"}, {"-1", "0", "12", "minecraft:grass_block"}, {"-1", "1", "0", "minecraft:grass"}, {"-1", "1", "3", "minecraft:oak_slab"}, {"-1", "1", "4", "minecraft:dirt"}, {"-1", "1", "5", "minecraft:dirt"}, {"-1", "1", "6", "minecraft:dirt"}, {"-1", "1", "7", "minecraft:dirt"}, {"-1", "1", "8", "minecraft:stone"}, {"-1", "1", "9", "minecraft:dirt"}, {"-1", "1", "10", "minecraft:dirt"}, {"-1", "1", "12", "minecraft:grass"}, {"-1", "2", "4", "minecraft:oak_slab"}, {"-1", "2", "5", "minecraft:stone"}, {"-1", "2", "6", "minecraft:grass_block"}, {"-1", "2", "7", "minecraft:cobblestone"}, {"-1", "2", "8", "minecraft:stone"}, {"-1", "2", "9", "minecraft:grass_block"}, {"-1", "2", "10", "minecraft:grass_block"}, {"-1", "3", "10", "minecraft:poppy"}, {"-1", "6", "4", "minecraft:oak_leaves"}, {"-1", "6", "5", "minecraft:oak_leaves"}, {"-1", "6", "6", "minecraft:oak_leaves"}, {"-1", "6", "7", "minecraft:oak_leaves"}, {"-1", "7", "4", "minecraft:oak_leaves"}, {"-1", "7", "5", "minecraft:oak_leaves"}, {"-1", "7", "6", "minecraft:oak_leaves"}, {"-1", "7", "7", "minecraft:oak_leaves"}, {"-1", "7", "8", "minecraft:oak_leaves"}, {"-1", "7", "9", "minecraft:oak_leaves"}, {"-1", "7", "10", "minecraft:oak_leaves"}, {"-1", "8", "4", "minecraft:oak_leaves"}, {"-1", "8", "5", "minecraft:oak_leaves"}, {"-1", "8", "6", "minecraft:oak_leaves"}, {"-1", "8", "7", "minecraft:oak_leaves"}, {"-1", "8", "8", "minecraft:oak_leaves"}, {"-1", "8", "9", "minecraft:oak_leaves"}, {"-1", "8", "10", "minecraft:oak_leaves"}, {"-1", "9", "5", "minecraft:oak_leaves"}, {"-1", "9", "6", "minecraft:oak_leaves"}, {"-1", "9", "7", "minecraft:oak_leaves"}, {"-1", "9", "8", "minecraft:oak_leaves"}, {"-1", "9", "9", "minecraft:oak_leaves"}, {"-1", "10", "6", "minecraft:oak_leaves"}, {"-1", "10", "7", "minecraft:oak_leaves"}, {"-1", "10", "8", "minecraft:oak_leaves"}, {"-1", "11", "7", "minecraft:oak_leaves"}, {"0", "-6", "1", "minecraft:stone"}, {"0", "-6", "2", "minecraft:cobblestone"}, {"0", "-6", "3", "minecraft:stone"}, {"0", "-6", "4", "minecraft:stone"}, {"0", "-6", "5", "minecraft:stone"}, {"0", "-6", "6", "minecraft:stone"}, {"0", "-6", "7", "minecraft:cobblestone"}, {"0", "-5", "-3", "minecraft:stone"}, {"0", "-5", "-2", "minecraft:stone"}, {"0", "-5", "-1", "minecraft:stone"}, {"0", "-5", "0", "minecraft:stone"}, {"0", "-5", "1", "minecraft:stone"}, {"0", "-5", "2", "minecraft:stone"}, {"0", "-5", "3", "minecraft:stone"}, {"0", "-5", "4", "minecraft:stone"}, {"0", "-5", "5", "minecraft:stone"}, {"0", "-5", "6", "minecraft:stone"}, {"0", "-5", "7", "minecraft:stone"}, {"0", "-5", "8", "minecraft:cobblestone"}, {"0", "-4", "-4", "minecraft:stone"}, {"0", "-4", "-3", "minecraft:stone"}, {"0", "-4", "-2", "minecraft:cobblestone"}, {"0", "-4", "-1", "minecraft:stone"}, {"0", "-4", "0", "minecraft:stone"}, {"0", "-4", "1", "minecraft:stone"}, {"0", "-4", "2", "minecraft:stone"}, {"0", "-4", "3", "minecraft:stone"}, {"0", "-4", "4", "minecraft:stone"}, {"0", "-4", "5", "minecraft:stone"}, {"0", "-4", "6", "minecraft:stone"}, {"0", "-4", "7", "minecraft:stone"}, {"0", "-4", "8", "minecraft:stone"}, {"0", "-3", "-5", "minecraft:grass_block"}, {"0", "-3", "-4", "minecraft:stone"}, {"0", "-3", "-3", "minecraft:stone"}, {"0", "-3", "-2", "minecraft:stone"}, {"0", "-3", "-1", "minecraft:stone"}, {"0", "-3", "0", "minecraft:dirt"}, {"0", "-3", "1", "minecraft:stone"}, {"0", "-3", "2", "minecraft:cobblestone"}, {"0", "-3", "3", "minecraft:stone"}, {"0", "-3", "4", "minecraft:stone"}, {"0", "-3", "5", "minecraft:stone"}, {"0", "-3", "6", "minecraft:stone"}, {"0", "-3", "7", "minecraft:stone"}, {"0", "-3", "8", "minecraft:stone"}, {"0", "-3", "9", "minecraft:stone"}, {"0", "-2", "-4", "minecraft:grass_block"}, {"0", "-2", "-3", "minecraft:grass_block"}, {"0", "-2", "-2", "minecraft:stone"}, {"0", "-2", "-1", "minecraft:dirt"}, {"0", "-2", "0", "minecraft:cobblestone"}, {"0", "-2", "1", "minecraft:stone"}, {"0", "-2", "2", "minecraft:cobblestone"}, {"0", "-2", "3", "minecraft:stone"}, {"0", "-2", "4", "minecraft:stone"}, {"0", "-2", "5", "minecraft:stone"}, {"0", "-2", "6", "minecraft:stone"}, {"0", "-2", "7", "minecraft:stone"}, {"0", "-2", "8", "minecraft:stone"}, {"0", "-2", "9", "minecraft:stone"}, {"0", "-2", "10", "minecraft:stone"}, {"0", "-2", "11", "minecraft:stone"}, {"0", "-1", "-4", "minecraft:tall_grass"}, {"0", "-1", "-3", "minecraft:dandelion"}, {"0", "-1", "-1", "minecraft:grass_block"}, {"0", "-1", "0", "minecraft:dirt"}, {"0", "-1", "1", "minecraft:dirt"}, {"0", "-1", "2", "minecraft:dirt"}, {"0", "-1", "3", "minecraft:dirt"}, {"0", "-1", "4", "minecraft:dirt"}, {"0", "-1", "5", "minecraft:stone"}, {"0", "-1", "6", "minecraft:stone"}, {"0", "-1", "7", "minecraft:cobblestone"}, {"0", "-1", "8", "minecraft:stone"}, {"0", "-1", "9", "minecraft:stone"}, {"0", "-1", "10", "minecraft:cobblestone"}, {"0", "-1", "11", "minecraft:dirt"}, {"0", "-1", "12", "minecraft:cobblestone"}, {"0", "0", "-4", "minecraft:tall_grass"}, {"0", "0", "0", "minecraft:oak_slab"}, {"0", "0", "1", "minecraft:grass_block"}, {"0", "0", "2", "minecraft:grass_block"}, {"0", "0", "3", "minecraft:stone"}, {"0", "0", "4", "minecraft:stone"}, {"0", "0", "5", "minecraft:dirt"}, {"0", "0", "6", "minecraft:dirt"}, {"0", "0", "7", "minecraft:dirt"}, {"0", "0", "8", "minecraft:dirt"}, {"0", "0", "9", "minecraft:dirt"}, {"0", "0", "10", "minecraft:dirt"}, {"0", "0", "11", "minecraft:grass_block"}, {"0", "0", "12", "minecraft:grass_block"}, {"0", "1", "2", "minecraft:grass"}, {"0", "1", "4", "minecraft:stone"}, {"0", "1", "5", "minecraft:dirt"}, {"0", "1", "6", "minecraft:dirt"}, {"0", "1", "7", "minecraft:dirt"}, {"0", "1", "8", "minecraft:dirt"}, {"0", "1", "9", "minecraft:dirt"}, {"0", "1", "10", "minecraft:grass_block"}, {"0", "1", "11", "minecraft:grass"}, {"0", "1", "12", "minecraft:tall_grass"}, {"0", "2", "4", "minecraft:grass_block"}, {"0", "2", "5", "minecraft:grass_block"}, {"0", "2", "6", "minecraft:grass_block"}, {"0", "2", "7", "minecraft:grass_block"}, {"0", "2", "8", "minecraft:grass_block"}, {"0", "2", "9", "minecraft:grass_block"}, {"0", "2", "12", "minecraft:tall_grass"}, {"0", "3", "6", "minecraft:oak_fence"}, {"0", "4", "6", "minecraft:lantern"}, {"0", "5", "7", "minecraft:oak_log"}, {"0", "6", "4", "minecraft:oak_leaves"}, {"0", "6", "5", "minecraft:oak_leaves"}, {"0", "6", "7", "minecraft:oak_log"}, {"0", "6", "8", "minecraft:oak_leaves"}, {"0", "7", "4", "minecraft:oak_leaves"}, {"0", "7", "5", "minecraft:oak_leaves"}, {"0", "7", "6", "minecraft:oak_log"}, {"0", "7", "7", "minecraft:oak_log"}, {"0", "7", "8", "minecraft:oak_leaves"}, {"0", "7", "9", "minecraft:oak_leaves"}, {"0", "7", "10", "minecraft:oak_leaves"}, {"0", "8", "4", "minecraft:oak_leaves"}, {"0", "8", "5", "minecraft:oak_leaves"}, {"0", "8", "6", "minecraft:oak_log"}, {"0", "8", "7", "minecraft:oak_log"}, {"0", "8", "8", "minecraft:oak_leaves"}, {"0", "8", "9", "minecraft:oak_leaves"}, {"0", "8", "10", "minecraft:oak_leaves"}, {"0", "9", "5", "minecraft:oak_leaves"}, {"0", "9", "6", "minecraft:oak_log"}, {"0", "9", "7", "minecraft:oak_log"}, {"0", "9", "8", "minecraft:oak_leaves"}, {"0", "9", "9", "minecraft:oak_leaves"}, {"0", "10", "5", "minecraft:oak_leaves"}, {"0", "10", "6", "minecraft:oak_leaves"}, {"0", "10", "7", "minecraft:oak_log"}, {"0", "10", "8", "minecraft:oak_leaves"}, {"0", "11", "6", "minecraft:oak_leaves"}, {"0", "11", "7", "minecraft:oak_leaves"}, {"0", "11", "8", "minecraft:oak_leaves"}, {"1", "-6", "1", "minecraft:cobblestone"}, {"1", "-6", "2", "minecraft:stone"}, {"1", "-6", "5", "minecraft:stone"}, {"1", "-6", "6", "minecraft:cobblestone"}, {"1", "-5", "-3", "minecraft:cobblestone"}, {"1", "-5", "-2", "minecraft:stone"}, {"1", "-5", "-1", "minecraft:stone"}, {"1", "-5", "0", "minecraft:stone"}, {"1", "-5", "1", "minecraft:stone"}, {"1", "-5", "2", "minecraft:stone"}, {"1", "-5", "3", "minecraft:stone"}, {"1", "-5", "4", "minecraft:stone"}, {"1", "-5", "5", "minecraft:stone"}, {"1", "-5", "6", "minecraft:stone"}, {"1", "-5", "7", "minecraft:stone"}, {"1", "-5", "8", "minecraft:stone"}, {"1", "-4", "-4", "minecraft:stone"}, {"1", "-4", "-3", "minecraft:stone"}, {"1", "-4", "-2", "minecraft:stone"}, {"1", "-4", "-1", "minecraft:stone"}, {"1", "-4", "1", "minecraft:stone"}, {"1", "-4", "2", "minecraft:stone"}, {"1", "-4", "3", "minecraft:stone"}, {"1", "-4", "4", "minecraft:stone"}, {"1", "-4", "5", "minecraft:stone"}, {"1", "-4", "6", "minecraft:stone"}, {"1", "-4", "7", "minecraft:stone"}, {"1", "-4", "8", "minecraft:stone"}, {"1", "-3", "-5", "minecraft:stone"}, {"1", "-3", "-4", "minecraft:dirt"}, {"1", "-3", "-3", "minecraft:cobblestone"}, {"1", "-3", "-2", "minecraft:stone"}, {"1", "-3", "-1", "minecraft:stone"}, {"1", "-3", "0", "minecraft:stone"}, {"1", "-3", "1", "minecraft:stone"}, {"1", "-3", "2", "minecraft:cobblestone"}, {"1", "-3", "3", "minecraft:stone"}, {"1", "-3", "4", "minecraft:stone"}, {"1", "-3", "5", "minecraft:stone"}, {"1", "-3", "6", "minecraft:stone"}, {"1", "-3", "7", "minecraft:stone"}, {"1", "-3", "8", "minecraft:cobblestone"}, {"1", "-3", "9", "minecraft:cobblestone"}, {"1", "-2", "-4", "minecraft:grass_block"}, {"1", "-2", "-3", "minecraft:grass_block"}, {"1", "-2", "-2", "minecraft:grass_block"}, {"1", "-2", "-1", "minecraft:dirt"}, {"1", "-2", "0", "minecraft:dirt"}, {"1", "-2", "1", "minecraft:stone"}, {"1", "-2", "2", "minecraft:cobblestone"}, {"1", "-2", "3", "minecraft:stone"}, {"1", "-2", "4", "minecraft:stone"}, {"1", "-2", "5", "minecraft:stone"}, {"1", "-2", "6", "minecraft:stone"}, {"1", "-2", "7", "minecraft:stone"}, {"1", "-2", "8", "minecraft:cobblestone"}, {"1", "-2", "9", "minecraft:cobblestone"}, {"1", "-2", "10", "minecraft:stone"}, {"1", "-2", "11", "minecraft:stone"}, {"1", "-1", "-3", "minecraft:grass"}, {"1", "-1", "-1", "minecraft:oak_slab"}, {"1", "-1", "0", "minecraft:stone"}, {"1", "-1", "1", "minecraft:grass_block"}, {"1", "-1", "2", "minecraft:dirt"}, {"1", "-1", "3", "minecraft:dirt"}, {"1", "-1", "4", "minecraft:stone"}, {"1", "-1", "5", "minecraft:stone"}, {"1", "-1", "6", "minecraft:stone"}, {"1", "-1", "7", "minecraft:stone"}, {"1", "-1", "8", "minecraft:stone"}, {"1", "-1", "9", "minecraft:stone"}, {"1", "-1", "10", "minecraft:stone"}, {"1", "-1", "11", "minecraft:dirt"}, {"1", "-1", "12", "minecraft:dirt"}, {"1", "0", "1", "minecraft:grass"}, {"1", "0", "2", "minecraft:grass_block"}, {"1", "0", "3", "minecraft:grass_block"}, {"1", "0", "4", "minecraft:stone"}, {"1", "0", "5", "minecraft:cobblestone"}, {"1", "0", "6", "minecraft:dirt"}, {"1", "0", "7", "minecraft:dirt"}, {"1", "0", "8", "minecraft:dirt"}, {"1", "0", "9", "minecraft:dirt"}, {"1", "0", "10", "minecraft:stone"}, {"1", "0", "11", "minecraft:grass_block"}, {"1", "0", "12", "minecraft:grass_block"}, {"1", "1", "2", "minecraft:grass"}, {"1", "1", "4", "minecraft:stone"}, {"1", "1", "5", "minecraft:dirt"}, {"1", "1", "6", "minecraft:dirt"}, {"1", "1", "7", "minecraft:dirt"}, {"1", "1", "8", "minecraft:dirt"}, {"1", "1", "9", "minecraft:dirt"}, {"1", "1", "10", "minecraft:grass_block"}, {"1", "1", "11", "minecraft:tall_grass"}, {"1", "1", "12", "minecraft:grass"}, {"1", "2", "4", "minecraft:grass_block"}, {"1", "2", "5", "minecraft:grass_block"}, {"1", "2", "6", "minecraft:dirt"}, {"1", "2", "7", "minecraft:dirt"}, {"1", "2", "8", "minecraft:grass_block"}, {"1", "2", "9", "minecraft:grass_block"}, {"1", "2", "11", "minecraft:tall_grass"}, {"1", "3", "6", "minecraft:oak_log"}, {"1", "3", "7", "minecraft:oak_log"}, {"1", "4", "7", "minecraft:oak_log"}, {"1", "5", "7", "minecraft:oak_log"}, {"1", "6", "4", "minecraft:oak_leaves"}, {"1", "6", "5", "minecraft:oak_leaves"}, {"1", "6", "7", "minecraft:oak_log"}, {"1", "6", "8", "minecraft:oak_log"}, {"1", "7", "4", "minecraft:oak_leaves"}, {"1", "7", "5", "minecraft:oak_leaves"}, {"1", "7", "7", "minecraft:oak_log"}, {"1", "7", "8", "minecraft:oak_log"}, {"1", "7", "9", "minecraft:oak_leaves"}, {"1", "7", "10", "minecraft:oak_leaves"}, {"1", "8", "4", "minecraft:oak_leaves"}, {"1", "8", "5", "minecraft:oak_leaves"}, {"1", "8", "6", "minecraft:oak_log"}, {"1", "8", "7", "minecraft:oak_log"}, {"1", "8", "8", "minecraft:oak_log"}, {"1", "8", "9", "minecraft:oak_leaves"}, {"1", "8", "10", "minecraft:oak_leaves"}, {"1", "9", "5", "minecraft:oak_leaves"}, {"1", "9", "6", "minecraft:oak_leaves"}, {"1", "9", "7", "minecraft:oak_log"}, {"1", "9", "8", "minecraft:oak_log"}, {"1", "9", "9", "minecraft:oak_leaves"}, {"1", "10", "6", "minecraft:oak_leaves"}, {"1", "10", "7", "minecraft:oak_leaves"}, {"1", "10", "8", "minecraft:oak_leaves"}, {"1", "10", "9", "minecraft:oak_leaves"}, {"1", "11", "6", "minecraft:oak_leaves"}, {"1", "11", "7", "minecraft:oak_leaves"}, {"1", "12", "7", "minecraft:oak_leaves"}, {"2", "-6", "1", "minecraft:stone"}, {"2", "-6", "2", "minecraft:stone"}, {"2", "-5", "-2", "minecraft:stone"}, {"2", "-5", "-1", "minecraft:stone"}, {"2", "-5", "0", "minecraft:stone"}, {"2", "-5", "1", "minecraft:stone"}, {"2", "-5", "2", "minecraft:stone"}, {"2", "-5", "3", "minecraft:stone"}, {"2", "-5", "4", "minecraft:stone"}, {"2", "-5", "5", "minecraft:stone"}, {"2", "-5", "6", "minecraft:stone"}, {"2", "-5", "7", "minecraft:stone"}, {"2", "-4", "-4", "minecraft:stone"}, {"2", "-4", "-3", "minecraft:stone"}, {"2", "-4", "-2", "minecraft:stone"}, {"2", "-4", "-1", "minecraft:stone"}, {"2", "-4", "0", "minecraft:stone"}, {"2", "-4", "1", "minecraft:stone"}, {"2", "-4", "2", "minecraft:stone"}, {"2", "-4", "3", "minecraft:stone"}, {"2", "-4", "4", "minecraft:stone"}, {"2", "-4", "5", "minecraft:stone"}, {"2", "-4", "6", "minecraft:stone"}, {"2", "-4", "7", "minecraft:stone"}, {"2", "-4", "8", "minecraft:stone"}, {"2", "-3", "-5", "minecraft:stone"}, {"2", "-3", "-4", "minecraft:dirt"}, {"2", "-3", "-3", "minecraft:stone"}, {"2", "-3", "-2", "minecraft:stone"}, {"2", "-3", "-1", "minecraft:stone"}, {"2", "-3", "0", "minecraft:stone"}, {"2", "-3", "1", "minecraft:stone"}, {"2", "-3", "2", "minecraft:stone"}, {"2", "-3", "3", "minecraft:stone"}, {"2", "-3", "4", "minecraft:stone"}, {"2", "-3", "5", "minecraft:stone"}, {"2", "-3", "6", "minecraft:cobblestone"}, {"2", "-3", "7", "minecraft:stone"}, {"2", "-3", "8", "minecraft:stone"}, {"2", "-3", "9", "minecraft:cobblestone"}, {"2", "-3", "10", "minecraft:stone"}, {"2", "-2", "-4", "minecraft:cobblestone"}, {"2", "-2", "-3", "minecraft:grass_block"}, {"2", "-2", "-2", "minecraft:grass_block"}, {"2", "-2", "-1", "minecraft:grass_block"}, {"2", "-2", "0", "minecraft:sand"}, {"2", "-2", "1", "minecraft:cobblestone"}, {"2", "-2", "2", "minecraft:stone"}, {"2", "-2", "3", "minecraft:stone"}, {"2", "-2", "4", "minecraft:stone"}, {"2", "-2", "5", "minecraft:stone"}, {"2", "-2", "6", "minecraft:stone"}, {"2", "-2", "7", "minecraft:stone"}, {"2", "-2", "8", "minecraft:stone"}, {"2", "-2", "9", "minecraft:stone"}, {"2", "-2", "10", "minecraft:stone"}, {"2", "-2", "11", "minecraft:stone"}, {"2", "-2", "12", "minecraft:stone"}, {"2", "-1", "-4", "minecraft:oak_fence"}, {"2", "-1", "-3", "minecraft:grass"}, {"2", "-1", "-2", "minecraft:grass"}, {"2", "-1", "2", "minecraft:stone"}, {"2", "-1", "3", "minecraft:dirt"}, {"2", "-1", "4", "minecraft:dirt"}, {"2", "-1", "5", "minecraft:cobblestone"}, {"2", "-1", "6", "minecraft:stone"}, {"2", "-1", "7", "minecraft:cobblestone"}, {"2", "-1", "8", "minecraft:stone"}, {"2", "-1", "9", "minecraft:stone"}, {"2", "-1", "10", "minecraft:stone"}, {"2", "-1", "11", "minecraft:grass_block"}, {"2", "-1", "12", "minecraft:grass_block"}, {"2", "0", "-4", "minecraft:lantern"}, {"2", "0", "3", "minecraft:grass_block"}, {"2", "0", "4", "minecraft:stone"}, {"2", "0", "5", "minecraft:dirt"}, {"2", "0", "6", "minecraft:dirt"}, {"2", "0", "7", "minecraft:dirt"}, {"2", "0", "8", "minecraft:dirt"}, {"2", "0", "9", "minecraft:dirt"}, {"2", "0", "10", "minecraft:stone"}, {"2", "1", "3", "minecraft:grass"}, {"2", "1", "4", "minecraft:cobblestone"}, {"2", "1", "5", "minecraft:dirt"}, {"2", "1", "6", "minecraft:dirt"}, {"2", "1", "7", "minecraft:dirt"}, {"2", "1", "8", "minecraft:dirt"}, {"2", "1", "9", "minecraft:dirt"}, {"2", "1", "10", "minecraft:grass_block"}, {"2", "2", "5", "minecraft:grass_block"}, {"2", "2", "6", "minecraft:dirt"}, {"2", "2", "7", "minecraft:dirt"}, {"2", "2", "8", "minecraft:grass_block"}, {"2", "2", "9", "minecraft:grass_block"}, {"2", "3", "6", "minecraft:oak_log"}, {"2", "3", "7", "minecraft:oak_log"}, {"2", "4", "7", "minecraft:oak_log"}, {"2", "6", "4", "minecraft:oak_leaves"}, {"2", "6", "5", "minecraft:oak_leaves"}, {"2", "6", "6", "minecraft:oak_leaves"}, {"2", "6", "7", "minecraft:oak_log"}, {"2", "6", "8", "minecraft:oak_leaves"}, {"2", "7", "4", "minecraft:oak_leaves"}, {"2", "7", "5", "minecraft:oak_leaves"}, {"2", "7", "6", "minecraft:oak_leaves"}, {"2", "7", "7", "minecraft:oak_log"}, {"2", "7", "8", "minecraft:oak_leaves"}, {"2", "7", "9", "minecraft:oak_leaves"}, {"2", "7", "10", "minecraft:oak_leaves"}, {"2", "8", "5", "minecraft:oak_leaves"}, {"2", "8", "6", "minecraft:oak_leaves"}, {"2", "8", "7", "minecraft:oak_log"}, {"2", "8", "8", "minecraft:oak_leaves"}, {"2", "8", "9", "minecraft:oak_leaves"}, {"2", "8", "10", "minecraft:oak_leaves"}, {"2", "9", "5", "minecraft:oak_leaves"}, {"2", "9", "6", "minecraft:oak_leaves"}, {"2", "9", "7", "minecraft:oak_log"}, {"2", "9", "8", "minecraft:oak_leaves"}, {"2", "9", "9", "minecraft:oak_leaves"}, {"2", "10", "6", "minecraft:oak_leaves"}, {"2", "10", "7", "minecraft:oak_log"}, {"2", "10", "8", "minecraft:oak_leaves"}, {"2", "11", "6", "minecraft:oak_leaves"}, {"2", "11", "7", "minecraft:oak_leaves"}, {"2", "11", "8", "minecraft:oak_leaves"}, {"3", "-7", "2", "minecraft:stone"}, {"3", "-6", "2", "minecraft:stone"}, {"3", "-5", "-2", "minecraft:cobblestone"}, {"3", "-5", "-1", "minecraft:stone"}, {"3", "-5", "0", "minecraft:stone"}, {"3", "-5", "2", "minecraft:stone"}, {"3", "-5", "3", "minecraft:stone"}, {"3", "-5", "4", "minecraft:cobblestone"}, {"3", "-5", "7", "minecraft:stone"}, {"3", "-4", "-2", "minecraft:cobblestone"}, {"3", "-4", "-1", "minecraft:cobblestone"}, {"3", "-4", "0", "minecraft:clay"}, {"3", "-4", "1", "minecraft:cobblestone"}, {"3", "-4", "2", "minecraft:stone"}, {"3", "-4", "3", "minecraft:stone"}, {"3", "-4", "4", "minecraft:stone"}, {"3", "-4", "5", "minecraft:stone"}, {"3", "-4", "6", "minecraft:stone"}, {"3", "-4", "7", "minecraft:stone"}, {"3", "-4", "8", "minecraft:stone"}, {"3", "-3", "-4", "minecraft:grass_block"}, {"3", "-3", "-3", "minecraft:cobblestone"}, {"3", "-3", "-2", "minecraft:stone"}, {"3", "-3", "-1", "minecraft:sand"}, {"3", "-3", "0", "minecraft:sand"}, {"3", "-3", "1", "minecraft:gravel"}, {"3", "-3", "2", "minecraft:stone"}, {"3", "-3", "3", "minecraft:stone"}, {"3", "-3", "4", "minecraft:stone"}, {"3", "-3", "5", "minecraft:stone"}, {"3", "-3", "6", "minecraft:stone"}, {"3", "-3", "7", "minecraft:stone"}, {"3", "-3", "8", "minecraft:stone"}, {"3", "-3", "9", "minecraft:stone"}, {"3", "-3", "10", "minecraft:cobblestone"}, {"3", "-2", "-3", "minecraft:grass_block"}, {"3", "-2", "-2", "minecraft:water"}, {"3", "-2", "-1", "minecraft:water"}, {"3", "-2", "0", "minecraft:water"}, {"3", "-2", "1", "minecraft:water"}, {"3", "-2", "2", "minecraft:dirt"}, {"3", "-2", "3", "minecraft:dirt"}, {"3", "-2", "4", "minecraft:dirt"}, {"3", "-2", "5", "minecraft:cobblestone"}, {"3", "-2", "6", "minecraft:stone"}, {"3", "-2", "7", "minecraft:stone"}, {"3", "-2", "8", "minecraft:stone"}, {"3", "-2", "9", "minecraft:stone"}, {"3", "-2", "10", "minecraft:stone"}, {"3", "-2", "11", "minecraft:stone"}, {"3", "-1", "2", "minecraft:grass_block"}, {"3", "-1", "3", "minecraft:stone"}, {"3", "-1", "4", "minecraft:dirt"}, {"3", "-1", "5", "minecraft:dirt"}, {"3", "-1", "6", "minecraft:dirt"}, {"3", "-1", "7", "minecraft:dirt"}, {"3", "-1", "8", "minecraft:stone"}, {"3", "-1", "9", "minecraft:stone"}, {"3", "-1", "10", "minecraft:stone"}, {"3", "-1", "11", "minecraft:grass_block"}, {"3", "0", "3", "minecraft:stone"}, {"3", "0", "4", "minecraft:stone"}, {"3", "0", "5", "minecraft:stone"}, {"3", "0", "6", "minecraft:stone"}, {"3", "0", "7", "minecraft:dirt"}, {"3", "0", "8", "minecraft:dirt"}, {"3", "0", "9", "minecraft:dirt"}, {"3", "0", "10", "minecraft:cobblestone"}, {"3", "1", "5", "minecraft:dirt"}, {"3", "1", "6", "minecraft:dirt"}, {"3", "1", "7", "minecraft:dirt"}, {"3", "1", "8", "minecraft:dirt"}, {"3", "1", "9", "minecraft:dirt"}, {"3", "2", "5", "minecraft:grass_block"}, {"3", "2", "6", "minecraft:grass_block"}, {"3", "2", "7", "minecraft:grass_block"}, {"3", "2", "8", "minecraft:grass_block"}, {"3", "2", "9", "minecraft:grass_block"}, {"3", "3", "5", "minecraft:grass"}, {"3", "3", "6", "minecraft:grass"}, {"3", "6", "4", "minecraft:oak_leaves"}, {"3", "6", "5", "minecraft:oak_leaves"}, {"3", "6", "6", "minecraft:oak_leaves"}, {"3", "6", "7", "minecraft:oak_leaves"}, {"3", "7", "5", "minecraft:oak_leaves"}, {"3", "7", "6", "minecraft:oak_leaves"}, {"3", "7", "7", "minecraft:oak_leaves"}, {"3", "7", "8", "minecraft:oak_leaves"}, {"3", "7", "9", "minecraft:oak_leaves"}, {"3", "7", "10", "minecraft:oak_leaves"}, {"3", "8", "5", "minecraft:oak_leaves"}, {"3", "8", "6", "minecraft:oak_leaves"}, {"3", "8", "7", "minecraft:oak_leaves"}, {"3", "8", "8", "minecraft:oak_leaves"}, {"3", "8", "9", "minecraft:oak_leaves"}, {"3", "9", "5", "minecraft:oak_leaves"}, {"3", "9", "6", "minecraft:oak_leaves"}, {"3", "9", "7", "minecraft:oak_leaves"}, {"3", "9", "8", "minecraft:oak_leaves"}, {"3", "9", "9", "minecraft:oak_leaves"}, {"3", "10", "7", "minecraft:oak_leaves"}, {"3", "11", "7", "minecraft:oak_leaves"}, {"4", "-5", "-1", "minecraft:stone"}, {"4", "-5", "0", "minecraft:stone"}, {"4", "-4", "-2", "minecraft:stone"}, {"4", "-4", "-1", "minecraft:clay"}, {"4", "-4", "0", "minecraft:clay"}, {"4", "-4", "1", "minecraft:stone"}, {"4", "-4", "2", "minecraft:stone"}, {"4", "-4", "3", "minecraft:cobblestone"}, {"4", "-4", "4", "minecraft:cobblestone"}, {"4", "-4", "5", "minecraft:cobblestone"}, {"4", "-4", "6", "minecraft:cobblestone"}, {"4", "-4", "7", "minecraft:stone"}, {"4", "-3", "-4", "minecraft:stone"}, {"4", "-3", "-3", "minecraft:stone"}, {"4", "-3", "-2", "minecraft:stone"}, {"4", "-3", "-1", "minecraft:water"}, {"4", "-3", "0", "minecraft:water"}, {"4", "-3", "1", "minecraft:sand"}, {"4", "-3", "2", "minecraft:stone"}, {"4", "-3", "3", "minecraft:stone"}, {"4", "-3", "4", "minecraft:stone"}, {"4", "-3", "5", "minecraft:stone"}, {"4", "-3", "6", "minecraft:stone"}, {"4", "-3", "7", "minecraft:stone"}, {"4", "-3", "8", "minecraft:stone"}, {"4", "-2", "-3", "minecraft:grass_block"}, {"4", "-2", "-2", "minecraft:sand"}, {"4", "-2", "-1", "minecraft:water"}, {"4", "-2", "0", "minecraft:water"}, {"4", "-2", "1", "minecraft:water"}, {"4", "-2", "2", "minecraft:stone"}, {"4", "-2", "3", "minecraft:dirt"}, {"4", "-2", "4", "minecraft:dirt"}, {"4", "-2", "5", "minecraft:stone"}, {"4", "-2", "6", "minecraft:stone"}, {"4", "-2", "7", "minecraft:stone"}, {"4", "-2", "8", "minecraft:stone"}, {"4", "-2", "9", "minecraft:stone"}, {"4", "-2", "10", "minecraft:stone"}, {"4", "-1", "-2", "minecraft:sugar_cane"}, {"4", "-1", "3", "minecraft:grass_block"}, {"4", "-1", "4", "minecraft:stone"}, {"4", "-1", "5", "minecraft:stone"}, {"4", "-1", "6", "minecraft:stone"}, {"4", "-1", "7", "minecraft:stone"}, {"4", "-1", "8", "minecraft:stone"}, {"4", "-1", "9", "minecraft:stone"}, {"4", "-1", "10", "minecraft:grass_block"}, {"4", "0", "-2", "minecraft:sugar_cane"}, {"4", "0", "4", "minecraft:cobblestone"}, {"4", "0", "5", "minecraft:stone"}, {"4", "0", "6", "minecraft:dirt"}, {"4", "0", "7", "minecraft:dirt"}, {"4", "0", "8", "minecraft:stone"}, {"4", "0", "9", "minecraft:dirt"}, {"4", "1", "-2", "minecraft:sugar_cane"}, {"4", "1", "5", "minecraft:dirt"}, {"4", "1", "6", "minecraft:dirt"}, {"4", "1", "7", "minecraft:dirt"}, {"4", "1", "8", "minecraft:dirt"}, {"4", "1", "9", "minecraft:dirt"}, {"4", "2", "5", "minecraft:grass_block"}, {"4", "2", "6", "minecraft:grass_block"}, {"4", "2", "7", "minecraft:grass_block"}, {"4", "2", "8", "minecraft:grass_block"}, {"4", "2", "9", "minecraft:grass_block"}, {"4", "3", "5", "minecraft:poppy"}, {"4", "7", "6", "minecraft:oak_leaves"}, {"4", "7", "7", "minecraft:oak_leaves"}, {"4", "7", "8", "minecraft:oak_leaves"}, {"4", "7", "9", "minecraft:oak_leaves"}, {"4", "7", "10", "minecraft:oak_leaves"}, {"4", "8", "6", "minecraft:oak_leaves"}, {"4", "8", "7", "minecraft:oak_leaves"}, {"4", "8", "8", "minecraft:oak_leaves"}, {"4", "8", "9", "minecraft:oak_leaves"}, {"4", "9", "5", "minecraft:oak_leaves"}, {"4", "9", "6", "minecraft:oak_leaves"}, {"4", "9", "7", "minecraft:oak_leaves"}, {"4", "9", "8", "minecraft:oak_leaves"}, {"5", "-4", "-1", "minecraft:dirt"}, {"5", "-4", "0", "minecraft:stone"}, {"5", "-4", "1", "minecraft:stone"}, {"5", "-4", "2", "minecraft:cobblestone"}, {"5", "-4", "3", "minecraft:stone"}, {"5", "-4", "5", "minecraft:stone"}, {"5", "-4", "6", "minecraft:stone"}, {"5", "-3", "-3", "minecraft:stone"}, {"5", "-3", "-2", "minecraft:dirt"}, {"5", "-3", "-1", "minecraft:cobblestone"}, {"5", "-3", "0", "minecraft:gravel"}, {"5", "-3", "1", "minecraft:stone"}, {"5", "-3", "2", "minecraft:stone"}, {"5", "-3", "3", "minecraft:stone"}, {"5", "-3", "4", "minecraft:stone"}, {"5", "-3", "5", "minecraft:stone"}, {"5", "-3", "6", "minecraft:stone"}, {"5", "-3", "7", "minecraft:cobblestone"}, {"5", "-2", "-2", "minecraft:grass_block"}, {"5", "-2", "-1", "minecraft:sand"}, {"5", "-2", "0", "minecraft:sand"}, {"5", "-2", "1", "minecraft:cobblestone"}, {"5", "-2", "2", "minecraft:grass_block"}, {"5", "-2", "3", "minecraft:grass_block"}, {"5", "-2", "4", "minecraft:stone"}, {"5", "-2", "5", "minecraft:stone"}, {"5", "-2", "6", "minecraft:stone"}, {"5", "-2", "7", "minecraft:stone"}, {"5", "-2", "8", "minecraft:cobblestone"}, {"5", "-2", "9", "minecraft:stone"}, {"5", "-1", "0", "minecraft:sugar_cane"}, {"5", "-1", "5", "minecraft:dirt"}, {"5", "-1", "6", "minecraft:stone"}, {"5", "-1", "7", "minecraft:stone"}, {"5", "-1", "8", "minecraft:stone"}, {"5", "-1", "9", "minecraft:dirt"}, {"5", "0", "0", "minecraft:sugar_cane"}, {"5", "0", "5", "minecraft:stone"}, {"5", "0", "6", "minecraft:stone"}, {"5", "0", "7", "minecraft:stone"}, {"5", "0", "8", "minecraft:dirt"}, {"5", "0", "9", "minecraft:dirt"}, {"5", "1", "0", "minecraft:sugar_cane"}, {"5", "1", "5", "minecraft:grass_block"}, {"5", "1", "6", "minecraft:grass_block"}, {"5", "1", "7", "minecraft:dirt"}, {"5", "1", "8", "minecraft:grass_block"}, {"5", "1", "9", "minecraft:grass_block"}, {"5", "2", "6", "minecraft:grass"}, {"5", "2", "7", "minecraft:grass_block"}, {"5", "2", "8", "minecraft:grass"}, {"5", "2", "9", "minecraft:grass"}, {"6", "-4", "0", "minecraft:stone"}, {"6", "-3", "-1", "minecraft:dirt"}, {"6", "-3", "0", "minecraft:stone"}, {"6", "-3", "1", "minecraft:cobblestone"}, {"6", "-3", "2", "minecraft:stone"}, {"6", "-3", "3", "minecraft:stone"}, {"6", "-3", "4", "minecraft:dirt"}, {"6", "-3", "5", "minecraft:dirt"}, {"6", "-3", "6", "minecraft:stone"}, {"6", "-2", "-1", "minecraft:grass_block"}, {"6", "-2", "0", "minecraft:grass_block"}, {"6", "-2", "1", "minecraft:grass_block"}, {"6", "-2", "2", "minecraft:stone"}, {"6", "-2", "3", "minecraft:stone"}, {"6", "-2", "4", "minecraft:cobblestone"}, {"6", "-2", "5", "minecraft:cobblestone"}, {"6", "-2", "6", "minecraft:cobblestone"}, {"6", "-2", "7", "minecraft:stone"}, {"6", "-1", "6", "minecraft:stone"}, {"6", "-1", "7", "minecraft:stone"}, {"6", "-1", "8", "minecraft:cobblestone"}, {"6", "0", "6", "minecraft:grass_block"}, {"6", "0", "7", "minecraft:grass_block"}, {"6", "0", "8", "minecraft:grass_block"}, {"6", "1", "7", "minecraft:grass"}, {"7", "-3", "0", "minecraft:stone"}, {"7", "-3", "1", "minecraft:cobblestone"}, {"7", "-3", "2", "minecraft:stone"}, {"7", "-3", "5", "minecraft:cobblestone"}, {"7", "-2", "0", "minecraft:grass_block"}, {"7", "-2", "1", "minecraft:grass_block"}, {"7", "-2", "2", "minecraft:grass_block"}, {"7", "-2", "5", "minecraft:grass_block"}, {"7", "-2", "6", "minecraft:grass_block"}};
        BlockState placeBlockType = Blocks.field_150350_a.func_176223_P();
        for (String[] root : blocksToPlace) {
            switch (root[3]) {
                case "minecraft:grass_block": {
                    placeBlockType = Blocks.field_196658_i.func_176223_P();
                    break;
                }
                case "minecraft:dirt": {
                    placeBlockType = Blocks.field_150346_d.func_176223_P();
                    break;
                }
                case "minecraft:stone": {
                    placeBlockType = Blocks.field_150348_b.func_176223_P();
                    break;
                }
                case "minecraft:cobblestone": {
                    placeBlockType = Blocks.field_150347_e.func_176223_P();
                    break;
                }
                case "minecraft:sand": {
                    placeBlockType = Blocks.field_150354_m.func_176223_P();
                    break;
                }
                case "minecraft:gravel": {
                    placeBlockType = Blocks.field_150351_n.func_176223_P();
                    break;
                }
                case "minecraft:clay": {
                    placeBlockType = Blocks.field_150435_aG.func_176223_P();
                    break;
                }
                case "minecraft:oak_log": {
                    placeBlockType = Blocks.field_196617_K.func_176223_P();
                    break;
                }
                case "minecraft:oak_fence": {
                    placeBlockType = Blocks.field_180407_aO.func_176223_P();
                    break;
                }
                case "minecraft:oak_slab": {
                    placeBlockType = Blocks.field_196622_bq.func_176223_P();
                    break;
                }
                case "minecraft:water": {
                    placeBlockType = Blocks.field_150355_j.func_176223_P();
                    break;
                }
                case "minecraft:oak_leaves": {
                    placeBlockType = Blocks.field_196642_W.func_176223_P();
                    break;
                }
                case "minecraft:grass": {
                    placeBlockType = Blocks.field_150349_c.func_176223_P();
                    break;
                }
                case "minecraft:tall_grass": {
                    placeBlockType = Blocks.field_196804_gh.func_176223_P();
                    break;
                }
                case "minecraft:dandelion": {
                    placeBlockType = Blocks.field_196605_bc.func_176223_P();
                    break;
                }
                case "minecraft:poppy": {
                    placeBlockType = Blocks.field_196606_bd.func_176223_P();
                    break;
                }
                case "minecraft:sugar_cane": {
                    placeBlockType = Blocks.field_196608_cF.func_176223_P();
                    break;
                }
                case "minecraft:lantern": {
                    placeBlockType = Blocks.field_222432_lU.func_176223_P();
                    break;
                }
                default: {
                    LOGGER.info("Unknown block type: " + root[3] + "");
                    placeBlockType = Blocks.field_150350_a.func_176223_P();
                }
            }
            world.func_175656_a(pos.func_177982_a(Integer.parseInt(root[0]), Integer.parseInt(root[1]), Integer.parseInt(root[2])), placeBlockType);
        }
    }
}

