/*
 * Decompiled with CFR 0.152.
 */
package com.daposeidonguy.teamsmod.commands;

import com.daposeidonguy.teamsmod.handlers.ClientEventHandler;
import com.daposeidonguy.teamsmod.handlers.ConfigHandler;
import com.daposeidonguy.teamsmod.network.MessageInvite;
import com.daposeidonguy.teamsmod.network.MessageSaveData;
import com.daposeidonguy.teamsmod.network.PacketHandler;
import com.daposeidonguy.teamsmod.team.SaveData;
import com.mojang.authlib.GameProfile;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.UUID;
import javax.annotation.Nullable;
import net.minecraft.command.ICommand;
import net.minecraft.command.ICommandSender;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraft.server.MinecraftServer;
import net.minecraft.util.NonNullList;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.Style;
import net.minecraft.util.text.TextComponentString;
import net.minecraft.util.text.TextFormatting;
import net.minecraftforge.fml.common.FMLCommonHandler;
import net.minecraftforge.fml.common.network.simpleimpl.IMessage;

public class CommandTeam
implements ICommand {
    private final List aliases = new ArrayList();

    public CommandTeam() {
        this.aliases.add("team");
        this.aliases.add("teams");
        this.aliases.add("t");
        this.aliases.add("teamsmod");
    }

    public int compareTo(ICommand o) {
        return 0;
    }

    public String func_71517_b() {
        return "team";
    }

    public String func_71518_a(ICommandSender sender) {
        sender.func_145747_a((ITextComponent)new TextComponentString("Teams Commands: \n/team create <name> : creates team with the name <name>\n/team list : lists all created teams\n/team info <name> : lists all players in the team with name <name>\n/team player <name> : prints the team of the player with name <name>\n/team invite <name> : invites player with name <name> to your team\n/team accept : accepts invitation to team\n/team kick <name> : kicks player with name <name> from your team\n/team leave : leaves your team\n/team remove <name> : ADMIN ONLY - deletes the team with name <name>"));
        return "";
    }

    public List<String> func_71514_a() {
        return this.aliases;
    }

    public void func_184881_a(MinecraftServer server, ICommandSender sender, String[] args) {
        block52: {
            block53: {
                if (sender.func_130014_f_().field_72995_K || args.length <= 0) break block53;
                SaveData data = SaveData.get(sender.func_130014_f_());
                switch (args[0]) {
                    case "create": {
                        try {
                            EntityPlayer player;
                            String name = args[1];
                            if (SaveData.teamsMap.containsKey(name)) {
                                sender.func_145747_a(new TextComponentString("That team already exists").func_150255_a(new Style().func_150238_a(TextFormatting.RED)));
                                return;
                            }
                            if (name.contains(">")) {
                                sender.func_145747_a(new TextComponentString("Team name cannot have that character").func_150255_a(new Style().func_150238_a(TextFormatting.RED)));
                            }
                            if (SaveData.teamMap.containsKey((player = (EntityPlayer)sender).func_110124_au())) {
                                sender.func_145747_a(new TextComponentString("You're already in a team! Leave it first!").func_150255_a(new Style().func_150238_a(TextFormatting.RED)));
                                return;
                            }
                            data.addTeam(name, player);
                            sender.func_145747_a((ITextComponent)new TextComponentString("New team named \"" + name + "\" created"));
                        }
                        catch (Exception ex) {
                            sender.func_145747_a(new TextComponentString("Incorrect syntax. /team create <teamname>").func_150255_a(new Style().func_150238_a(TextFormatting.RED)));
                        }
                        break;
                    }
                    case "list": {
                        Iterator<String> teamIterator = SaveData.teamsMap.keySet().iterator();
                        sender.func_145747_a((ITextComponent)new TextComponentString("List of teams:"));
                        while (teamIterator.hasNext()) {
                            String team = teamIterator.next();
                            sender.func_145747_a((ITextComponent)new TextComponentString(team));
                        }
                        break block52;
                    }
                    case "kick": {
                        try {
                            String playerName = args[1];
                            UUID uid = ClientEventHandler.nametoIdMap.get(playerName);
                            String toLeave = SaveData.teamMap.get(uid);
                            if (toLeave != null) {
                                sender.func_145747_a((ITextComponent)new TextComponentString("Removing that player from your team!"));
                                data.removePlayer((EntityPlayer)sender, uid);
                                if (SaveData.teamsMap.get(toLeave).isEmpty()) {
                                    data.removeTeam(toLeave);
                                }
                            }
                            break block52;
                        }
                        catch (Exception ex) {
                            sender.func_145747_a(new TextComponentString("Must enter a valid playername to remove from your team: /team remove <playername>").func_150255_a(new Style().func_150238_a(TextFormatting.RED)));
                        }
                        break;
                    }
                    case "accept": {
                        EntityPlayer invitee = (EntityPlayer)sender;
                        EntityPlayerMP inviter = FMLCommonHandler.instance().getMinecraftServerInstance().func_184103_al().func_177451_a(UUID.fromString(invitee.getEntityData().func_74779_i("invitedby")));
                        UUID uid = invitee.func_110124_au();
                        if (inviter == null) {
                            sender.func_145747_a(new TextComponentString("You have not been invited to a team").func_150255_a(new Style().func_150238_a(TextFormatting.RED)));
                            break;
                        }
                        if (SaveData.teamMap.containsKey(uid)) {
                            sender.func_145747_a((ITextComponent)new TextComponentString("Removing you from your old team..."));
                            data.removePlayer(invitee, uid);
                        }
                        if (SaveData.teamMap.containsKey(inviter.func_110124_au()) && inviter != null && !ConfigHandler.server.disableAchievementSync) {
                            String name = SaveData.teamMap.get(inviter.func_110124_au());
                            Iterator<UUID> uuidIterator = SaveData.teamsMap.get(name).iterator();
                            while (uuidIterator.hasNext()) {
                                EntityPlayerMP playerMP = FMLCommonHandler.instance().getMinecraftServerInstance().func_184103_al().func_177451_a(uuidIterator.next());
                                if (playerMP == null) continue;
                                SaveData.syncPlayers(name, playerMP);
                            }
                        }
                        data.addPlayer((EntityPlayer)inviter, uid);
                        PacketHandler.INSTANCE.sendTo((IMessage)new MessageSaveData(SaveData.teamsMap), (EntityPlayerMP)invitee);
                        sender.func_145747_a((ITextComponent)new TextComponentString("Joined " + inviter.getDisplayNameString() + "'s team"));
                        inviter.func_145747_a((ITextComponent)new TextComponentString(invitee.getDisplayNameString() + " has joined your team!"));
                        break;
                    }
                    case "invite": {
                        if (args.length < 2) {
                            sender.func_145747_a(new TextComponentString("Must enter player name").func_150255_a(new Style().func_150238_a(TextFormatting.RED)));
                        }
                        EntityPlayerMP newPlayer = FMLCommonHandler.instance().getMinecraftServerInstance().func_184103_al().func_152612_a(args[1]);
                        EntityPlayer oldPlayer = (EntityPlayer)sender;
                        if (SaveData.teamMap.containsKey(oldPlayer.func_110124_au())) {
                            String teamName = SaveData.teamMap.get(oldPlayer.func_110124_au());
                            if (SaveData.teamsMap.get(teamName).contains(newPlayer.func_110124_au())) {
                                sender.func_145747_a((ITextComponent)new TextComponentString("That player is already on your team!"));
                                return;
                            }
                            newPlayer.getEntityData().func_74778_a("invitedby", oldPlayer.func_189512_bd());
                            oldPlayer.func_145747_a((ITextComponent)new TextComponentString("You have invited: " + newPlayer.getDisplayNameString() + " to your team"));
                            PacketHandler.INSTANCE.sendTo((IMessage)new MessageInvite(teamName), newPlayer);
                            newPlayer.func_145747_a((ITextComponent)new TextComponentString("You have been invited to join the team: " + teamName + ". Type /team accept to accept"));
                            break;
                        }
                        oldPlayer.func_145747_a(new TextComponentString("Failed to Invite : Either the player is invalid or you are not in a team!").func_150255_a(new Style().func_150238_a(TextFormatting.RED)));
                        break;
                    }
                    case "leave": {
                        try {
                            EntityPlayer p = (EntityPlayer)sender;
                            String toLeave = SaveData.teamMap.get(p.func_110124_au());
                            data.removePlayer(p, p.func_110124_au());
                            p.func_145747_a((ITextComponent)new TextComponentString("You left your team"));
                            if (SaveData.teamsMap.get(toLeave).isEmpty()) {
                                data.removeTeam(toLeave);
                            }
                            break block52;
                        }
                        catch (Exception ex) {
                            sender.func_145747_a(new TextComponentString("You're not in a team").func_150255_a(new Style().func_150238_a(TextFormatting.RED)));
                        }
                        break;
                    }
                    case "player": {
                        try {
                            String playerName = args[1];
                            if (SaveData.teamMap.containsKey(FMLCommonHandler.instance().getMinecraftServerInstance().func_152358_ax().func_152655_a(playerName).getId())) {
                                String playerteam = SaveData.teamMap.get(FMLCommonHandler.instance().getMinecraftServerInstance().func_152358_ax().func_152655_a(playerName).getId());
                                sender.func_145747_a((ITextComponent)new TextComponentString(playerName + " is in the following team:"));
                                sender.func_145747_a((ITextComponent)new TextComponentString(playerteam));
                                break;
                            }
                            sender.func_145747_a((ITextComponent)new TextComponentString(playerName + " is not in a team"));
                        }
                        catch (Exception ex) {
                            ex.printStackTrace();
                            sender.func_145747_a(new TextComponentString("Enter valid playername").func_150255_a(new Style().func_150238_a(TextFormatting.RED)));
                        }
                        break;
                    }
                    case "remove": {
                        if (!(ConfigHandler.server.noOpRemoveTeam || FMLCommonHandler.instance().getMinecraftServerInstance().func_71264_H() || sender.func_70003_b(2, ""))) {
                            sender.func_145747_a(new TextComponentString("You do not have permission to use this command").func_150255_a(new Style().func_150238_a(TextFormatting.RED)));
                            break;
                        }
                        try {
                            String teamName = args[1];
                            sender.func_145747_a((ITextComponent)new TextComponentString("The team \"" + teamName + "\" has been removed"));
                            data.removeTeam(teamName);
                        }
                        catch (Exception ex) {
                            sender.func_145747_a((ITextComponent)new TextComponentString("That team doesn't exist, or an error occurred"));
                        }
                        break;
                    }
                    case "info": {
                        sender.func_145747_a((ITextComponent)new TextComponentString("Players in Team: "));
                        try {
                            String teamName = args[1];
                            if (SaveData.teamsMap.containsKey(teamName)) {
                                for (UUID id : SaveData.teamsMap.get(teamName)) {
                                    GameProfile profile = FMLCommonHandler.instance().getMinecraftServerInstance().func_152358_ax().func_152652_a(id);
                                    if (profile == null) continue;
                                    sender.func_145747_a((ITextComponent)new TextComponentString(profile.getName()));
                                }
                            }
                            break block52;
                        }
                        catch (Exception ex) {
                            sender.func_145747_a(new TextComponentString("Enter team name to get info on").func_150255_a(new Style().func_150238_a(TextFormatting.RED)));
                            break;
                        }
                    }
                    default: {
                        sender.func_145747_a(new TextComponentString("Invalid command: try /help teams for more info").func_150255_a(new Style().func_150238_a(TextFormatting.RED)));
                    }
                }
                break block52;
            }
            sender.func_145747_a(new TextComponentString("Must include command: try /help teams for more info").func_150255_a(new Style().func_150238_a(TextFormatting.RED)));
        }
        PacketHandler.INSTANCE.sendToAll((IMessage)new MessageSaveData(SaveData.teamsMap));
    }

    public boolean func_184882_a(MinecraftServer server, ICommandSender sender) {
        return true;
    }

    public List<String> func_184883_a(MinecraftServer server, ICommandSender sender, String[] args, @Nullable BlockPos targetPos) {
        if (args.length < 2) {
            ArrayList<String> tabCompletions = new ArrayList<String>();
            if (args[0].contains("cr")) {
                tabCompletions.add("create");
            } else if (args[0].contains("li")) {
                tabCompletions.add("list");
            } else if (args[0].contains("di")) {
                tabCompletions.add("disband");
            } else if (args[0].contains("in")) {
                if (args[0].contains("inv")) {
                    tabCompletions.add("invite");
                } else if (args[0].contains("inf")) {
                    tabCompletions.add("info");
                } else {
                    tabCompletions.add("invite");
                    tabCompletions.add("info");
                }
            } else if (args[0].contains("pl")) {
                tabCompletions.add("player");
            } else if (args[0].contains("re")) {
                tabCompletions.add("remove");
            } else if (args[0].contains("k")) {
                tabCompletions.add("kick");
            } else if (args[0].contains("ac")) {
                tabCompletions.add("accept");
            } else {
                tabCompletions.add("create");
                tabCompletions.add("list");
                tabCompletions.add("disband");
                tabCompletions.add("invite");
                tabCompletions.add("info");
                tabCompletions.add("player");
                tabCompletions.add("remove");
                tabCompletions.add("kick");
                tabCompletions.add("accept");
            }
            return tabCompletions;
        }
        if (args[0].equals("invite") || args[0].equals("player") || args[0].equals("kick")) {
            ArrayList<String> playerList = new ArrayList<String>();
            for (EntityPlayer player : sender.func_130014_f_().field_73010_i) {
                playerList.add(player.getDisplayNameString());
            }
            return playerList;
        }
        if (args[0].equals("info") || args[0].equals("remove")) {
            return new ArrayList<String>(SaveData.teamsMap.keySet());
        }
        return NonNullList.func_191196_a();
    }

    public boolean func_82358_a(String[] args, int index) {
        return false;
    }
}

