/*
 * Decompiled with CFR 0.152.
 */
package com.daposeidonguy.teamsmod.handlers;

import com.daposeidonguy.teamsmod.handlers.ConfigHandler;
import com.daposeidonguy.teamsmod.network.MessageChat;
import com.daposeidonguy.teamsmod.network.MessageDeath;
import com.daposeidonguy.teamsmod.network.MessageHealth;
import com.daposeidonguy.teamsmod.network.MessageHunger;
import com.daposeidonguy.teamsmod.network.MessageSaveData;
import com.daposeidonguy.teamsmod.network.PacketHandler;
import com.daposeidonguy.teamsmod.team.SaveData;
import java.util.UUID;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraft.util.text.TextComponentString;
import net.minecraftforge.common.config.Config;
import net.minecraftforge.common.config.ConfigManager;
import net.minecraftforge.event.ServerChatEvent;
import net.minecraftforge.event.entity.living.LivingAttackEvent;
import net.minecraftforge.event.entity.living.LivingDeathEvent;
import net.minecraftforge.event.entity.living.LivingHealEvent;
import net.minecraftforge.event.entity.living.LivingHurtEvent;
import net.minecraftforge.event.entity.player.AdvancementEvent;
import net.minecraftforge.fml.client.event.ConfigChangedEvent;
import net.minecraftforge.fml.common.FMLCommonHandler;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.fml.common.eventhandler.SubscribeEvent;
import net.minecraftforge.fml.common.gameevent.PlayerEvent;
import net.minecraftforge.fml.common.gameevent.TickEvent;
import net.minecraftforge.fml.common.network.simpleimpl.IMessage;

@Mod.EventBusSubscriber
public class CommonEventHandler {
    public static int ticks = 0;

    @SubscribeEvent
    public static void tickEvent(TickEvent.ServerTickEvent event) {
        if (++ticks == 200 && !FMLCommonHandler.instance().getMinecraftServerInstance().func_130014_f_().field_72995_K) {
            for (EntityPlayerMP playerMP : FMLCommonHandler.instance().getMinecraftServerInstance().func_184103_al().func_181057_v()) {
                PacketHandler.INSTANCE.sendToAll((IMessage)new MessageHealth(playerMP.func_110124_au(), (int)playerMP.func_110143_aJ()));
                PacketHandler.INSTANCE.sendToAll((IMessage)new MessageHunger(playerMP.func_110124_au(), playerMP.func_71024_bL().func_75116_a()));
            }
            ticks = 0;
        }
    }

    @SubscribeEvent
    public static void onChat(ServerChatEvent event) {
        String teamName;
        PacketHandler.INSTANCE.sendToAll((IMessage)new MessageChat(event.getPlayer().getDisplayNameString(), event.getMessage()));
        if (ConfigHandler.server.prefixServerSide && !ConfigHandler.server.disablePrefix && (teamName = SaveData.teamMap.get(event.getPlayer().func_110124_au())) != null) {
            TextComponentString prefix = new TextComponentString("[" + teamName + "] ");
            event.setComponent(prefix.func_150257_a(event.getComponent()));
        }
    }

    @SubscribeEvent
    public static void onPlayerDamage(LivingHurtEvent event) {
        if (event.getEntity() instanceof EntityPlayer && !event.getEntity().func_130014_f_().field_72995_K && SaveData.teamMap.containsKey(event.getEntity().func_110124_au())) {
            int health = (int)(event.getEntityLiving().func_110143_aJ() - event.getAmount());
            PacketHandler.INSTANCE.sendToAll((IMessage)new MessageHealth(event.getEntity().func_110124_au(), health));
            PacketHandler.INSTANCE.sendToAll((IMessage)new MessageHunger(event.getEntity().func_110124_au(), ((EntityPlayer)event.getEntity()).func_71024_bL().func_75116_a()));
        }
    }

    @SubscribeEvent
    public static void onPlayerDeath(LivingDeathEvent event) {
        String team;
        if (event.getEntity() instanceof EntityPlayer && !event.getEntity().func_130014_f_().field_72995_K && (team = SaveData.teamMap.get(event.getEntity().func_110124_au())) != null) {
            for (UUID uuid : SaveData.teamsMap.get(team)) {
                if (event.getEntity().func_110124_au().equals(uuid)) continue;
                EntityPlayerMP playerMP = FMLCommonHandler.instance().getMinecraftServerInstance().func_184103_al().func_177451_a(uuid);
                PacketHandler.INSTANCE.sendTo((IMessage)new MessageDeath(), playerMP);
            }
        }
    }

    @SubscribeEvent
    public static void onPlayerHeal(LivingHealEvent event) {
        if (event.getEntity() instanceof EntityPlayer && !event.getEntity().func_130014_f_().field_72995_K && SaveData.teamMap.containsKey(event.getEntity().func_110124_au())) {
            PacketHandler.INSTANCE.sendToAll((IMessage)new MessageHealth(event.getEntity().func_110124_au(), (int)((EntityPlayer)event.getEntity()).func_110143_aJ()));
            PacketHandler.INSTANCE.sendToAll((IMessage)new MessageHunger(event.getEntity().func_110124_au(), ((EntityPlayer)event.getEntity()).func_71024_bL().func_75116_a()));
        }
    }

    @SubscribeEvent
    public static void playerHitPlayer(LivingAttackEvent event) {
        if (!ConfigHandler.server.enableFriendlyFire && event.getSource().func_76346_g() instanceof EntityPlayer && event.getEntityLiving() instanceof EntityPlayer) {
            EntityPlayer attacker = (EntityPlayer)event.getSource().func_76346_g();
            EntityPlayer target = (EntityPlayer)event.getEntityLiving();
            String targetTeam = null;
            String attackerTeam = null;
            if (SaveData.teamMap.containsKey(target.func_110124_au())) {
                targetTeam = SaveData.teamMap.get(target.func_110124_au());
            }
            if (SaveData.teamMap.containsKey(attacker.func_110124_au())) {
                attackerTeam = SaveData.teamMap.get(attacker.func_110124_au());
            }
            if (targetTeam != null && attackerTeam != null && targetTeam.equals(attackerTeam)) {
                event.setCanceled(true);
            }
        }
    }

    @SubscribeEvent
    public static void configUpdate(ConfigChangedEvent.OnConfigChangedEvent event) {
        if (event.getModID().equals("teamsmod")) {
            ConfigManager.sync((String)"teamsmod", (Config.Type)Config.Type.INSTANCE);
        }
    }

    @SubscribeEvent
    public static void playerJoin(PlayerEvent.PlayerLoggedInEvent event) {
        if (!FMLCommonHandler.instance().getSide().isServer()) {
            SaveData.get(FMLCommonHandler.instance().getMinecraftServerInstance().func_130014_f_());
            PacketHandler.INSTANCE.sendToAll((IMessage)new MessageSaveData(SaveData.teamsMap));
        }
        if (!FMLCommonHandler.instance().getSide().isServer() && !ConfigHandler.server.disableAchievementSync && SaveData.teamMap.containsKey(event.player.func_110124_au())) {
            String team = SaveData.teamMap.get(event.player.func_110124_au());
            SaveData.syncPlayers(team, (EntityPlayerMP)event.player);
        }
    }

    @SubscribeEvent
    public static void playerQuit(PlayerEvent.PlayerLoggedOutEvent event) {
        if (!event.player.func_130014_f_().field_72995_K) {
            PacketHandler.INSTANCE.sendToAll((IMessage)new MessageSaveData(SaveData.teamsMap));
        }
    }

    @SubscribeEvent
    public static void achievementGet(AdvancementEvent event) {
        EntityPlayer player;
        if (!ConfigHandler.server.disableAchievementSync && SaveData.teamMap.containsKey((player = event.getEntityPlayer()).func_110124_au()) && !event.getEntity().func_130014_f_().field_72995_K) {
            String team = SaveData.teamMap.get(player.func_110124_au());
            for (UUID id : SaveData.teamsMap.get(team)) {
                EntityPlayerMP playerMP = (EntityPlayerMP)player.func_130014_f_().func_152378_a(id);
                SaveData.syncPlayers(team, playerMP);
            }
        }
    }
}

