/*
 * Decompiled with CFR 0.152.
 */
package com.daposeidonguy.teamsmod.team;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.UUID;
import net.minecraft.advancements.Advancement;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.nbt.NBTTagList;
import net.minecraft.world.World;
import net.minecraft.world.storage.MapStorage;
import net.minecraft.world.storage.WorldSavedData;
import net.minecraftforge.fml.common.FMLCommonHandler;

public class SaveData
extends WorldSavedData {
    public static final String NAME = "teamsmod";
    public static Map<UUID, String> teamMap = new HashMap<UUID, String>();
    public static Map<String, List<UUID>> teamsMap = new HashMap<String, List<UUID>>();

    public SaveData() {
        super(NAME);
    }

    public SaveData(String name) {
        super(name);
        this.func_76185_a();
    }

    public static SaveData get(World world) {
        MapStorage storage = world.func_175693_T();
        SaveData data = (SaveData)storage.func_75742_a(SaveData.class, NAME);
        if (data == null) {
            data = new SaveData();
            world.func_72823_a(NAME, (WorldSavedData)data);
        }
        return data;
    }

    public static void syncPlayers(String team, EntityPlayerMP player) {
        if (!FMLCommonHandler.instance().getMinecraftServerInstance().func_130014_f_().field_72995_K && player != null) {
            for (Advancement adv : FMLCommonHandler.instance().getMinecraftServerInstance().func_191949_aK().func_192780_b()) {
                for (UUID id : teamsMap.get(team)) {
                    EntityPlayerMP teammate = (EntityPlayerMP)FMLCommonHandler.instance().getMinecraftServerInstance().func_130014_f_().func_152378_a(id);
                    if (teammate == null) continue;
                    if (teammate.func_192039_O().func_192747_a(adv).func_192105_a()) {
                        for (String s : teammate.func_192039_O().func_192747_a(adv).func_192102_e()) {
                            player.func_192039_O().func_192750_a(adv, s);
                        }
                        continue;
                    }
                    if (!player.func_192039_O().func_192747_a(adv).func_192105_a()) continue;
                    for (String s : player.func_192039_O().func_192747_a(adv).func_192102_e()) {
                        teammate.func_192039_O().func_192750_a(adv, s);
                    }
                }
            }
        }
    }

    public void addTeam(String name, EntityPlayer player) {
        ArrayList<UUID> tempList = new ArrayList<UUID>();
        tempList.add(player.func_110124_au());
        teamsMap.put(name, tempList);
        teamMap.put(player.func_110124_au(), name);
        this.func_76185_a();
    }

    public void addPlayer(EntityPlayer p, UUID uid) {
        String name = teamMap.get(p.func_110124_au());
        teamsMap.get(name).add(uid);
        teamMap.put(uid, name);
        this.func_76185_a();
    }

    public void removePlayer(EntityPlayer p, UUID uid) {
        String name = teamMap.get(p.func_110124_au());
        teamsMap.get(name).remove(uid);
        teamMap.remove(uid);
        this.func_76185_a();
    }

    public void removeTeam(String name) {
        for (UUID id : teamsMap.get(name)) {
            teamMap.remove(id);
        }
        teamsMap.remove(name);
        this.func_76185_a();
    }

    public void func_76184_a(NBTTagCompound nbt) {
        teamsMap.clear();
        teamMap.clear();
        String name = "";
        for (NBTTagCompound tagCompound : nbt.func_150295_c("Teams", 10)) {
            Iterator playerTagListIterator = tagCompound.func_150295_c("Player List", 10).iterator();
            ArrayList<UUID> uuidList = new ArrayList<UUID>();
            while (playerTagListIterator.hasNext()) {
                NBTTagCompound playerTag = (NBTTagCompound)playerTagListIterator.next();
                UUID id = UUID.fromString(playerTag.func_74779_i("uuid"));
                name = tagCompound.func_74779_i("Team Name");
                teamMap.put(id, name);
                uuidList.add(id);
            }
            teamsMap.put(name, uuidList);
        }
    }

    public NBTTagCompound func_189551_b(NBTTagCompound compound) {
        NBTTagList tagList = new NBTTagList();
        Iterator<String> iteratorTeams = teamsMap.keySet().iterator();
        while (iteratorTeams.hasNext()) {
            NBTTagCompound tagCompound = new NBTTagCompound();
            String team = iteratorTeams.next();
            tagCompound.func_74778_a("Team Name", team);
            NBTTagList playerListTag = new NBTTagList();
            for (UUID id : teamsMap.get(team)) {
                NBTTagCompound playerTag = new NBTTagCompound();
                playerTag.func_74778_a("uuid", id.toString());
                playerListTag.func_74742_a((NBTBase)playerTag);
            }
            tagCompound.func_74782_a("Player List", (NBTBase)playerListTag);
            tagList.func_74742_a((NBTBase)tagCompound);
        }
        compound.func_74782_a("Teams", (NBTBase)tagList);
        return compound;
    }
}

