/*
 * Decompiled with CFR 0.152.
 */
package com.daposeidonguy.teamsmod.client.gui;

import com.daposeidonguy.teamsmod.client.ClientEventHandler;
import com.daposeidonguy.teamsmod.client.gui.overlay.OverlayTeam;
import com.daposeidonguy.teamsmod.client.gui.screen.team.ScreenTeam;
import com.daposeidonguy.teamsmod.common.config.TeamConfig;
import com.daposeidonguy.teamsmod.common.storage.SaveData;
import com.mojang.blaze3d.matrix.MatrixStack;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.UUID;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.FontRenderer;
import net.minecraft.client.gui.screen.Screen;
import net.minecraft.client.gui.screen.inventory.CreativeScreen;
import net.minecraft.client.gui.screen.inventory.InventoryScreen;
import net.minecraft.client.gui.widget.Widget;
import net.minecraft.client.gui.widget.button.ImageButton;
import net.minecraft.client.network.play.NetworkPlayerInfo;
import net.minecraft.client.renderer.IRenderTypeBuffer;
import net.minecraft.client.renderer.Matrix4f;
import net.minecraft.client.renderer.entity.EntityRendererManager;
import net.minecraft.entity.Entity;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.SoundEvents;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.StringTextComponent;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.client.event.GuiScreenEvent;
import net.minecraftforge.client.event.RenderGameOverlayEvent;
import net.minecraftforge.client.event.RenderPlayerEvent;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.fml.common.thread.EffectiveSide;

@Mod.EventBusSubscriber(modid="teamsmod", bus=Mod.EventBusSubscriber.Bus.FORGE, value={Dist.CLIENT})
public class GuiHandler {
    public static Map<UUID, Integer> hungerMap = new HashMap<UUID, Integer>();
    public static Map<UUID, Integer> healthMap = new HashMap<UUID, Integer>();
    public static List<UUID> priorityPlayers = new ArrayList<UUID>();

    private static void renderChat(EntityRendererManager renderManager, PlayerEntity player, String text, MatrixStack stack, IRenderTypeBuffer buffer, int light) {
        double d0 = renderManager.func_229099_b_((Entity)player);
        if (!(d0 > 2048.0)) {
            boolean flag = !player.func_226273_bm_();
            float f = player.func_213302_cg() + 0.85f;
            stack.func_227860_a_();
            stack.func_227861_a_(0.0, (double)f, 0.0);
            stack.func_227863_a_(renderManager.func_229098_b_());
            stack.func_227862_a_(-0.025f, -0.025f, 0.025f);
            Matrix4f matrix4f = stack.func_227866_c_().func_227870_a_();
            float f1 = Minecraft.func_71410_x().field_71474_y.func_216840_a(0.25f);
            int j = (int)(f1 * 255.0f) << 24;
            FontRenderer fontrenderer = renderManager.func_78716_a();
            float f2 = -fontrenderer.func_78256_a(text) / 2;
            fontrenderer.func_228079_a_(text, f2, 0.0f, 0x20FFFFFF, false, matrix4f, buffer, flag, j, light);
            if (flag) {
                fontrenderer.func_228079_a_(text, f2, 0.0f, -1, false, matrix4f, buffer, false, 0, light);
            }
            stack.func_227865_b_();
        }
    }

    @SubscribeEvent
    public static void renderPlayer(RenderPlayerEvent.Pre event) {
        String playerName = event.getPlayer().func_146103_bH().getName();
        String localName = Minecraft.func_71410_x().field_71439_g.func_146103_bH().getName();
        if (!localName.equals(playerName) && ClientEventHandler.chatMap.containsKey(playerName)) {
            String text = (String)ClientEventHandler.chatMap.get(playerName).getFirst();
            long tick = (Long)ClientEventHandler.chatMap.get(playerName).getSecond();
            if (ClientEventHandler.ticks - tick < 200L) {
                GuiHandler.renderChat(event.getRenderer().func_177068_d(), event.getPlayer(), text, event.getMatrixStack(), event.getBuffers(), event.getLight());
            } else {
                ClientEventHandler.chatMap.remove(playerName);
            }
        }
    }

    @SubscribeEvent
    public static void showGuiButton(GuiScreenEvent.InitGuiEvent.Post event) {
        if (event.getGui() instanceof InventoryScreen) {
            InventoryScreen guiInventory = (InventoryScreen)event.getGui();
            ImageButton guiButtonImage = !TeamConfig.smallIcon ? (TeamConfig.useAlternatePosition ? new ImageButton(4, 4, 20, 18, 0, 0, 18, new ResourceLocation("teamsmod", "textures/gui/button.png"), pressable -> {
                Minecraft.func_71410_x().field_71439_g.func_184185_a(SoundEvents.field_187909_gi, 1.0f, 1.0f);
                Minecraft.func_71410_x().func_147108_a((Screen)new ScreenTeam((ITextComponent)new StringTextComponent("Team")));
            }) : new ImageButton(guiInventory.getGuiLeft() + 152, guiInventory.getGuiTop() + 4, 20, 18, 0, 0, 18, new ResourceLocation("teamsmod", "textures/gui/button.png"), pressable -> {
                Minecraft.func_71410_x().field_71439_g.func_184185_a(SoundEvents.field_187909_gi, 1.0f, 1.0f);
                Minecraft.func_71410_x().func_147108_a((Screen)new ScreenTeam((ITextComponent)new StringTextComponent("Team")));
            })) : (TeamConfig.useAlternatePosition ? new ImageButton(2, 2, 15, 14, 0, 0, 13, new ResourceLocation("teamsmod", "textures/gui/buttonsmall.png"), pressable -> {
                Minecraft.func_71410_x().field_71439_g.func_184185_a(SoundEvents.field_187909_gi, 1.0f, 1.0f);
                Minecraft.func_71410_x().func_147108_a((Screen)new ScreenTeam((ITextComponent)new StringTextComponent("Team")));
            }) : new ImageButton(guiInventory.getGuiLeft() + 155, guiInventory.getGuiTop() + 5, 15, 14, 0, 0, 13, new ResourceLocation("teamsmod", "textures/gui/buttonsmall.png"), pressable -> {
                Minecraft.func_71410_x().field_71439_g.func_184185_a(SoundEvents.field_187909_gi, 1.0f, 1.0f);
                Minecraft.func_71410_x().func_147108_a((Screen)new ScreenTeam((ITextComponent)new StringTextComponent("Team")));
            }));
            event.addWidget((Widget)guiButtonImage);
        } else if (event.getGui() instanceof CreativeScreen) {
            ImageButton guiButtonImage = !TeamConfig.smallIcon ? new ImageButton(4, 4, 20, 18, 0, 0, 18, new ResourceLocation("teamsmod", "textures/gui/button.png"), pressable -> {
                Minecraft.func_71410_x().field_71439_g.func_184185_a(SoundEvents.field_187909_gi, 1.0f, 1.0f);
                Minecraft.func_71410_x().func_147108_a((Screen)new ScreenTeam((ITextComponent)new StringTextComponent("Team")));
            }) : new ImageButton(2, 2, 15, 14, 0, 0, 13, new ResourceLocation("teamsmod", "textures/gui/buttonsmall.png"), pressable -> {
                Minecraft.func_71410_x().field_71439_g.func_184185_a(SoundEvents.field_187909_gi, 1.0f, 1.0f);
                Minecraft.func_71410_x().func_147108_a((Screen)new ScreenTeam((ITextComponent)new StringTextComponent("Team")));
            });
            event.addWidget((Widget)guiButtonImage);
        }
    }

    private static void renderPlayerHUD(UUID uuid, int offsety) {
        int hunger;
        int health;
        Minecraft mc = Minecraft.func_71410_x();
        NetworkPlayerInfo info = mc.field_71439_g.field_71174_a.func_175102_a(uuid);
        if (info == null) {
            return;
        }
        try {
            health = healthMap.get(uuid);
        }
        catch (NullPointerException ex) {
            health = 20;
        }
        if (health < 0) {
            return;
        }
        try {
            hunger = hungerMap.get(uuid);
        }
        catch (NullPointerException ex) {
            hunger = 20;
        }
        String name = ClientEventHandler.idtoNameMap.get(uuid);
        if (name == null) {
            name = info.func_178845_a().getName();
        }
        ResourceLocation skin = info.func_178837_g();
        new OverlayTeam(mc, offsety, health, hunger, name, skin);
    }

    @SubscribeEvent
    public static void renderHUDEvent(RenderGameOverlayEvent.Post event) {
        UUID id;
        String team;
        if (EffectiveSide.get().isClient() && !TeamConfig.disableTeamsHUD && ClientEventHandler.displayHud && !event.isCancelable() && event.getType() == RenderGameOverlayEvent.ElementType.EXPERIENCE && (team = SaveData.teamMap.get(id = Minecraft.func_71410_x().field_71439_g.func_110124_au())) != null) {
            int offsety = 0;
            int count = 0;
            Iterator<UUID> teamIterator = SaveData.teamsMap.get(team).iterator();
            while (teamIterator.hasNext() && count < 4) {
                UUID uuid = teamIterator.next();
                if (priorityPlayers.contains(uuid) || uuid.equals(id)) continue;
                GuiHandler.renderPlayerHUD(uuid, offsety);
                offsety += 46;
                ++count;
            }
        }
    }
}

