/*
 * Decompiled with CFR 0.152.
 */
package com.daposeidonguy.teamsmod.common;

import com.daposeidonguy.teamsmod.common.config.TeamConfig;
import com.daposeidonguy.teamsmod.common.network.MessageChat;
import com.daposeidonguy.teamsmod.common.network.MessageDeath;
import com.daposeidonguy.teamsmod.common.network.MessageHealth;
import com.daposeidonguy.teamsmod.common.network.MessageHunger;
import com.daposeidonguy.teamsmod.common.network.MessageSaveData;
import com.daposeidonguy.teamsmod.common.network.PacketHandler;
import com.daposeidonguy.teamsmod.common.storage.SaveData;
import java.util.UUID;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.entity.player.ServerPlayerEntity;
import net.minecraft.util.text.StringTextComponent;
import net.minecraft.world.dimension.DimensionType;
import net.minecraftforge.event.ServerChatEvent;
import net.minecraftforge.event.TickEvent;
import net.minecraftforge.event.entity.EntityJoinWorldEvent;
import net.minecraftforge.event.entity.living.LivingAttackEvent;
import net.minecraftforge.event.entity.living.LivingDeathEvent;
import net.minecraftforge.event.entity.living.LivingHealEvent;
import net.minecraftforge.event.entity.living.LivingHurtEvent;
import net.minecraftforge.event.entity.player.AdvancementEvent;
import net.minecraftforge.event.entity.player.PlayerEvent;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.fml.common.thread.EffectiveSide;
import net.minecraftforge.fml.network.PacketDistributor;
import net.minecraftforge.fml.server.ServerLifecycleHooks;

@Mod.EventBusSubscriber(modid="teamsmod", bus=Mod.EventBusSubscriber.Bus.FORGE)
public class CommonEventHandler {
    public static int ticks = 0;

    @SubscribeEvent
    public static void tickEvent(TickEvent.ServerTickEvent event) {
        if (++ticks == 250 && EffectiveSide.get().isServer()) {
            for (ServerPlayerEntity playerMP : ServerLifecycleHooks.getCurrentServer().func_184103_al().func_181057_v()) {
                PacketHandler.INSTANCE.send(PacketDistributor.ALL.noArg(), (Object)new MessageHealth(playerMP.func_110124_au(), (int)playerMP.func_110143_aJ()));
                PacketHandler.INSTANCE.send(PacketDistributor.ALL.noArg(), (Object)new MessageHunger(playerMP.func_110124_au(), playerMP.func_71024_bL().func_75116_a()));
            }
            ticks = 0;
        }
    }

    @SubscribeEvent
    public static void onPlayerChat(ServerChatEvent event) {
        String teamName;
        PacketHandler.INSTANCE.send(PacketDistributor.ALL.noArg(), (Object)new MessageChat(event.getPlayer().func_146103_bH().getName(), event.getMessage()));
        if (TeamConfig.prefixServerSide && !TeamConfig.disablePrefixServer && (teamName = SaveData.teamMap.get(event.getPlayer().func_110124_au())) != null) {
            StringTextComponent prefix = new StringTextComponent("[" + teamName + "] ");
            event.setComponent(prefix.func_150257_a(event.getComponent()));
        }
    }

    @SubscribeEvent
    public static void onPlayerDamage(LivingHurtEvent event) {
        String teamName;
        if (event.getEntity() instanceof PlayerEntity && EffectiveSide.get().isServer() && (teamName = SaveData.teamMap.get(event.getEntity().func_110124_au())) != null) {
            int health = (int)(event.getEntityLiving().func_110143_aJ() - event.getAmount());
            PacketHandler.INSTANCE.send(PacketDistributor.ALL.noArg(), (Object)new MessageHealth(event.getEntity().func_110124_au(), health));
            PacketHandler.INSTANCE.send(PacketDistributor.ALL.noArg(), (Object)new MessageHunger(event.getEntity().func_110124_au(), ((PlayerEntity)event.getEntity()).func_71024_bL().func_75116_a()));
        }
    }

    @SubscribeEvent
    public static void onPlayerDeath(LivingDeathEvent event) {
        String team;
        if (event.getEntity() instanceof PlayerEntity && !event.getEntity().func_130014_f_().field_72995_K && (team = SaveData.teamMap.get(event.getEntity().func_110124_au())) != null) {
            for (UUID uuid : SaveData.teamsMap.get(team)) {
                if (event.getEntity().func_110124_au().equals(uuid)) continue;
                ServerPlayerEntity playerMP = ServerLifecycleHooks.getCurrentServer().func_184103_al().func_177451_a(uuid);
                PacketHandler.INSTANCE.send(PacketDistributor.PLAYER.with(() -> playerMP), (Object)new MessageDeath());
            }
        }
    }

    @SubscribeEvent
    public static void onPlayerHeal(LivingHealEvent event) {
        if (event.getEntity() instanceof PlayerEntity && EffectiveSide.get().isServer() && SaveData.teamMap.containsKey(event.getEntity().func_110124_au())) {
            PacketHandler.INSTANCE.send(PacketDistributor.ALL.noArg(), (Object)new MessageHealth(event.getEntity().func_110124_au(), (int)((PlayerEntity)event.getEntity()).func_110143_aJ()));
            PacketHandler.INSTANCE.send(PacketDistributor.ALL.noArg(), (Object)new MessageHunger(event.getEntity().func_110124_au(), ((PlayerEntity)event.getEntity()).func_71024_bL().func_75116_a()));
        }
    }

    @SubscribeEvent
    public static void playerHitPlayer(LivingAttackEvent event) {
        if (!TeamConfig.enableFriendlyFire && event.getSource().func_76346_g() instanceof PlayerEntity && event.getEntityLiving() instanceof PlayerEntity) {
            PlayerEntity attacker = (PlayerEntity)event.getSource().func_76346_g();
            PlayerEntity target = (PlayerEntity)event.getEntityLiving();
            String targetTeam = null;
            String attackerTeam = null;
            if (SaveData.teamMap.containsKey(target.func_110124_au())) {
                targetTeam = SaveData.teamMap.get(target.func_110124_au());
            }
            if (SaveData.teamMap.containsKey(attacker.func_110124_au())) {
                attackerTeam = SaveData.teamMap.get(attacker.func_110124_au());
            }
            if (targetTeam != null && attackerTeam != null && targetTeam.equals(attackerTeam)) {
                event.setCanceled(true);
            }
        }
    }

    @SubscribeEvent
    public static void playerJoin(EntityJoinWorldEvent event) {
        if (EffectiveSide.get().isServer() && event.getEntity() instanceof PlayerEntity) {
            SaveData.get(event.getEntity().func_184102_h().func_71218_a(DimensionType.field_223227_a_));
            PacketHandler.INSTANCE.send(PacketDistributor.ALL.noArg(), (Object)new MessageSaveData(SaveData.teamsMap));
        }
        if (EffectiveSide.get().isServer() && !TeamConfig.disableAchievementSync && event.getEntity() instanceof PlayerEntity && SaveData.teamMap.containsKey(event.getEntity().func_110124_au())) {
            String team = SaveData.teamMap.get(event.getEntity().func_110124_au());
            SaveData.syncPlayers(team, (ServerPlayerEntity)event.getEntity());
        }
    }

    @SubscribeEvent
    public static void playerQuit(PlayerEvent.PlayerLoggedOutEvent event) {
        if (!event.getPlayer().func_130014_f_().field_72995_K && !ServerLifecycleHooks.getCurrentServer().func_71264_H()) {
            PacketHandler.INSTANCE.send(PacketDistributor.ALL.noArg(), (Object)new MessageSaveData(SaveData.teamsMap));
        }
    }

    @SubscribeEvent
    public static void achievementGet(AdvancementEvent event) {
        PlayerEntity player;
        if (!TeamConfig.disableAchievementSync && SaveData.teamMap.containsKey((player = event.getPlayer()).func_110124_au()) && !event.getEntity().func_130014_f_().field_72995_K) {
            String team = SaveData.teamMap.get(player.func_110124_au());
            for (UUID id : SaveData.teamsMap.get(team)) {
                ServerPlayerEntity playerMP = (ServerPlayerEntity)player.func_130014_f_().func_217371_b(id);
                SaveData.syncPlayers(team, playerMP);
            }
        }
    }
}

