/*
 * Decompiled with CFR 0.152.
 */
package com.daposeidonguy.teamsmod.common.commands;

import com.daposeidonguy.teamsmod.common.config.TeamConfig;
import com.daposeidonguy.teamsmod.common.network.MessageInvite;
import com.daposeidonguy.teamsmod.common.network.MessageSaveData;
import com.daposeidonguy.teamsmod.common.network.PacketHandler;
import com.daposeidonguy.teamsmod.common.storage.SaveData;
import com.mojang.authlib.GameProfile;
import com.mojang.brigadier.CommandDispatcher;
import com.mojang.brigadier.arguments.ArgumentType;
import com.mojang.brigadier.arguments.StringArgumentType;
import com.mojang.brigadier.builder.LiteralArgumentBuilder;
import com.mojang.brigadier.context.CommandContext;
import com.mojang.brigadier.exceptions.CommandSyntaxException;
import com.mojang.brigadier.suggestion.SuggestionProvider;
import com.mojang.brigadier.suggestion.Suggestions;
import java.util.Iterator;
import java.util.Set;
import java.util.UUID;
import net.minecraft.command.CommandException;
import net.minecraft.command.CommandSource;
import net.minecraft.command.Commands;
import net.minecraft.command.arguments.EntityArgument;
import net.minecraft.command.arguments.SuggestionProviders;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.entity.player.ServerPlayerEntity;
import net.minecraft.server.MinecraftServer;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.StringTextComponent;
import net.minecraft.world.dimension.DimensionType;
import net.minecraftforge.fml.network.PacketDistributor;
import net.minecraftforge.fml.server.ServerLifecycleHooks;

public class CommandTeam {
    private static String[] aliases = new String[]{"teamsmod", "teams", "t"};

    public static void register(CommandDispatcher<CommandSource> dispatcher) {
        MinecraftServer server = ServerLifecycleHooks.getCurrentServer();
        for (String alias : aliases) {
            dispatcher.register((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)Commands.func_197057_a((String)alias).then(Commands.func_197057_a((String)"create").then(Commands.func_197056_a((String)"teamName", (ArgumentType)StringArgumentType.word()).executes(ctx -> CommandTeam.teamCreate(server, (CommandSource)ctx.getSource(), StringArgumentType.getString((CommandContext)ctx, (String)"teamName")))))).then(Commands.func_197057_a((String)"list").executes(ctx -> CommandTeam.teamList(server, (CommandSource)ctx.getSource())))).then(Commands.func_197057_a((String)"info").then(Commands.func_197056_a((String)"teamName", (ArgumentType)StringArgumentType.word()).suggests(TeamCompletionProvider.TEAMS).executes(ctx -> CommandTeam.teamInfo(server, (CommandSource)ctx.getSource(), StringArgumentType.getString((CommandContext)ctx, (String)"teamName")))))).then(Commands.func_197057_a((String)"player").then(Commands.func_197056_a((String)"playerName", (ArgumentType)EntityArgument.func_197096_c()).executes(ctx -> CommandTeam.teamPlayer(server, (CommandSource)ctx.getSource(), EntityArgument.func_197089_d((CommandContext)ctx, (String)"playerName").func_146103_bH().getName()))))).then(Commands.func_197057_a((String)"invite").then(Commands.func_197056_a((String)"playerName", (ArgumentType)EntityArgument.func_197096_c()).executes(ctx -> CommandTeam.teamInvite(server, (CommandSource)ctx.getSource(), EntityArgument.func_197089_d((CommandContext)ctx, (String)"playerName").func_146103_bH().getName()))))).then(Commands.func_197057_a((String)"accept").executes(ctx -> CommandTeam.teamAccept(server, (CommandSource)ctx.getSource())))).then(Commands.func_197057_a((String)"kick").then(Commands.func_197056_a((String)"playerName", (ArgumentType)EntityArgument.func_197096_c()).executes(ctx -> CommandTeam.teamKick(server, (CommandSource)ctx.getSource(), EntityArgument.func_197089_d((CommandContext)ctx, (String)"playerName").func_146103_bH().getName()))))).then(Commands.func_197057_a((String)"leave").executes(ctx -> CommandTeam.teamLeave(server, (CommandSource)ctx.getSource())))).then(Commands.func_197057_a((String)"remove").then(Commands.func_197056_a((String)"teamName", (ArgumentType)StringArgumentType.word()).suggests(TeamCompletionProvider.TEAMS).executes(ctx -> CommandTeam.teamRemove(server, (CommandSource)ctx.getSource(), StringArgumentType.getString((CommandContext)ctx, (String)"teamName")))))).executes(ctx -> {
                ((CommandSource)ctx.getSource()).func_197030_a((ITextComponent)new StringTextComponent("Teams Commands: \n/team create <name> : creates team with the name <name>\n/team list : lists all created teams\n/team info <name> : lists all players in the team with name <name>\n/team player <name> : prints the team of the player with name <name>\n/team invite <name> : invites player with name <name> to your team\n/team accept : accepts invitation to team\n/team kick <name> : kicks player with name <name> from your team\n/team leave : leaves your team\n/team remove <name> : ADMIN ONLY - deletes the team with name <name>"), false);
                return 0;
            }));
        }
    }

    private static int teamCreate(MinecraftServer server, CommandSource sender, String name) throws CommandSyntaxException {
        SaveData data = SaveData.get(server.func_71218_a(DimensionType.field_223227_a_));
        ServerPlayerEntity player = sender.func_197035_h();
        if (SaveData.teamsMap.containsKey(name)) {
            throw new CommandException((ITextComponent)new StringTextComponent("Team name already exists"));
        }
        if (name.contains(">") || name.contains("<")) {
            throw new CommandException((ITextComponent)new StringTextComponent("Team name cannot contain '<' or '>'"));
        }
        if (SaveData.teamMap.containsKey(player.func_110124_au())) {
            throw new CommandException((ITextComponent)new StringTextComponent("You're already in a team! Leave it first"));
        }
        sender.func_197030_a((ITextComponent)new StringTextComponent("Created team: " + name), false);
        data.addTeam(name, (PlayerEntity)player);
        PacketHandler.INSTANCE.send(PacketDistributor.ALL.noArg(), (Object)new MessageSaveData(SaveData.teamsMap));
        return 1;
    }

    private static int teamList(MinecraftServer server, CommandSource sender) {
        int len = 1;
        SaveData.get(server.func_71218_a(DimensionType.field_223227_a_));
        sender.func_197030_a((ITextComponent)new StringTextComponent("List of teams:"), false);
        Iterator<String> teamIterator = SaveData.teamsMap.keySet().iterator();
        while (teamIterator.hasNext()) {
            ++len;
            sender.func_197030_a((ITextComponent)new StringTextComponent(teamIterator.next()), false);
        }
        return len;
    }

    private static int teamInfo(MinecraftServer server, CommandSource sender, String teamName) throws CommandException {
        SaveData.get(server.func_71218_a(DimensionType.field_223227_a_));
        int len = 1;
        if (!SaveData.teamsMap.containsKey(teamName)) {
            throw new CommandException((ITextComponent)new StringTextComponent("Enter valid team"));
        }
        sender.func_197030_a((ITextComponent)new StringTextComponent("Players in Team: "), false);
        Iterator<UUID> uuidIterator = SaveData.teamsMap.get(teamName).iterator();
        while (uuidIterator.hasNext()) {
            ++len;
            UUID id = uuidIterator.next();
            GameProfile profile = server.func_152358_ax().func_152652_a(id);
            if (profile == null) continue;
            sender.func_197030_a((ITextComponent)new StringTextComponent(profile.getName()), false);
        }
        return len;
    }

    private static int teamPlayer(MinecraftServer server, CommandSource sender, String playerName) {
        SaveData.get(server.func_71218_a(DimensionType.field_223227_a_));
        if (SaveData.teamMap.containsKey(server.func_152358_ax().func_152655_a(playerName).getId())) {
            String playerTeam = SaveData.teamMap.get(server.func_152358_ax().func_152655_a(playerName).getId());
            sender.func_197030_a((ITextComponent)new StringTextComponent(playerName + " is in the following team:"), false);
            sender.func_197030_a((ITextComponent)new StringTextComponent(playerTeam), false);
            return 2;
        }
        sender.func_197030_a((ITextComponent)new StringTextComponent(playerName + " is not in a team"), false);
        return 1;
    }

    private static int teamInvite(MinecraftServer server, CommandSource sender, String playerName) throws CommandSyntaxException {
        SaveData.get(server.func_71218_a(DimensionType.field_223227_a_));
        ServerPlayerEntity newPlayer = ServerLifecycleHooks.getCurrentServer().func_184103_al().func_152612_a(playerName);
        ServerPlayerEntity oldPlayer = sender.func_197035_h();
        if (SaveData.teamMap.containsKey(oldPlayer.func_110124_au())) {
            String teamName = SaveData.teamMap.get(oldPlayer.func_110124_au());
            if (SaveData.teamsMap.get(teamName).contains(newPlayer.func_110124_au())) {
                throw new CommandException((ITextComponent)new StringTextComponent("That player is already on your team!"));
            }
            newPlayer.getPersistentData().func_74778_a("invitedby", oldPlayer.func_189512_bd());
            oldPlayer.func_145747_a((ITextComponent)new StringTextComponent("You have invited: " + newPlayer.func_146103_bH().getName() + " to your team"));
            PacketHandler.INSTANCE.send(PacketDistributor.PLAYER.with(() -> newPlayer), (Object)new MessageInvite(teamName));
            newPlayer.func_145747_a((ITextComponent)new StringTextComponent("You have been invited to join the team: " + teamName + ". Type /teamsmod accept to accept"));
            return 1;
        }
        throw new CommandException((ITextComponent)new StringTextComponent("Failed to Invite : Either the player is invalid or you are not in a team!"));
    }

    private static int teamAccept(MinecraftServer server, CommandSource sender) throws CommandSyntaxException {
        SaveData data = SaveData.get(server.func_71218_a(DimensionType.field_223227_a_));
        ServerPlayerEntity invitee = sender.func_197035_h();
        ServerPlayerEntity inviter = server.func_184103_al().func_177451_a(UUID.fromString(invitee.getPersistentData().func_74779_i("invitedby")));
        UUID uid = invitee.func_110124_au();
        int len = 1;
        if (inviter == null) {
            throw new CommandException((ITextComponent)new StringTextComponent("You have not been invited to a team"));
        }
        if (SaveData.teamMap.containsKey(uid)) {
            sender.func_197030_a((ITextComponent)new StringTextComponent("Removing you from your old team..."), false);
            ++len;
            data.removePlayer((PlayerEntity)invitee, uid);
        }
        data.addPlayer((PlayerEntity)inviter, uid);
        if (SaveData.teamMap.containsKey(inviter.func_110124_au()) && !TeamConfig.disableAchievementSync) {
            String name = SaveData.teamMap.get(inviter.func_110124_au());
            Iterator<UUID> uuidIterator = SaveData.teamsMap.get(name).iterator();
            while (uuidIterator.hasNext()) {
                ServerPlayerEntity playerMP = server.func_184103_al().func_177451_a(uuidIterator.next());
                if (playerMP == null) continue;
                SaveData.syncPlayers(name, playerMP);
            }
        }
        PacketHandler.INSTANCE.send(PacketDistributor.ALL.noArg(), (Object)new MessageSaveData(SaveData.teamsMap));
        sender.func_197030_a((ITextComponent)new StringTextComponent("Joined " + inviter.func_146103_bH().getName() + "'s team"), false);
        inviter.func_145747_a((ITextComponent)new StringTextComponent(invitee.func_146103_bH().getName() + " has joined your team!"));
        return len;
    }

    private static int teamKick(MinecraftServer server, CommandSource sender, String playerName) throws CommandSyntaxException {
        SaveData data = SaveData.get(server.func_71218_a(DimensionType.field_223227_a_));
        UUID uid = server.func_152358_ax().func_152655_a(playerName).getId();
        if (SaveData.teamMap.containsKey(uid)) {
            sender.func_197030_a((ITextComponent)new StringTextComponent("Removing that player from your team!"), false);
            String toLeave = SaveData.teamMap.get(uid);
            data.removePlayer((PlayerEntity)sender.func_197035_h(), uid);
            server.func_184103_al().func_177451_a(uid).func_145747_a((ITextComponent)new StringTextComponent("You have been kicked from your team"));
            if (SaveData.teamsMap.get(toLeave).isEmpty()) {
                data.removeTeam(toLeave);
            }
        } else {
            throw new CommandException((ITextComponent)new StringTextComponent("Must enter player name on your team"));
        }
        PacketHandler.INSTANCE.send(PacketDistributor.ALL.noArg(), (Object)new MessageSaveData(SaveData.teamsMap));
        return 1;
    }

    private static int teamLeave(MinecraftServer server, CommandSource sender) throws CommandSyntaxException {
        SaveData data = SaveData.get(server.func_71218_a(DimensionType.field_223227_a_));
        ServerPlayerEntity p = sender.func_197035_h();
        if (!SaveData.teamMap.containsKey(p.func_110124_au())) {
            throw new CommandException((ITextComponent)new StringTextComponent("You're not in a team"));
        }
        String toLeave = SaveData.teamMap.get(p.func_110124_au());
        data.removePlayer((PlayerEntity)p, p.func_110124_au());
        p.func_145747_a((ITextComponent)new StringTextComponent("You left your team"));
        if (SaveData.teamsMap.get(toLeave).isEmpty()) {
            data.removeTeam(toLeave);
        }
        PacketHandler.INSTANCE.send(PacketDistributor.ALL.noArg(), (Object)new MessageSaveData(SaveData.teamsMap));
        return 1;
    }

    private static int teamRemove(MinecraftServer server, CommandSource sender, String teamName) throws CommandSyntaxException {
        SaveData data = SaveData.get(server.func_71218_a(DimensionType.field_223227_a_));
        if (TeamConfig.noOpRemoveTeam || server.func_71264_H() || sender.func_197035_h().func_211513_k(server.func_110455_j())) {
            if (!SaveData.teamsMap.containsKey(teamName)) {
                throw new CommandException((ITextComponent)new StringTextComponent("The team \"" + teamName + "\" doesn't exist"));
            }
            sender.func_197030_a((ITextComponent)new StringTextComponent("The team \"" + teamName + "\" has been removed"), false);
            data.removeTeam(teamName);
            PacketHandler.INSTANCE.send(PacketDistributor.ALL.noArg(), (Object)new MessageSaveData(SaveData.teamsMap));
            return 1;
        }
        throw new CommandException((ITextComponent)new StringTextComponent("You do not have permission to use this command"));
    }

    private static class TeamCompletionProvider {
        public static final SuggestionProvider<CommandSource> TEAMS = SuggestionProviders.func_197494_a((ResourceLocation)new ResourceLocation("teams"), (ctx, builder) -> {
            Set<String> teamSet = SaveData.teamsMap.keySet();
            if (teamSet.isEmpty()) {
                return Suggestions.empty();
            }
            for (String team : teamSet) {
                builder.suggest(team);
            }
            return builder.buildFuture();
        });

        private TeamCompletionProvider() {
        }
    }
}

