/*
 * Decompiled with CFR 0.152.
 */
package com.daposeidonguy.teamsmod.common.config;

import net.minecraftforge.common.ForgeConfigSpec;

public class TeamConfig {
    public static boolean disablePing;
    public static boolean disablePrefix;
    public static boolean smallIcon;
    public static boolean useAlternatePosition;
    public static boolean disableChatBubble;
    public static boolean disableTeamsHUD;
    public static boolean enableFriendlyFire;
    public static boolean disableAchievementSync;
    public static boolean noOpRemoveTeam;
    public static boolean disableInventoryTransfer;
    public static boolean prefixServerSide;
    public static boolean disablePrefixServer;

    public static class ServerConfig {
        final ForgeConfigSpec.BooleanValue enableFriendlyFire;
        final ForgeConfigSpec.BooleanValue disableAchievementSync;
        final ForgeConfigSpec.BooleanValue noOpRemoveTeam;
        final ForgeConfigSpec.BooleanValue disableInventoryTransfer;
        final ForgeConfigSpec.BooleanValue prefixServerSide;
        final ForgeConfigSpec.BooleanValue disablePrefix;

        ServerConfig(ForgeConfigSpec.Builder builder) {
            builder.push("Team");
            this.enableFriendlyFire = builder.comment("Enable damaging teammates").define("enableFriendlyFire", false);
            this.disableAchievementSync = builder.comment("Disable synchronized achievements").define("disableAchievementSync", false);
            this.noOpRemoveTeam = builder.comment("Allow non-operators to delete teams").define("noOpRemoveTeam", false);
            this.disableInventoryTransfer = builder.comment("Disable the inventory transfer feature").define("disableInventoryTransfer", false);
            builder.pop();
            builder.push("Chat");
            this.prefixServerSide = builder.comment("Makes chat features handled serverside. Used if they don't work otherwise due to crossmod/plugin incompatibility").define("prefixServerSide", false);
            this.disablePrefix = builder.comment("Disable chat prefixes. Only applies if chatServerside = true").define("disablePrefix", false);
            builder.pop();
        }
    }

    public static class ClientConfig {
        final ForgeConfigSpec.BooleanValue disablePing;
        final ForgeConfigSpec.BooleanValue disablePrefix;
        final ForgeConfigSpec.BooleanValue smallIcon;
        final ForgeConfigSpec.BooleanValue useAlternatePosition;
        final ForgeConfigSpec.BooleanValue disableChatBubble;
        final ForgeConfigSpec.BooleanValue disableTeamsHUD;

        ClientConfig(ForgeConfigSpec.Builder builder) {
            builder.push("Gui");
            this.smallIcon = builder.comment("Use smaller button to open teams GUI").define("smallIcon", false);
            this.useAlternatePosition = builder.comment("Use alternate position for teams GUI button").define("useAlternatePosition", false);
            this.disableTeamsHUD = builder.comment("Disable HUD display showing teammate health and hunger").define("disableTeamsHUD", false);
            builder.pop();
            builder.push("Chat");
            this.disablePing = builder.comment("Disable bold text and ping sound when your storage or playername is typed in chat").define("disablePing", false);
            this.disablePrefix = builder.comment("Disable storage names as chat prefixes").define("disablePrefix", false);
            this.disableChatBubble = builder.comment("Disable chat bubbles above player heads").define("disableChatBubble", false);
            builder.pop();
        }
    }
}

