/*
 * Decompiled with CFR 0.152.
 */
package com.daposeidonguy.teamsmod.common.network;

import com.daposeidonguy.teamsmod.client.ClientEventHandler;
import com.daposeidonguy.teamsmod.common.storage.SaveData;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.UUID;
import java.util.function.Supplier;
import net.minecraft.client.Minecraft;
import net.minecraft.client.network.play.NetworkPlayerInfo;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.nbt.INBT;
import net.minecraft.nbt.ListNBT;
import net.minecraft.network.PacketBuffer;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.fml.DistExecutor;
import net.minecraftforge.fml.network.NetworkEvent;

public class MessageSaveData {
    private CompoundNBT tagTeam = new CompoundNBT();

    public MessageSaveData() {
    }

    public MessageSaveData(Map<String, List<UUID>> teamsMap) {
        ListNBT tagList = new ListNBT();
        Iterator<String> iteratorTeams = teamsMap.keySet().iterator();
        while (iteratorTeams.hasNext()) {
            CompoundNBT tagCompound = new CompoundNBT();
            String team = iteratorTeams.next();
            tagCompound.func_74778_a("Team Name", team);
            ListNBT playerListTag = new ListNBT();
            for (UUID id : teamsMap.get(team)) {
                CompoundNBT playerTag = new CompoundNBT();
                playerTag.func_74778_a("uuid", id.toString());
                playerListTag.add((Object)playerTag);
            }
            tagCompound.func_218657_a("Player List", (INBT)playerListTag);
            tagList.add((Object)tagCompound);
        }
        this.tagTeam.func_218657_a("Teams", (INBT)tagList);
    }

    public MessageSaveData(PacketBuffer buf) {
        this.tagTeam = buf.func_150793_b();
    }

    public void encode(PacketBuffer buf) {
        buf.func_150786_a(this.tagTeam);
    }

    public void onMessage(Supplier<NetworkEvent.Context> ctx) {
        ctx.get().enqueueWork(() -> DistExecutor.runWhenOn((Dist)Dist.CLIENT, () -> () -> {
            SaveData.teamsMap.clear();
            SaveData.teamMap.clear();
            String teamName = "";
            for (CompoundNBT tagCompound : this.tagTeam.func_150295_c("Teams", 10)) {
                Iterator playerTagListIterator = tagCompound.func_150295_c("Player List", 10).iterator();
                ArrayList<UUID> uuidList = new ArrayList<UUID>();
                while (playerTagListIterator.hasNext()) {
                    CompoundNBT playerTag = (CompoundNBT)playerTagListIterator.next();
                    UUID id = UUID.fromString(playerTag.func_74779_i("uuid"));
                    teamName = tagCompound.func_74779_i("Team Name");
                    NetworkPlayerInfo playerInfo = Minecraft.func_71410_x().func_147114_u().func_175102_a(id);
                    if (playerInfo != null) {
                        String playerName = playerInfo.func_178845_a().getName();
                        ClientEventHandler.idtoNameMap.put(id, playerName);
                        ClientEventHandler.nametoIdMap.put(playerName, id);
                    }
                    SaveData.teamMap.put(id, teamName);
                    uuidList.add(id);
                }
                SaveData.teamsMap.put(teamName, uuidList);
            }
        }));
        ctx.get().setPacketHandled(true);
    }
}

