/*
 * Decompiled with CFR 0.152.
 */
package com.daposeidonguy.teamsmod.common.storage;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.UUID;
import net.minecraft.advancements.Advancement;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.entity.player.ServerPlayerEntity;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.nbt.INBT;
import net.minecraft.nbt.ListNBT;
import net.minecraft.world.server.ServerWorld;
import net.minecraft.world.storage.DimensionSavedDataManager;
import net.minecraft.world.storage.WorldSavedData;
import net.minecraftforge.fml.common.thread.EffectiveSide;
import net.minecraftforge.fml.server.ServerLifecycleHooks;

public class SaveData
extends WorldSavedData {
    public static final String NAME = "teamsmod";
    public static Map<UUID, String> teamMap = new HashMap<UUID, String>();
    public static Map<String, List<UUID>> teamsMap = new HashMap<String, List<UUID>>();

    public SaveData() {
        super(NAME);
    }

    public SaveData(String name) {
        super(name);
        this.func_76185_a();
    }

    public static SaveData get(ServerWorld world) {
        DimensionSavedDataManager storage = world.func_217481_x();
        SaveData data = (SaveData)storage.func_215752_a(() -> new SaveData(), NAME);
        if (data == null) {
            data = new SaveData();
            storage.func_215757_a((WorldSavedData)data);
        }
        return data;
    }

    public static void syncPlayers(String team, ServerPlayerEntity player) {
        if (EffectiveSide.get().isServer() && player != null) {
            for (Advancement adv : ServerLifecycleHooks.getCurrentServer().func_191949_aK().func_195438_b()) {
                for (UUID id : teamsMap.get(team)) {
                    ServerPlayerEntity teammate = ServerLifecycleHooks.getCurrentServer().func_184103_al().func_177451_a(id);
                    if (teammate == null) continue;
                    if (teammate.func_192039_O().func_192747_a(adv).func_192105_a()) {
                        for (String s : teammate.func_192039_O().func_192747_a(adv).func_192102_e()) {
                            player.func_192039_O().func_192750_a(adv, s);
                        }
                        continue;
                    }
                    if (!player.func_192039_O().func_192747_a(adv).func_192105_a()) continue;
                    for (String s : player.func_192039_O().func_192747_a(adv).func_192102_e()) {
                        teammate.func_192039_O().func_192750_a(adv, s);
                    }
                }
            }
        }
    }

    public void addTeam(String name, PlayerEntity player) {
        ArrayList<UUID> tempList = new ArrayList<UUID>();
        tempList.add(player.func_110124_au());
        teamsMap.put(name, tempList);
        teamMap.put(player.func_110124_au(), name);
        this.func_76185_a();
    }

    public void addPlayer(PlayerEntity p, UUID uid) {
        String name = teamMap.get(p.func_110124_au());
        teamsMap.get(name).add(uid);
        teamMap.put(uid, name);
        this.func_76185_a();
    }

    public void removePlayer(PlayerEntity p, UUID uid) {
        String name = teamMap.get(p.func_110124_au());
        teamsMap.get(name).remove(uid);
        teamMap.remove(uid);
        this.func_76185_a();
    }

    public void removeTeam(String name) {
        for (UUID id : teamsMap.get(name)) {
            teamMap.remove(id);
        }
        teamsMap.remove(name);
        this.func_76185_a();
    }

    public void func_76184_a(CompoundNBT nbt) {
        teamsMap.clear();
        teamMap.clear();
        String name = "";
        for (CompoundNBT tagCompound : nbt.func_150295_c("Teams", 10)) {
            Iterator playerTagListIterator = tagCompound.func_150295_c("Player List", 10).iterator();
            ArrayList<UUID> uuidList = new ArrayList<UUID>();
            while (playerTagListIterator.hasNext()) {
                CompoundNBT playerTag = (CompoundNBT)playerTagListIterator.next();
                UUID id = UUID.fromString(playerTag.func_74779_i("uuid"));
                name = tagCompound.func_74779_i("Team Name");
                teamMap.put(id, name);
                uuidList.add(id);
            }
            teamsMap.put(name, uuidList);
        }
    }

    public CompoundNBT func_189551_b(CompoundNBT compound) {
        ListNBT tagList = new ListNBT();
        Iterator<String> iteratorTeams = teamsMap.keySet().iterator();
        while (iteratorTeams.hasNext()) {
            CompoundNBT tagCompound = new CompoundNBT();
            String team = iteratorTeams.next();
            tagCompound.func_74778_a("Team Name", team);
            ListNBT playerListTag = new ListNBT();
            for (UUID id : teamsMap.get(team)) {
                CompoundNBT playerTag = new CompoundNBT();
                playerTag.func_74778_a("uuid", id.toString());
                playerListTag.add((Object)playerTag);
            }
            tagCompound.func_218657_a("Player List", (INBT)playerListTag);
            tagList.add((Object)tagCompound);
        }
        compound.func_218657_a("Teams", (INBT)tagList);
        return compound;
    }
}

