/*
 * Decompiled with CFR 0.152.
 */
package se.mickelus.tetra.advancements;

import com.google.common.cache.Cache;
import com.google.common.cache.CacheBuilder;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import java.util.UUID;
import java.util.concurrent.TimeUnit;
import net.minecraft.advancements.critereon.AbstractCriterionInstance;
import net.minecraft.block.state.IBlockState;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraft.util.math.RayTraceResult;
import net.minecraftforge.common.ForgeHooks;
import net.minecraftforge.fml.common.eventhandler.EventPriority;
import net.minecraftforge.fml.common.eventhandler.SubscribeEvent;
import net.minecraftforge.fml.common.gameevent.TickEvent;
import se.mickelus.tetra.advancements.GenericTrigger;
import se.mickelus.tetra.blocks.PropertyMatcher;
import se.mickelus.tetra.data.DataHandler;

public class BlockLookTrigger
extends GenericTrigger<Instance> {
    private Cache<UUID, IBlockState> stateCache = CacheBuilder.newBuilder().maximumSize(100L).expireAfterWrite(1L, TimeUnit.MINUTES).build();
    public static final BlockLookTrigger instance = new BlockLookTrigger();

    public BlockLookTrigger() {
        super("tetra:block_look", BlockLookTrigger::deserialize);
    }

    @SubscribeEvent(priority=EventPriority.LOW)
    public void onPlayerTick(TickEvent.PlayerTickEvent event) {
        if (event.player.field_70173_aa % 20 == 0 && !event.player.field_70170_p.field_72995_K) {
            event.player.field_70170_p.field_72984_F.func_76320_a("lookTrigger");
            RayTraceResult result = ForgeHooks.rayTraceEyes((EntityLivingBase)event.player, (double)event.player.func_110148_a(EntityPlayer.REACH_DISTANCE).func_111126_e());
            if (result != null && RayTraceResult.Type.BLOCK.equals((Object)result.field_72313_a)) {
                IBlockState currentState = event.player.field_70170_p.func_180495_p(result.func_178782_a());
                if (!currentState.equals(this.stateCache.getIfPresent((Object)event.player.func_110124_au()))) {
                    this.trigger((EntityPlayerMP)event.player, currentState);
                    this.stateCache.put((Object)event.player.func_110124_au(), (Object)currentState);
                }
            } else {
                this.stateCache.invalidate((Object)event.player.func_110124_au());
            }
            event.player.field_70170_p.field_72984_F.func_76319_b();
        }
    }

    public static Instance deserialize(JsonObject json) {
        return (Instance)((Object)DataHandler.instance.gson.fromJson((JsonElement)json, Instance.class));
    }

    public void trigger(EntityPlayerMP player, IBlockState state) {
        this.fulfillCriterion(player.func_192039_O(), instance -> instance.test(state));
    }

    public static class Instance
    extends AbstractCriterionInstance {
        private PropertyMatcher block = null;

        public Instance() {
            super(instance.func_192163_a());
        }

        public boolean test(IBlockState state) {
            return this.block != null && this.block.test(state);
        }
    }
}

