/*
 * Decompiled with CFR 0.152.
 */
package se.mickelus.tetra.blocks;

import java.util.Collection;
import java.util.Collections;
import net.minecraft.block.Block;
import net.minecraft.block.state.IBlockState;
import net.minecraft.client.renderer.block.model.ModelResourceLocation;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.Item;
import net.minecraft.item.ItemBlock;
import net.minecraft.item.ItemStack;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.World;
import net.minecraftforge.client.model.ModelLoader;
import net.minecraftforge.fml.common.FMLCommonHandler;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.registries.IForgeRegistry;
import net.minecraftforge.registries.IForgeRegistryEntry;
import se.mickelus.tetra.capabilities.Capability;
import se.mickelus.tetra.network.PacketHandler;

public interface ITetraBlock {
    default public void clientPreInit() {
    }

    default public void init(PacketHandler packetHandler) {
    }

    public boolean hasItem();

    public void registerItem(IForgeRegistry<Item> var1);

    default public void registerItem(IForgeRegistry<Item> registry, Block block) {
        Item item = (Item)new ItemBlock(block).setRegistryName(block.getRegistryName());
        registry.register((IForgeRegistryEntry)item);
        if (FMLCommonHandler.instance().getEffectiveSide() == Side.CLIENT) {
            ModelLoader.setCustomModelResourceLocation((Item)item, (int)0, (ModelResourceLocation)new ModelResourceLocation(block.getRegistryName(), "inventory"));
        }
    }

    default public Collection<Capability> getCapabilities(World world, BlockPos pos, IBlockState blockState) {
        return Collections.emptyList();
    }

    default public int getCapabilityLevel(World world, BlockPos pos, IBlockState blockState, Capability capability) {
        return -1;
    }

    default public ItemStack onCraftConsumeCapability(World world, BlockPos pos, IBlockState blockState, ItemStack targetStack, EntityPlayer player, boolean consumeResources) {
        return targetStack;
    }

    default public ItemStack onActionConsumeCapability(World world, BlockPos pos, IBlockState blockState, ItemStack targetStack, EntityPlayer player, boolean consumeResources) {
        return targetStack;
    }
}

