/*
 * Decompiled with CFR 0.152.
 */
package se.mickelus.tetra.blocks;

import com.google.common.base.Optional;
import com.google.common.base.Predicates;
import com.google.common.collect.Maps;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonSyntaxException;
import java.util.Map;
import java.util.function.Predicate;
import net.minecraft.block.Block;
import net.minecraft.block.properties.IProperty;
import net.minecraft.block.state.BlockStateContainer;
import net.minecraft.block.state.IBlockState;
import net.minecraft.util.JsonUtils;
import net.minecraft.util.ResourceLocation;

public class PropertyMatcher
implements Predicate<IBlockState> {
    private Block block = null;
    private final Map<IProperty<?>, Predicate<?>> propertyPredicates = Maps.newHashMap();

    @Override
    public boolean test(IBlockState blockState) {
        if (this.block != null && this.block != blockState.func_177230_c()) {
            return false;
        }
        for (Map.Entry<IProperty<?>, Predicate<?>> entry : this.propertyPredicates.entrySet()) {
            if (this.matches(blockState, entry.getKey(), entry.getValue())) continue;
            return false;
        }
        return true;
    }

    protected <T extends Comparable<T>> boolean matches(IBlockState blockState, IProperty<T> property, Predicate<T> predicate) {
        return predicate.test(blockState.func_177229_b(property));
    }

    public <V extends Comparable<V>> PropertyMatcher where(IProperty<V> property, Predicate<? extends V> is) {
        this.propertyPredicates.put(property, is);
        return this;
    }

    public static PropertyMatcher deserialize(JsonElement json) {
        PropertyMatcher result = new PropertyMatcher();
        if (json.isJsonObject()) {
            ResourceLocation resourceLocation;
            String blockString;
            JsonObject jsonObject = JsonUtils.func_151210_l((JsonElement)json, (String)"propertyMatcher");
            if (jsonObject.has("block") && (blockString = jsonObject.get("block").getAsString()) != null && Block.field_149771_c.func_148741_d((Object)(resourceLocation = new ResourceLocation(blockString)))) {
                result.block = (Block)Block.field_149771_c.func_82594_a((Object)resourceLocation);
            }
            if (result.block != null && jsonObject.has("state")) {
                BlockStateContainer stateContainer = result.block.func_176194_O();
                for (Map.Entry entry : jsonObject.get("state").getAsJsonObject().entrySet()) {
                    IProperty property = stateContainer.func_185920_a((String)entry.getKey());
                    if (property == null) {
                        throw new JsonSyntaxException("Unknown block state property '" + (String)entry.getKey() + "' for block '" + result.block.func_149739_a() + "'");
                    }
                    String s = JsonUtils.func_151206_a((JsonElement)((JsonElement)entry.getValue()), (String)((String)entry.getKey()));
                    Optional optional = property.func_185929_b(s);
                    if (!optional.isPresent()) {
                        throw new JsonSyntaxException("Invalid block state value '" + s + "' for property '" + (String)entry.getKey() + "' on block '" + result.block.func_149739_a() + "'");
                    }
                    result.propertyPredicates.put((IProperty<?>)property, (Predicate<?>)Predicates.equalTo((Object)optional.get()));
                }
            }
        } else {
            ResourceLocation resourceLocation;
            String blockString = json.getAsString();
            if (blockString != null && Block.field_149771_c.func_148741_d((Object)(resourceLocation = new ResourceLocation(blockString)))) {
                result.block = (Block)Block.field_149771_c.func_82594_a((Object)resourceLocation);
            }
        }
        return result;
    }
}

