/*
 * Decompiled with CFR 0.152.
 */
package se.mickelus.tetra.blocks.forged;

import com.google.common.base.Predicates;
import com.mojang.realmsclient.gui.ChatFormatting;
import java.util.Arrays;
import java.util.Collection;
import java.util.LinkedList;
import java.util.List;
import javax.annotation.Nullable;
import net.minecraft.block.Block;
import net.minecraft.block.properties.IProperty;
import net.minecraft.block.properties.PropertyBool;
import net.minecraft.block.properties.PropertyInteger;
import net.minecraft.block.state.BlockFaceShape;
import net.minecraft.block.state.BlockStateContainer;
import net.minecraft.block.state.IBlockState;
import net.minecraft.client.resources.I18n;
import net.minecraft.client.util.ITooltipFlag;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.init.Blocks;
import net.minecraft.init.SoundEvents;
import net.minecraft.item.ItemStack;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.EnumHand;
import net.minecraft.util.NonNullList;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.Rotation;
import net.minecraft.util.SoundCategory;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;
import net.minecraft.world.WorldServer;
import net.minecraft.world.storage.loot.LootContext;
import net.minecraft.world.storage.loot.LootTable;
import net.minecraftforge.fml.common.registry.GameRegistry;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;
import se.mickelus.tetra.blocks.Materials;
import se.mickelus.tetra.blocks.PropertyMatcher;
import se.mickelus.tetra.blocks.TetraBlock;
import se.mickelus.tetra.blocks.salvage.BlockInteraction;
import se.mickelus.tetra.blocks.salvage.IBlockCapabilityInteractive;
import se.mickelus.tetra.capabilities.Capability;
import se.mickelus.tetra.items.TetraCreativeTabs;

public class BlockForgedVent
extends TetraBlock
implements IBlockCapabilityInteractive {
    static final String unlocalizedName = "forged_vent";
    @GameRegistry.ObjectHolder(value="tetra:forged_vent")
    public static BlockForgedVent instance;
    public static final PropertyInteger propRotation;
    public static final PropertyBool propX;
    public static final PropertyBool propBroken;
    public static final BlockInteraction[] interactions;
    private static final ResourceLocation boltLootTable;
    private static final ResourceLocation ventLootTable;

    public BlockForgedVent() {
        super(Materials.forged);
        this.setRegistryName(unlocalizedName);
        this.func_149663_c(unlocalizedName);
        this.func_149647_a(TetraCreativeTabs.getInstance());
        this.func_149722_s();
        this.func_149752_b(22.0f);
        this.hasItem = true;
        this.func_180632_j(this.field_176227_L.func_177621_b().func_177226_a((IProperty)propRotation, (Comparable)Integer.valueOf(0)).func_177226_a((IProperty)propX, (Comparable)Boolean.valueOf(true)).func_177226_a((IProperty)propBroken, (Comparable)Boolean.valueOf(false)));
    }

    public void getDrops(NonNullList<ItemStack> drops, IBlockAccess world, BlockPos pos, IBlockState state, int fortune) {
        drops.clear();
    }

    private static boolean breakBolt(World world, BlockPos pos, IBlockState blockState, EntityPlayer player, EnumHand hand, EnumFacing facing) {
        world.func_180501_a(pos, world.func_180495_p(pos).func_177226_a((IProperty)propBroken, (Comparable)Boolean.valueOf(true)), 2);
        if (!world.field_72995_K) {
            WorldServer worldServer = (WorldServer)world;
            LootTable table = worldServer.func_184146_ak().func_186521_a(boltLootTable);
            LootContext.Builder builder = new LootContext.Builder(worldServer);
            builder.func_186469_a(player.func_184817_da()).func_186470_a(player);
            table.func_186462_a(player.func_70681_au(), builder.func_186471_a()).forEach(itemStack -> {
                if (!player.field_71071_by.func_70441_a(itemStack)) {
                    player.func_71019_a(itemStack, false);
                }
            });
            worldServer.func_184133_a(null, pos, SoundEvents.field_187928_hb, SoundCategory.PLAYERS, 1.0f, 0.5f);
        }
        return true;
    }

    private static boolean breakPlate(World world, BlockPos pos, IBlockState blockState, EntityPlayer player, EnumHand hand, EnumFacing facing) {
        List<BlockPos> connectedVents = BlockForgedVent.getConnectedBlocks((IBlockAccess)world, pos, new LinkedList<BlockPos>(), (Boolean)blockState.func_177229_b((IProperty)propX));
        if (connectedVents.stream().anyMatch(blockPos -> (Boolean)world.func_180495_p(blockPos).func_177229_b((IProperty)propBroken) == false)) {
            return false;
        }
        connectedVents.forEach(blockPos -> {
            world.func_180498_a(null, 2001, blockPos, Block.func_176210_f((IBlockState)world.func_180495_p(blockPos)));
            world.func_180501_a(blockPos, Blocks.field_150350_a.func_176223_P(), 2);
        });
        if (!world.field_72995_K) {
            WorldServer worldServer = (WorldServer)world;
            LootTable table = worldServer.func_184146_ak().func_186521_a(ventLootTable);
            LootContext.Builder builder = new LootContext.Builder(worldServer);
            builder.func_186469_a(player.func_184817_da()).func_186470_a(player);
            table.func_186462_a(player.func_70681_au(), builder.func_186471_a()).forEach(itemStack -> BlockForgedVent.func_180635_a((World)worldServer, (BlockPos)pos, (ItemStack)itemStack));
        }
        return true;
    }

    private static List<BlockPos> getConnectedBlocks(IBlockAccess world, BlockPos pos, List<BlockPos> visited, boolean isXAxis) {
        if (!visited.contains(pos) && world.func_180495_p(pos).func_177230_c() instanceof BlockForgedVent) {
            visited.add(pos);
            BlockForgedVent.getConnectedBlocks(world, pos.func_177984_a(), visited, isXAxis);
            BlockForgedVent.getConnectedBlocks(world, pos.func_177977_b(), visited, isXAxis);
            if (isXAxis) {
                BlockForgedVent.getConnectedBlocks(world, pos.func_177974_f(), visited, isXAxis);
                BlockForgedVent.getConnectedBlocks(world, pos.func_177976_e(), visited, isXAxis);
            } else {
                BlockForgedVent.getConnectedBlocks(world, pos.func_177978_c(), visited, isXAxis);
                BlockForgedVent.getConnectedBlocks(world, pos.func_177968_d(), visited, isXAxis);
            }
        }
        return visited;
    }

    @Override
    public BlockInteraction[] getPotentialInteractions(IBlockState state, EnumFacing face, Collection<Capability> capabilities) {
        return (BlockInteraction[])Arrays.stream(interactions).filter(interaction -> interaction.isPotentialInteraction(state, (Boolean)state.func_177229_b((IProperty)propX) != false ? EnumFacing.EAST : EnumFacing.SOUTH, face, capabilities)).toArray(BlockInteraction[]::new);
    }

    public boolean func_180639_a(World world, BlockPos pos, IBlockState state, EntityPlayer player, EnumHand hand, EnumFacing facing, float hitX, float hitY, float hitZ) {
        return BlockInteraction.attemptInteraction(world, state.func_185899_b((IBlockAccess)world, pos), pos, player, hand, facing, hitX, hitY, hitZ);
    }

    @SideOnly(value=Side.CLIENT)
    public void func_190948_a(ItemStack stack, @Nullable World player, List<String> tooltip, ITooltipFlag advanced) {
        tooltip.add(ChatFormatting.DARK_GRAY + I18n.func_135052_a((String)"forged_description", (Object[])new Object[0]));
    }

    protected BlockStateContainer func_180661_e() {
        return new BlockStateContainer((Block)this, new IProperty[]{propRotation, propX, propBroken});
    }

    public IBlockState func_180642_a(World worldIn, BlockPos pos, EnumFacing facing, float hitX, float hitY, float hitZ, int meta, EntityLivingBase placer) {
        IBlockState iblockstate = super.func_180642_a(worldIn, pos, facing, hitX, hitY, hitZ, meta, placer);
        iblockstate = iblockstate.func_177226_a((IProperty)propX, (Comparable)Boolean.valueOf(EnumFacing.Axis.X.equals((Object)placer.func_174811_aO().func_176740_k())));
        int rotation = 0;
        if (EnumFacing.EAST.equals((Object)placer.func_174811_aO()) || EnumFacing.SOUTH.equals((Object)placer.func_174811_aO())) {
            rotation = 2;
        }
        if (facing != EnumFacing.UP && (facing == EnumFacing.DOWN || (double)hitY > 0.5)) {
            ++rotation;
        }
        iblockstate = iblockstate.func_177226_a((IProperty)propRotation, (Comparable)Integer.valueOf(rotation));
        return iblockstate;
    }

    public IBlockState func_176203_a(int meta) {
        IBlockState blockState = this.func_176223_P();
        int rotation = meta & 3;
        if (rotation < EnumFacing.field_176754_o.length) {
            blockState = blockState.func_177226_a((IProperty)propRotation, (Comparable)Integer.valueOf(rotation));
        }
        return blockState.func_177226_a((IProperty)propX, (Comparable)Boolean.valueOf((meta >> 2 & 1) == 1)).func_177226_a((IProperty)propBroken, (Comparable)Boolean.valueOf(meta >> 3 == 1));
    }

    public int func_176201_c(IBlockState state) {
        return (Integer)state.func_177229_b((IProperty)propRotation) | ((Boolean)state.func_177229_b((IProperty)propX) != false ? 4 : 0) | ((Boolean)state.func_177229_b((IProperty)propBroken) != false ? 8 : 0);
    }

    public IBlockState func_185499_a(IBlockState state, Rotation rot) {
        boolean isXAxis = (Boolean)state.func_177229_b((IProperty)propX);
        if (rot.equals((Object)Rotation.CLOCKWISE_90) || rot.equals((Object)Rotation.COUNTERCLOCKWISE_90)) {
            state = state.func_177226_a((IProperty)propX, (Comparable)Boolean.valueOf(!isXAxis));
        }
        if (rot.equals((Object)Rotation.CLOCKWISE_180) || !isXAxis && rot.equals((Object)Rotation.CLOCKWISE_90) || isXAxis && rot.equals((Object)Rotation.COUNTERCLOCKWISE_90)) {
            return state.func_177226_a((IProperty)propRotation, (Comparable)Integer.valueOf((Integer)state.func_177229_b((IProperty)propRotation) ^ 2));
        }
        return state.func_177226_a((IProperty)propRotation, state.func_177229_b((IProperty)propRotation));
    }

    public boolean func_149686_d(IBlockState state) {
        return false;
    }

    public boolean func_176214_u(IBlockState state) {
        return false;
    }

    public BlockFaceShape func_193383_a(IBlockAccess worldIn, IBlockState state, BlockPos pos, EnumFacing face) {
        return BlockFaceShape.UNDEFINED;
    }

    public boolean func_149662_c(IBlockState state) {
        return false;
    }

    public AxisAlignedBB func_185496_a(IBlockState state, IBlockAccess source, BlockPos pos) {
        if (((Boolean)state.func_177229_b((IProperty)propX)).booleanValue()) {
            return new AxisAlignedBB(0.0, 0.0, 0.4375, 1.0, 1.0, 0.5625);
        }
        return new AxisAlignedBB(0.4375, 0.0, 0.0, 0.5625, 1.0, 1.0);
    }

    public int getLightOpacity(IBlockState state, IBlockAccess world, BlockPos pos) {
        return 0;
    }

    static {
        propRotation = PropertyInteger.func_177719_a((String)"rotation", (int)0, (int)3);
        propX = PropertyBool.func_177716_a((String)"x");
        propBroken = PropertyBool.func_177716_a((String)"broken");
        interactions = new BlockInteraction[]{new BlockInteraction(Capability.hammer, 3, EnumFacing.EAST, 1.0f, 4.0f, 12.0f, 15.0f, new PropertyMatcher().where(propBroken, Predicates.equalTo((Object)false)).where(propRotation, Predicates.equalTo((Object)0)), BlockForgedVent::breakBolt), new BlockInteraction(Capability.hammer, 3, EnumFacing.EAST, 1.0f, 4.0f, 1.0f, 4.0f, new PropertyMatcher().where(propBroken, Predicates.equalTo((Object)false)).where(propRotation, Predicates.equalTo((Object)1)), BlockForgedVent::breakBolt), new BlockInteraction(Capability.hammer, 3, EnumFacing.EAST, 12.0f, 15.0f, 12.0f, 15.0f, new PropertyMatcher().where(propBroken, Predicates.equalTo((Object)false)).where(propRotation, Predicates.equalTo((Object)2)), BlockForgedVent::breakBolt), new BlockInteraction(Capability.hammer, 3, EnumFacing.EAST, 12.0f, 15.0f, 1.0f, 4.0f, new PropertyMatcher().where(propBroken, Predicates.equalTo((Object)false)).where(propRotation, Predicates.equalTo((Object)3)), BlockForgedVent::breakBolt), new BlockInteraction(Capability.hammer, 3, EnumFacing.WEST, 12.0f, 15.0f, 12.0f, 15.0f, new PropertyMatcher().where(propBroken, Predicates.equalTo((Object)false)).where(propRotation, Predicates.equalTo((Object)0)), BlockForgedVent::breakBolt), new BlockInteraction(Capability.hammer, 3, EnumFacing.WEST, 12.0f, 15.0f, 1.0f, 4.0f, new PropertyMatcher().where(propBroken, Predicates.equalTo((Object)false)).where(propRotation, Predicates.equalTo((Object)1)), BlockForgedVent::breakBolt), new BlockInteraction(Capability.hammer, 3, EnumFacing.WEST, 1.0f, 4.0f, 12.0f, 15.0f, new PropertyMatcher().where(propBroken, Predicates.equalTo((Object)false)).where(propRotation, Predicates.equalTo((Object)2)), BlockForgedVent::breakBolt), new BlockInteraction(Capability.hammer, 3, EnumFacing.WEST, 1.0f, 4.0f, 1.0f, 4.0f, new PropertyMatcher().where(propBroken, Predicates.equalTo((Object)false)).where(propRotation, Predicates.equalTo((Object)3)), BlockForgedVent::breakBolt), new BlockInteraction(Capability.pry, 1, EnumFacing.EAST, 7.0f, 11.0f, 8.0f, 12.0f, new PropertyMatcher().where(propBroken, Predicates.equalTo((Object)true)), BlockForgedVent::breakPlate), new BlockInteraction(Capability.pry, 1, EnumFacing.WEST, 7.0f, 11.0f, 8.0f, 12.0f, new PropertyMatcher().where(propBroken, Predicates.equalTo((Object)true)), BlockForgedVent::breakPlate)};
        boltLootTable = new ResourceLocation("tetra", "forged/bolt_break");
        ventLootTable = new ResourceLocation("tetra", "forged/vent_break");
    }
}

