/*
 * Decompiled with CFR 0.152.
 */
package se.mickelus.tetra.blocks.forged.container;

import java.util.Arrays;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.inventory.Container;
import net.minecraft.inventory.IInventory;
import net.minecraft.inventory.Slot;
import net.minecraft.item.ItemStack;
import se.mickelus.tetra.blocks.forged.container.ChangeCompartmentPacket;
import se.mickelus.tetra.blocks.forged.container.TileEntityForgedContainer;
import se.mickelus.tetra.gui.ToggleableSlot;
import se.mickelus.tetra.network.PacketHandler;

public class ContainerForgedContainer
extends Container {
    private TileEntityForgedContainer tileEntity;
    private IInventory playerInventory;
    private ToggleableSlot[][] compartmentSlots;
    private int currentCompartment = 0;

    public ContainerForgedContainer(IInventory playerInventory, TileEntityForgedContainer tileEntity, EntityPlayer player) {
        int i;
        this.tileEntity = tileEntity;
        tileEntity.func_174889_b(player);
        this.playerInventory = playerInventory;
        this.compartmentSlots = new ToggleableSlot[TileEntityForgedContainer.compartmentCount][];
        for (i = 0; i < this.compartmentSlots.length; ++i) {
            this.compartmentSlots[i] = new ToggleableSlot[TileEntityForgedContainer.compartmentSize];
            int offset = i * TileEntityForgedContainer.compartmentSize;
            for (int j = 0; j < 6; ++j) {
                for (int k = 0; k < 9; ++k) {
                    int index = j * 9 + k;
                    this.compartmentSlots[i][index] = new ToggleableSlot(tileEntity, index + offset, k * 17 + 12, j * 17);
                    this.compartmentSlots[i][index].toggle(i == 0);
                    this.func_75146_a(this.compartmentSlots[i][index]);
                }
            }
        }
        for (i = 0; i < 3; ++i) {
            for (int j = 0; j < 9; ++j) {
                this.func_75146_a(new Slot(playerInventory, i * 9 + j + 9, j * 17 + 12, i * 17 + 116));
            }
        }
        for (i = 0; i < 9; ++i) {
            this.func_75146_a(new Slot(playerInventory, i, i * 17 + 12, 171));
        }
    }

    public void changeCompartment(int compartmentIndex) {
        this.currentCompartment = compartmentIndex;
        for (int i = 0; i < this.compartmentSlots.length; ++i) {
            boolean enabled = i == compartmentIndex;
            Arrays.stream(this.compartmentSlots[i]).forEach(slot -> slot.toggle(enabled));
        }
        if (this.tileEntity.func_145831_w().field_72995_K) {
            PacketHandler.sendToServer(new ChangeCompartmentPacket(compartmentIndex));
        }
    }

    public boolean func_75145_c(EntityPlayer playerIn) {
        return this.tileEntity.func_70300_a(playerIn);
    }

    public ItemStack func_82846_b(EntityPlayer player, int index) {
        Slot slot = (Slot)this.field_75151_b.get(index);
        if (slot != null && slot.func_75216_d()) {
            ItemStack itemStack = slot.func_75211_c();
            if (index < this.tileEntity.func_70302_i_() ? !this.func_75135_a(itemStack, this.tileEntity.func_70302_i_(), this.field_75151_b.size(), true) : !this.func_75135_a(itemStack, this.currentCompartment * TileEntityForgedContainer.compartmentSize, (this.currentCompartment + 1) * TileEntityForgedContainer.compartmentSize, false)) {
                return ItemStack.field_190927_a;
            }
            if (itemStack.func_190916_E() == 0) {
                slot.func_75215_d(ItemStack.field_190927_a);
            } else {
                slot.func_75218_e();
            }
            return itemStack.func_77946_l();
        }
        return ItemStack.field_190927_a;
    }

    public void func_75134_a(EntityPlayer playerIn) {
        super.func_75134_a(playerIn);
        this.tileEntity.func_174886_c(playerIn);
    }
}

