/*
 * Decompiled with CFR 0.152.
 */
package se.mickelus.tetra.blocks.forged.container;

import java.util.Arrays;
import java.util.Random;
import javax.annotation.Nullable;
import net.minecraft.block.BlockHorizontal;
import net.minecraft.block.properties.IProperty;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.init.MobEffects;
import net.minecraft.init.SoundEvents;
import net.minecraft.inventory.IInventory;
import net.minecraft.inventory.ItemStackHelper;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.network.NetworkManager;
import net.minecraft.network.play.server.SPacketUpdateTileEntity;
import net.minecraft.potion.PotionEffect;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.EnumParticleTypes;
import net.minecraft.util.NonNullList;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.SoundCategory;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.Vec3d;
import net.minecraft.world.WorldServer;
import net.minecraft.world.storage.loot.LootContext;
import net.minecraft.world.storage.loot.LootTable;
import se.mickelus.tetra.NBTHelper;
import se.mickelus.tetra.blocks.forged.container.BlockForgedContainer;

public class TileEntityForgedContainer
extends TileEntity
implements IInventory {
    private NonNullList<ItemStack> stacks = NonNullList.func_191197_a((int)(compartmentSize * compartmentCount), (Object)ItemStack.field_190927_a);
    public static int lockIntegrityMax = 4;
    public static int lockCount = 4;
    private int[] lockIntegrity = new int[lockCount];
    public static int lidIntegrityMax = 5;
    private int lidIntegrity = 3;
    private static final ResourceLocation lockLootTable = new ResourceLocation("tetra", "forged/lock_break");
    public static int compartmentCount = 3;
    public static int compartmentSize = 54;
    public long openTime = -1L;

    public TileEntityForgedContainer() {
        Arrays.fill(this.lockIntegrity, 1);
    }

    public TileEntityForgedContainer getOrDelegate() {
        TileEntityForgedContainer te;
        if (this.isFlipped() && (te = (TileEntityForgedContainer)this.field_145850_b.func_175625_s(this.field_174879_c.func_177972_a(this.getFacing().func_176735_f()))) != null) {
            return te;
        }
        return this;
    }

    public EnumFacing getFacing() {
        return (EnumFacing)this.field_145850_b.func_180495_p(this.field_174879_c).func_177229_b((IProperty)BlockForgedContainer.propFacing);
    }

    public boolean isFlipped() {
        return (Boolean)this.field_145850_b.func_180495_p(this.field_174879_c).func_177229_b((IProperty)BlockForgedContainer.propFlipped);
    }

    public void open(EntityPlayer player) {
        if (this.lidIntegrity > 0) {
            --this.lidIntegrity;
            this.func_70296_d();
            if (!this.field_145850_b.field_72995_K) {
                WorldServer worldServer = (WorldServer)this.field_145850_b;
                if (this.lidIntegrity == 0) {
                    this.causeOpeningEffects(worldServer);
                } else {
                    worldServer.func_184133_a(null, this.field_174879_c, SoundEvents.field_187614_cJ, SoundCategory.PLAYERS, 0.5f, 1.3f);
                }
                if (!player.func_70644_a(MobEffects.field_76420_g)) {
                    player.func_70690_d(new PotionEffect(MobEffects.field_76419_f, 100));
                }
            } else if (this.lidIntegrity == 0) {
                this.openTime = System.currentTimeMillis();
            }
        }
    }

    private void causeOpeningEffects(WorldServer worldServer) {
        EnumFacing facing = (EnumFacing)worldServer.func_180495_p(this.field_174879_c).func_177229_b((IProperty)BlockHorizontal.field_185512_D);
        Vec3d smokeDirection = new Vec3d(facing.func_176746_e().func_176730_m());
        Random random = new Random();
        int smokeCount = 5 + random.nextInt(4);
        BlockPos smokeOrigin = this.field_174879_c;
        if (EnumFacing.SOUTH.equals((Object)facing)) {
            smokeOrigin = smokeOrigin.func_177982_a(1, 0, 0);
        } else if (EnumFacing.WEST.equals((Object)facing)) {
            smokeOrigin = smokeOrigin.func_177982_a(1, 0, 1);
        } else if (EnumFacing.NORTH.equals((Object)facing)) {
            smokeOrigin = smokeOrigin.func_177982_a(0, 0, 1);
        }
        for (int i = 0; i < smokeCount; ++i) {
            worldServer.func_175739_a(EnumParticleTypes.SMOKE_NORMAL, (double)smokeOrigin.func_177958_n() + smokeDirection.field_72450_a * (double)i * 2.0 / (double)(smokeCount - 1), (double)smokeOrigin.func_177956_o() + 0.8, (double)smokeOrigin.func_177952_p() + smokeDirection.field_72449_c * (double)i * 2.0 / (double)(smokeCount - 1), 1, 0.0, 0.0, 0.0, 0.0, new int[0]);
        }
        worldServer.func_184133_a(null, this.field_174879_c, SoundEvents.field_187617_cK, SoundCategory.PLAYERS, 1.0f, 0.5f);
        worldServer.func_184133_a(null, this.field_174879_c, SoundEvents.field_187659_cY, SoundCategory.PLAYERS, 0.2f, 0.8f);
    }

    public boolean isOpen() {
        return this.lidIntegrity <= 0;
    }

    public boolean isLocked(int index) {
        return this.lockIntegrity[index] > 0;
    }

    public Boolean[] isLocked() {
        return (Boolean[])Arrays.stream(this.lockIntegrity).mapToObj(integrity -> integrity > 0).toArray(Boolean[]::new);
    }

    public void breakLock(EntityPlayer player, int index) {
        if (this.lockIntegrity[index] > 0) {
            int n = index;
            this.lockIntegrity[n] = this.lockIntegrity[n] - 1;
            if (!this.field_145850_b.field_72995_K) {
                WorldServer worldServer = (WorldServer)this.field_145850_b;
                if (this.lockIntegrity[index] == 0) {
                    worldServer.func_184133_a(null, this.field_174879_c, SoundEvents.field_187769_eM, SoundCategory.PLAYERS, 1.0f, 0.5f);
                } else {
                    worldServer.func_184133_a(null, this.field_174879_c, SoundEvents.field_187928_hb, SoundCategory.PLAYERS, 1.0f, 0.5f);
                }
                if (this.lockIntegrity[index] == 0) {
                    LootTable table = worldServer.func_184146_ak().func_186521_a(lockLootTable);
                    LootContext.Builder builder = new LootContext.Builder(worldServer);
                    builder.func_186469_a(player.func_184817_da()).func_186470_a(player);
                    table.func_186462_a(player.func_70681_au(), builder.func_186471_a()).forEach(itemStack -> {
                        if (!player.field_71071_by.func_70441_a(itemStack)) {
                            player.func_71019_a(itemStack, false);
                        }
                    });
                }
            }
        }
        this.func_70296_d();
    }

    @Nullable
    public SPacketUpdateTileEntity func_189518_D_() {
        return new SPacketUpdateTileEntity(this.field_174879_c, 0, this.func_189517_E_());
    }

    public NBTTagCompound func_189517_E_() {
        return this.func_189515_b(new NBTTagCompound());
    }

    public void onDataPacket(NetworkManager net, SPacketUpdateTileEntity packet) {
        this.func_145839_a(packet.func_148857_g());
    }

    public void func_145839_a(NBTTagCompound compound) {
        super.func_145839_a(compound);
        NBTHelper.readItemStacks(compound, this.stacks);
        for (int i = 0; i < this.lockIntegrity.length; ++i) {
            this.lockIntegrity[i] = compound.func_74762_e("lock_integrity" + i);
        }
        this.lidIntegrity = compound.func_74762_e("lid_integrity");
    }

    public NBTTagCompound func_189515_b(NBTTagCompound compound) {
        super.func_189515_b(compound);
        NBTHelper.writeItemStacks(this.stacks, compound);
        TileEntityForgedContainer.writeLockData(compound, this.lockIntegrity);
        TileEntityForgedContainer.writeLidData(compound, this.lidIntegrity);
        return compound;
    }

    public static void writeLockData(NBTTagCompound compound, int[] lockIntegrity) {
        for (int i = 0; i < lockIntegrity.length; ++i) {
            compound.func_74768_a("lock_integrity" + i, lockIntegrity[i]);
        }
    }

    public static void writeLidData(NBTTagCompound compound, int lidIntegrity) {
        compound.func_74768_a("lid_integrity", lidIntegrity);
    }

    public int func_70302_i_() {
        return this.stacks.size();
    }

    public boolean func_191420_l() {
        return this.stacks.stream().allMatch(ItemStack::func_190926_b);
    }

    @Nullable
    public ItemStack func_70301_a(int index) {
        return (ItemStack)this.stacks.get(index);
    }

    @Nullable
    public ItemStack func_70298_a(int index, int count) {
        ItemStack itemstack = ItemStackHelper.func_188382_a(this.stacks, (int)index, (int)count);
        if (!itemstack.func_190926_b()) {
            this.func_70296_d();
        }
        return itemstack;
    }

    @Nullable
    public ItemStack func_70304_b(int index) {
        ItemStack itemstack = ItemStackHelper.func_188383_a(this.stacks, (int)index);
        if (!itemstack.func_190926_b()) {
            this.func_70296_d();
        }
        return itemstack;
    }

    public void func_70299_a(int index, ItemStack itemStack) {
        this.stacks.set(index, (Object)itemStack);
        if (!itemStack.func_190926_b() && itemStack.func_190916_E() > this.func_70297_j_()) {
            itemStack.func_190920_e(this.func_70297_j_());
        }
    }

    public int func_70297_j_() {
        return 64;
    }

    public boolean func_70300_a(EntityPlayer player) {
        return true;
    }

    public void func_174889_b(EntityPlayer player) {
    }

    public void func_174886_c(EntityPlayer player) {
    }

    public boolean func_94041_b(int index, ItemStack stack) {
        return true;
    }

    public int func_174887_a_(int id) {
        return 0;
    }

    public void func_174885_b(int id, int value) {
    }

    public int func_174890_g() {
        return 0;
    }

    public void func_174888_l() {
        this.stacks.clear();
    }

    public String func_70005_c_() {
        return "forged_container";
    }

    public boolean func_145818_k_() {
        return false;
    }
}

