/*
 * Decompiled with CFR 0.152.
 */
package se.mickelus.tetra.blocks.forged.extractor;

import net.minecraft.block.Block;
import net.minecraft.block.BlockDirectional;
import net.minecraft.block.material.Material;
import net.minecraft.block.properties.IProperty;
import net.minecraft.block.properties.PropertyBool;
import net.minecraft.block.properties.PropertyDirection;
import net.minecraft.block.state.BlockStateContainer;
import net.minecraft.block.state.IBlockState;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.item.ItemStack;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.EnumHand;
import net.minecraft.util.NonNullList;
import net.minecraft.util.Rotation;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;
import net.minecraftforge.fml.common.registry.GameRegistry;
import se.mickelus.tetra.blocks.TetraBlock;
import se.mickelus.tetra.blocks.forged.extractor.BlockSeepingBedrock;
import se.mickelus.tetra.items.TetraCreativeTabs;

public class BlockCoreExtractorPipe
extends TetraBlock {
    public static final PropertyDirection propFacing = BlockDirectional.field_176387_N;
    public static final PropertyBool propPowered = PropertyBool.func_177716_a((String)"powered");
    public static final String unlocalizedName = "extractor_pipe";
    @GameRegistry.ObjectHolder(value="tetra:extractor_pipe")
    public static BlockCoreExtractorPipe instance;

    public BlockCoreExtractorPipe() {
        super(Material.field_151573_f);
        this.setRegistryName(unlocalizedName);
        this.func_149663_c(unlocalizedName);
        this.func_149647_a(TetraCreativeTabs.getInstance());
        this.func_149722_s();
        this.func_149752_b(22.0f);
        this.hasItem = true;
        this.func_180632_j(this.func_176194_O().func_177621_b().func_177226_a((IProperty)propFacing, (Comparable)EnumFacing.UP).func_177226_a((IProperty)propPowered, (Comparable)Boolean.valueOf(false)));
    }

    public static boolean isPowered(IBlockAccess world, BlockPos pos) {
        IBlockState pipeState = world.func_180495_p(pos.func_177977_b());
        return instance.equals(pipeState.func_177230_c()) && (Boolean)pipeState.func_177229_b((IProperty)propPowered) != false;
    }

    private boolean shouldGetPower(IBlockAccess world, BlockPos pos, EnumFacing blockFacing) {
        for (EnumFacing facing : EnumFacing.values()) {
            IBlockState adjacent;
            if (facing.equals((Object)blockFacing) || !(adjacent = world.func_180495_p(pos.func_177972_a(facing))).func_177230_c().equals(this) || !facing.equals((Object)((EnumFacing)adjacent.func_177229_b((IProperty)propFacing)).func_176734_d()) || !((Boolean)adjacent.func_177229_b((IProperty)propPowered)).booleanValue()) continue;
            return true;
        }
        return BlockSeepingBedrock.isActive(world, pos.func_177972_a(blockFacing.func_176734_d()));
    }

    public void getDrops(NonNullList<ItemStack> drops, IBlockAccess world, BlockPos pos, IBlockState state, int fortune) {
        drops.clear();
    }

    public void func_189540_a(IBlockState state, World world, BlockPos pos, Block fromBlock, BlockPos fromPos) {
        boolean getsPowered = this.shouldGetPower((IBlockAccess)world, pos, (EnumFacing)state.func_177229_b((IProperty)propFacing));
        if ((Boolean)state.func_177229_b((IProperty)propPowered) != getsPowered) {
            world.func_175656_a(pos, state.func_177226_a((IProperty)propPowered, (Comparable)Boolean.valueOf(getsPowered)));
        }
    }

    protected BlockStateContainer func_180661_e() {
        return new BlockStateContainer((Block)this, new IProperty[]{propFacing, propPowered});
    }

    public IBlockState func_176203_a(int meta) {
        return this.func_176223_P().func_177226_a((IProperty)propFacing, (Comparable)EnumFacing.func_82600_a((int)(meta & 3))).func_177226_a((IProperty)propPowered, (Comparable)Boolean.valueOf((meta >> 3 & 1) == 1));
    }

    public int func_176201_c(IBlockState state) {
        return ((EnumFacing)state.func_177229_b((IProperty)propFacing)).func_176745_a() | ((Boolean)state.func_177229_b((IProperty)propPowered) != false ? 8 : 0);
    }

    public IBlockState getStateForPlacement(World world, BlockPos pos, EnumFacing facing, float hitX, float hitY, float hitZ, int meta, EntityLivingBase placer, EnumHand hand) {
        return super.func_180642_a(world, pos, facing, hitX, hitY, hitZ, meta, placer).func_177226_a((IProperty)propFacing, (Comparable)facing).func_177226_a((IProperty)propPowered, (Comparable)Boolean.valueOf(this.shouldGetPower((IBlockAccess)world, pos, facing)));
    }

    public IBlockState func_185499_a(IBlockState state, Rotation rot) {
        return state.func_177226_a((IProperty)propFacing, (Comparable)rot.func_185831_a((EnumFacing)state.func_177229_b((IProperty)propFacing)));
    }
}

