/*
 * Decompiled with CFR 0.152.
 */
package se.mickelus.tetra.blocks.forged.extractor;

import java.util.Optional;
import javax.annotation.Nullable;
import net.minecraft.block.properties.IProperty;
import net.minecraft.block.state.IBlockState;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.network.NetworkManager;
import net.minecraft.network.play.server.SPacketUpdateTileEntity;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.ITickable;
import net.minecraft.world.IBlockAccess;
import se.mickelus.tetra.blocks.IHeatTransfer;
import se.mickelus.tetra.blocks.forged.extractor.BlockCoreExtractorBase;
import se.mickelus.tetra.blocks.forged.extractor.BlockCoreExtractorPipe;
import se.mickelus.tetra.blocks.forged.extractor.TileEntityCoreExtractorPiston;
import se.mickelus.tetra.util.TileEntityOptional;

public class TileEntityCoreExtractorBase
extends TileEntity
implements ITickable,
IHeatTransfer {
    private boolean isSending = false;
    private static final int sendLimit = 4;
    private static final String chargeKey = "charge";
    private static final int maxCharge = 128;
    private static final int drainAmount = 4;
    private int currentCharge = 0;
    private float efficiency;

    public boolean canRefill() {
        return this.getPiston().isPresent() && BlockCoreExtractorPipe.isPowered((IBlockAccess)this.field_145850_b, this.field_174879_c.func_177977_b());
    }

    @Override
    public void setReceiving(boolean receiving) {
        if (receiving) {
            this.isSending = false;
        }
        this.notifyBlockUpdate();
    }

    @Override
    public boolean isReceiving() {
        return false;
    }

    @Override
    public boolean canRecieve() {
        return false;
    }

    @Override
    public void setSending(boolean sending) {
        this.isSending = sending;
        this.notifyBlockUpdate();
    }

    @Override
    public boolean isSending() {
        return this.isSending;
    }

    @Override
    public boolean canSend() {
        return this.currentCharge > 0 || this.canRefill();
    }

    @Override
    public int getReceiveLimit() {
        return 0;
    }

    @Override
    public int getSendLimit() {
        return 4;
    }

    @Override
    public int drain(int amount) {
        if (amount > this.currentCharge) {
            int drained = this.currentCharge;
            this.currentCharge = 0;
            return drained;
        }
        this.currentCharge -= amount;
        return amount;
    }

    @Override
    public int fill(int amount) {
        if (amount + this.currentCharge > 128) {
            int overfill = amount + this.currentCharge - 128;
            this.currentCharge = 128;
            return overfill;
        }
        this.currentCharge += amount;
        this.updateTransferState();
        return 0;
    }

    @Override
    public int getCharge() {
        return this.currentCharge;
    }

    @Override
    public float getEfficiency() {
        return 1.0f;
    }

    public void func_73660_a() {
        if (this.isSending) {
            if (this.field_145850_b.func_82737_E() % 5L == 0L) {
                this.transfer();
            }
        } else if (this.currentCharge > 0 && this.field_145850_b.func_82737_E() % 20L == 0L) {
            this.currentCharge = Math.max(0, this.currentCharge - 4);
        }
    }

    @Override
    public void updateTransferState() {
        this.getConnectedUnit().ifPresent(connected -> {
            boolean canSend = this.canSend();
            boolean canRecieve = connected.canRecieve();
            this.setSending(canSend && canRecieve);
            connected.setReceiving(canSend && canRecieve);
            this.efficiency = this.getEfficiency() * connected.getEfficiency();
            if (!canSend && canRecieve && this.canRefill()) {
                this.getPiston().ifPresent(TileEntityCoreExtractorPiston::activate);
            }
        });
    }

    public void transfer() {
        this.getConnectedUnit().ifPresent(connected -> {
            if (connected.canRecieve()) {
                if (this.currentCharge > 0) {
                    int amount = this.drain(Math.min(this.getSendLimit(), connected.getReceiveLimit()));
                    int overfill = connected.fill((int)((float)amount * this.efficiency));
                    if (overfill > 0) {
                        this.fill(overfill);
                    }
                    this.func_70296_d();
                } else {
                    this.setSending(false);
                    connected.setReceiving(false);
                    this.notifyBlockUpdate();
                }
                if (this.canRefill()) {
                    this.getPiston().ifPresent(TileEntityCoreExtractorPiston::activate);
                }
            } else {
                this.setSending(false);
                connected.setReceiving(false);
                this.notifyBlockUpdate();
            }
        });
    }

    private void notifyBlockUpdate() {
        this.func_70296_d();
        IBlockState state = this.field_145850_b.func_180495_p(this.field_174879_c);
        this.field_145850_b.func_184138_a(this.field_174879_c, state, state, 3);
    }

    public EnumFacing getFacing() {
        return (EnumFacing)this.field_145850_b.func_180495_p(this.field_174879_c).func_177229_b((IProperty)BlockCoreExtractorBase.propFacing);
    }

    private Optional<IHeatTransfer> getConnectedUnit() {
        return TileEntityOptional.from((IBlockAccess)this.field_145850_b, this.field_174879_c.func_177972_a(this.getFacing()), IHeatTransfer.class);
    }

    private Optional<TileEntityCoreExtractorPiston> getPiston() {
        return TileEntityOptional.from((IBlockAccess)this.field_145850_b, this.field_174879_c.func_177972_a(EnumFacing.UP), TileEntityCoreExtractorPiston.class);
    }

    public void func_145839_a(NBTTagCompound compound) {
        super.func_145839_a(compound);
        this.currentCharge = compound.func_74764_b(chargeKey) ? compound.func_74762_e(chargeKey) : 0;
    }

    public NBTTagCompound func_189515_b(NBTTagCompound compound) {
        super.func_189515_b(compound);
        compound.func_74768_a(chargeKey, this.currentCharge);
        return compound;
    }

    @Nullable
    public SPacketUpdateTileEntity func_189518_D_() {
        return new SPacketUpdateTileEntity(this.field_174879_c, 0, this.func_189517_E_());
    }

    public NBTTagCompound func_189517_E_() {
        return this.func_189515_b(new NBTTagCompound());
    }

    public void onDataPacket(NetworkManager net, SPacketUpdateTileEntity packet) {
        this.func_145839_a(packet.func_148857_g());
        IBlockState state = this.field_145850_b.func_180495_p(this.field_174879_c);
        this.updateTransferState();
        this.field_145850_b.func_184138_a(this.field_174879_c, state, state, 3);
    }
}

