/*
 * Decompiled with CFR 0.152.
 */
package se.mickelus.tetra.blocks.forged.extractor;

import com.google.common.collect.ImmutableMap;
import javax.annotation.Nullable;
import net.minecraft.init.SoundEvents;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.EnumParticleTypes;
import net.minecraft.util.ITickable;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.SoundCategory;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;
import net.minecraft.world.WorldServer;
import net.minecraftforge.client.model.ModelLoaderRegistry;
import net.minecraftforge.client.model.animation.Animation;
import net.minecraftforge.common.animation.TimeValues;
import net.minecraftforge.common.capabilities.Capability;
import net.minecraftforge.common.model.animation.CapabilityAnimation;
import net.minecraftforge.common.model.animation.IAnimationStateMachine;
import net.minecraftforge.fml.common.FMLCommonHandler;
import net.minecraftforge.fml.relauncher.Side;
import se.mickelus.tetra.blocks.forged.extractor.TileEntityCoreExtractorBase;
import se.mickelus.tetra.util.TileEntityOptional;

public class TileEntityCoreExtractorPiston
extends TileEntity
implements ITickable {
    private static final long activationDuration = 95L;
    private static final int fillAmount = 32;
    private final TimeValues.VariableValue activationTime = new TimeValues.VariableValue(Float.NEGATIVE_INFINITY);
    private long endTime = Long.MAX_VALUE;
    @Nullable
    private final IAnimationStateMachine asm = FMLCommonHandler.instance().getEffectiveSide().equals((Object)Side.CLIENT) ? ModelLoaderRegistry.loadASM((ResourceLocation)new ResourceLocation("tetra", "asms/block/extractor_piston.json"), (ImmutableMap)ImmutableMap.of((Object)"activation_time", (Object)this.activationTime)) : null;

    public boolean hasCapability(Capability<?> capability, @Nullable EnumFacing facing) {
        return CapabilityAnimation.ANIMATION_CAPABILITY.equals(capability) || super.hasCapability(capability, facing);
    }

    public <T> T getCapability(Capability<T> capability, @Nullable EnumFacing side) {
        if (capability == CapabilityAnimation.ANIMATION_CAPABILITY) {
            return (T)CapabilityAnimation.ANIMATION_CAPABILITY.cast((Object)this.asm);
        }
        return (T)super.getCapability(capability, side);
    }

    public void activate() {
        if (this.asm != null && !this.asm.currentState().equals("active")) {
            this.asm.transition("active");
            this.activationTime.setValue(Animation.getWorldTime((World)this.func_145831_w(), (float)Animation.getPartialTickTime()));
        }
        if (!this.isActive()) {
            this.endTime = this.field_145850_b.func_82737_E() + 95L;
        }
    }

    public boolean isActive() {
        return this.endTime != Long.MAX_VALUE;
    }

    public boolean hasFastRenderer() {
        return true;
    }

    public void func_73660_a() {
        if (this.endTime < this.field_145850_b.func_82737_E()) {
            TileEntityOptional.from((IBlockAccess)this.field_145850_b, this.field_174879_c.func_177972_a(EnumFacing.DOWN), TileEntityCoreExtractorBase.class).ifPresent(base -> base.fill(32));
            this.runEndEffects();
            this.endTime = Long.MAX_VALUE;
        }
    }

    private void runEndEffects() {
        if (this.field_145850_b instanceof WorldServer) {
            ((WorldServer)this.field_145850_b).func_175739_a(EnumParticleTypes.SMOKE_LARGE, (double)this.field_174879_c.func_177958_n() + 0.5, (double)this.field_174879_c.func_177956_o() + 0.1, (double)this.field_174879_c.func_177952_p() + 0.5, 5, 0.0, 0.0, 0.0, (double)0.02f, new int[0]);
        }
        this.field_145850_b.func_184133_a(null, this.field_174879_c, SoundEvents.field_187646_bt, SoundCategory.BLOCKS, 0.1f, 1.0f);
        this.field_145850_b.func_184133_a(null, this.field_174879_c, SoundEvents.field_187768_dl, SoundCategory.BLOCKS, 0.2f, 0.5f);
    }
}

