/*
 * Decompiled with CFR 0.152.
 */
package se.mickelus.tetra.blocks.geode;

import java.util.Arrays;
import java.util.Random;
import javax.annotation.Nullable;
import net.minecraft.block.Block;
import net.minecraft.block.SoundType;
import net.minecraft.block.material.Material;
import net.minecraft.block.properties.IProperty;
import net.minecraft.block.properties.PropertyInteger;
import net.minecraft.block.state.BlockStateContainer;
import net.minecraft.block.state.IBlockState;
import net.minecraft.entity.Entity;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.RayTraceResult;
import net.minecraft.world.Explosion;
import net.minecraft.world.World;
import net.minecraftforge.fml.common.IWorldGenerator;
import net.minecraftforge.fml.common.registry.GameRegistry;
import se.mickelus.tetra.ConfigHandler;
import se.mickelus.tetra.blocks.TetraBlock;
import se.mickelus.tetra.blocks.geode.GeodeGenerator;
import se.mickelus.tetra.blocks.geode.GeodeVariant;
import se.mickelus.tetra.blocks.geode.ItemGeode;
import se.mickelus.tetra.data.DataHandler;
import se.mickelus.tetra.items.TetraCreativeTabs;
import se.mickelus.tetra.network.PacketHandler;

public class BlockGeode
extends TetraBlock {
    static final String unlocalizedName = "block_geode";
    @GameRegistry.ObjectHolder(value="tetra:block_geode")
    public static BlockGeode instance;
    public static PropertyInteger variantProp;
    public GeodeVariant[] variants = new GeodeVariant[0];
    private GeodeVariant fallbackVariant = new GeodeVariant();

    public BlockGeode() {
        super(Material.field_151576_e);
        this.func_149672_a(SoundType.field_185851_d);
        this.setHarvestLevel("pickaxe", 0);
        this.func_149663_c(unlocalizedName);
        this.setRegistryName(unlocalizedName);
        this.func_149647_a(TetraCreativeTabs.getInstance());
        this.func_180632_j(this.field_176227_L.func_177621_b().func_177226_a((IProperty)variantProp, (Comparable)Integer.valueOf(0)));
    }

    protected BlockStateContainer func_180661_e() {
        return new BlockStateContainer((Block)this, new IProperty[]{variantProp});
    }

    public IBlockState func_176203_a(int meta) {
        return this.func_176223_P().func_177226_a((IProperty)variantProp, (Comparable)Integer.valueOf(meta));
    }

    public int func_176201_c(IBlockState blockState) {
        return (Integer)blockState.func_177229_b((IProperty)variantProp);
    }

    private GeodeVariant getVariant(IBlockState state) {
        int index = (Integer)state.func_177229_b((IProperty)variantProp);
        if (index < this.variants.length) {
            return this.variants[index];
        }
        return this.fallbackVariant;
    }

    public ItemStack getPickBlock(IBlockState blockState, RayTraceResult target, World world, BlockPos pos, EntityPlayer player) {
        return this.func_180643_i(blockState);
    }

    public Item func_180660_a(IBlockState state, Random rand, int fortune) {
        return ItemGeode.instance;
    }

    public int func_180651_a(IBlockState blockState) {
        return this.getVariant((IBlockState)blockState).dropMeta;
    }

    protected ItemStack func_180643_i(IBlockState state) {
        GeodeVariant variant = this.getVariant(state);
        return new ItemStack(variant.block, 1, variant.blockMeta);
    }

    public float func_176195_g(IBlockState blockState, World worldIn, BlockPos pos) {
        return this.getVariant((IBlockState)blockState).hardness;
    }

    public float getExplosionResistance(World world, BlockPos pos, @Nullable Entity exploder, Explosion explosion) {
        return this.getVariant((IBlockState)world.func_180495_p((BlockPos)pos)).resistance;
    }

    @Override
    public void init(PacketHandler packetHandler) {
        if (ConfigHandler.geodeGenerate) {
            GameRegistry.registerWorldGenerator((IWorldGenerator)new GeodeGenerator(), (int)10);
        }
        this.variants = (GeodeVariant[])Arrays.stream((Object[])DataHandler.instance.getData("geode/variants", GeodeVariant[].class)).filter(variant -> variant.block != null).toArray(GeodeVariant[]::new);
    }

    static {
        variantProp = PropertyInteger.func_177719_a((String)"variant", (int)0, (int)((int)Arrays.stream((Object[])DataHandler.instance.getData("geode/variants", GeodeVariant[].class)).count() - 1));
    }
}

