/*
 * Decompiled with CFR 0.152.
 */
package se.mickelus.tetra.blocks.geode;

import java.util.Arrays;
import java.util.Random;
import java.util.Set;
import net.minecraft.block.state.IBlockState;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.ChunkPos;
import net.minecraft.world.World;
import net.minecraft.world.biome.Biome;
import net.minecraft.world.chunk.IChunkProvider;
import net.minecraft.world.gen.IChunkGenerator;
import net.minecraftforge.common.BiomeDictionary;
import net.minecraftforge.fml.common.IWorldGenerator;
import se.mickelus.tetra.blocks.geode.BlockGeode;
import se.mickelus.tetra.blocks.geode.GeodeVariant;

public class GeodeGenerator
implements IWorldGenerator {
    public void generate(Random random, int chunkX, int chunkZ, World world, IChunkGenerator chunkGenerator, IChunkProvider chunkProvider) {
        ChunkPos chunkPos = new ChunkPos(chunkX, chunkZ);
        GeodeVariant[] variants = BlockGeode.instance.variants;
        for (int i = 0; i < variants.length; ++i) {
            if (!this.isvalidBiome(variants[i], world, chunkPos)) continue;
            this.generateGeodes(variants[i], world, chunkPos, random, i);
        }
    }

    private void generateGeodes(GeodeVariant variant, World world, ChunkPos chunkPos, Random random, int index) {
        for (int i = 0; i < variant.density; ++i) {
            BlockPos blockPos = chunkPos.func_180331_a(random.nextInt(16), this.getY(variant, random), random.nextInt(16));
            IBlockState state = world.func_180495_p(blockPos);
            if (!this.isValidBlockState(variant, state)) continue;
            world.func_180501_a(blockPos, BlockGeode.instance.func_176203_a(index), 16);
        }
    }

    private boolean isValidBlockState(GeodeVariant variant, IBlockState blockState) {
        return variant.block.equals(blockState.func_177230_c()) && variant.blockMeta == blockState.func_177230_c().func_176201_c(blockState);
    }

    private boolean isvalidBiome(GeodeVariant variant, World world, ChunkPos chunkPos) {
        if (variant.biomes.length == 0) {
            return true;
        }
        Biome biome = world.func_180494_b(chunkPos.func_180331_a(0, 0, 0));
        Set types = BiomeDictionary.getTypes((Biome)biome);
        return types.stream().anyMatch(type -> Arrays.stream(variant.biomes).anyMatch(biomeName -> biomeName.equals(type.getName().toLowerCase())));
    }

    private int getY(GeodeVariant variant, Random random) {
        if (variant.maxY > variant.minY) {
            return variant.minY + random.nextInt(variant.maxY - variant.minY);
        }
        return variant.minY;
    }
}

