/*
 * Decompiled with CFR 0.152.
 */
package se.mickelus.tetra.blocks.hammer;

import com.mojang.realmsclient.gui.ChatFormatting;
import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import javax.annotation.Nullable;
import net.minecraft.block.Block;
import net.minecraft.block.BlockHorizontal;
import net.minecraft.block.ITileEntityProvider;
import net.minecraft.block.material.Material;
import net.minecraft.block.properties.IProperty;
import net.minecraft.block.properties.PropertyBool;
import net.minecraft.block.properties.PropertyDirection;
import net.minecraft.block.state.BlockStateContainer;
import net.minecraft.block.state.IBlockState;
import net.minecraft.client.resources.I18n;
import net.minecraft.client.util.ITooltipFlag;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.item.EntityItem;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraft.init.SoundEvents;
import net.minecraft.item.ItemStack;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.BlockRenderLayer;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.EnumHand;
import net.minecraft.util.Mirror;
import net.minecraft.util.NonNullList;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.Rotation;
import net.minecraft.util.SoundCategory;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;
import net.minecraft.world.WorldServer;
import net.minecraft.world.storage.loot.LootContext;
import net.minecraft.world.storage.loot.LootTable;
import net.minecraftforge.fml.common.registry.GameRegistry;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;
import se.mickelus.tetra.advancements.BlockUseCriterion;
import se.mickelus.tetra.blocks.TetraBlock;
import se.mickelus.tetra.blocks.hammer.EnumHammerConfig;
import se.mickelus.tetra.blocks.hammer.EnumHammerEffect;
import se.mickelus.tetra.blocks.hammer.EnumHammerPlate;
import se.mickelus.tetra.blocks.hammer.TileEntityHammerBase;
import se.mickelus.tetra.blocks.salvage.BlockInteraction;
import se.mickelus.tetra.blocks.salvage.IBlockCapabilityInteractive;
import se.mickelus.tetra.capabilities.Capability;
import se.mickelus.tetra.items.ItemModular;
import se.mickelus.tetra.items.TetraCreativeTabs;
import se.mickelus.tetra.items.cell.ItemCellMagmatic;
import se.mickelus.tetra.items.forged.ItemVentPlate;
import se.mickelus.tetra.util.TileEntityOptional;

public class BlockHammerBase
extends TetraBlock
implements ITileEntityProvider,
IBlockCapabilityInteractive {
    public static final PropertyDirection propFacing = BlockHorizontal.field_185512_D;
    public static final PropertyBool propCell1 = PropertyBool.func_177716_a((String)"cell1");
    public static final PropertyBool propCell1Charged = PropertyBool.func_177716_a((String)"cell1charged");
    public static final PropertyBool propCell2 = PropertyBool.func_177716_a((String)"cell2");
    public static final PropertyBool propCell2Charged = PropertyBool.func_177716_a((String)"cell2charged");
    private static final ResourceLocation plateLootTable = new ResourceLocation("tetra", "forged/plate_break");
    static final String unlocalizedName = "hammer_base";
    @GameRegistry.ObjectHolder(value="tetra:hammer_base")
    public static BlockHammerBase instance;
    public static final BlockInteraction[] interactions;

    public BlockHammerBase() {
        super(Material.field_151573_f);
        this.setRegistryName(unlocalizedName);
        this.func_149663_c(unlocalizedName);
        this.func_149647_a(TetraCreativeTabs.getInstance());
        this.func_149722_s();
        GameRegistry.registerTileEntity(TileEntityHammerBase.class, (ResourceLocation)new ResourceLocation("tetra", unlocalizedName));
        this.hasItem = true;
        this.func_180632_j(this.field_176227_L.func_177621_b().func_177226_a((IProperty)propFacing, (Comparable)EnumFacing.EAST).func_177226_a((IProperty)propCell1, (Comparable)Boolean.valueOf(false)).func_177226_a((IProperty)propCell1Charged, (Comparable)Boolean.valueOf(false)).func_177226_a((IProperty)propCell2, (Comparable)Boolean.valueOf(false)).func_177226_a((IProperty)propCell2Charged, (Comparable)Boolean.valueOf(false)));
    }

    public void getDrops(NonNullList<ItemStack> drops, IBlockAccess world, BlockPos pos, IBlockState state, int fortune) {
        drops.clear();
    }

    @SideOnly(value=Side.CLIENT)
    public void func_190948_a(ItemStack stack, @Nullable World player, List<String> tooltip, ITooltipFlag advanced) {
        tooltip.add(ChatFormatting.DARK_GRAY + I18n.func_135052_a((String)"forged_description", (Object[])new Object[0]));
    }

    public IBlockState func_176221_a(IBlockState state, IBlockAccess world, BlockPos pos) {
        return TileEntityOptional.from(world, pos, TileEntityHammerBase.class).map(te -> state.func_177226_a((IProperty)propCell1, (Comparable)Boolean.valueOf(te.hasCellInSlot(0))).func_177226_a((IProperty)propCell1Charged, (Comparable)Boolean.valueOf(te.getCellFuel(0) > 0)).func_177226_a((IProperty)propCell2, (Comparable)Boolean.valueOf(te.hasCellInSlot(1))).func_177226_a((IProperty)propCell2Charged, (Comparable)Boolean.valueOf(te.getCellFuel(1) > 0)).func_177226_a((IProperty)EnumHammerPlate.EAST.prop, (Comparable)Boolean.valueOf(te.hasPlate(EnumHammerPlate.EAST))).func_177226_a((IProperty)EnumHammerPlate.WEST.prop, (Comparable)Boolean.valueOf(te.hasPlate(EnumHammerPlate.WEST))).func_177226_a(EnumHammerConfig.propE, (Comparable)((Object)te.getConfiguration(EnumFacing.EAST))).func_177226_a(EnumHammerConfig.propW, (Comparable)((Object)te.getConfiguration(EnumFacing.WEST)))).orElse(state);
    }

    public boolean isFueled(World world, BlockPos pos) {
        return TileEntityOptional.from((IBlockAccess)world, pos, TileEntityHammerBase.class).map(TileEntityHammerBase::isFueled).orElse(false);
    }

    public void consumeFuel(World world, BlockPos pos) {
        TileEntityOptional.from((IBlockAccess)world, pos, TileEntityHammerBase.class).ifPresent(te -> {
            IBlockState blockState = world.func_180495_p(pos);
            te.consumeFuel();
            world.func_184138_a(pos, blockState, blockState, 3);
        });
    }

    public void applyEffects(World world, BlockPos pos, ItemStack itemStack, EntityPlayer player) {
        TileEntityOptional.from((IBlockAccess)world, pos, TileEntityHammerBase.class).ifPresent(te -> {
            if (te.hasEffect(EnumHammerEffect.DAMAGING) && itemStack.func_77973_b() instanceof ItemModular) {
                ItemModular item = (ItemModular)itemStack.func_77973_b();
                int damage = (int)((double)itemStack.func_77958_k() * 0.1);
                item.applyDamage(damage, itemStack, (EntityLivingBase)player);
            }
        });
    }

    public int getHammerLevel(World world, BlockPos pos) {
        return TileEntityOptional.from((IBlockAccess)world, pos, TileEntityHammerBase.class).map(TileEntityHammerBase::getHammerLevel).orElse(0);
    }

    public static boolean removePlate(World world, BlockPos pos, IBlockState state, EntityPlayer player, EnumHammerPlate plate, EnumFacing face) {
        TileEntityOptional.from((IBlockAccess)world, pos, TileEntityHammerBase.class).ifPresent(te -> {
            te.removePlate(plate);
            if (!world.field_72995_K) {
                WorldServer worldServer = (WorldServer)world;
                LootTable table = worldServer.func_184146_ak().func_186521_a(plateLootTable);
                LootContext.Builder builder = new LootContext.Builder(worldServer);
                builder.func_186469_a(player.func_184817_da()).func_186470_a(player);
                table.func_186462_a(player.func_70681_au(), builder.func_186471_a()).forEach(itemStack -> BlockHammerBase.spawnAsEntity((World)worldServer, pos, itemStack));
            }
            world.func_184133_a(player, pos, SoundEvents.field_187769_eM, SoundCategory.PLAYERS, 1.0f, 0.5f);
            world.func_184138_a(pos, state, state, 3);
        });
        return true;
    }

    public static boolean reconfigure(World world, BlockPos pos, IBlockState state, EntityPlayer player, EnumFacing adjustedFace) {
        TileEntityOptional.from((IBlockAccess)world, pos, TileEntityHammerBase.class).ifPresent(te -> {
            te.reconfigure(adjustedFace);
            world.func_184133_a(player, pos, SoundEvents.field_187686_e, SoundCategory.PLAYERS, 1.0f, 1.0f);
            world.func_184138_a(pos, state, state, 3);
        });
        return true;
    }

    public boolean func_180639_a(World world, BlockPos pos, IBlockState state, EntityPlayer player, EnumHand hand, EnumFacing facing, float hitX, float hitY, float hitZ) {
        EnumFacing blockFacing = (EnumFacing)state.func_177229_b((IProperty)propFacing);
        TileEntityHammerBase te = TileEntityOptional.from((IBlockAccess)world, pos, TileEntityHammerBase.class).orElse(null);
        ItemStack heldStack = player.func_184586_b(hand);
        if (te == null) {
            return false;
        }
        if (blockFacing.func_176740_k().equals((Object)facing.func_176740_k())) {
            int slotIndex;
            int n = slotIndex = blockFacing.equals((Object)facing) ? 0 : 1;
            if (te.hasCellInSlot(slotIndex)) {
                ItemStack cell = te.removeCellFromSlot(slotIndex);
                if (player.field_71071_by.func_70441_a(cell)) {
                    player.func_184185_a(SoundEvents.field_187638_cR, 1.0f, 1.0f);
                } else {
                    BlockHammerBase.spawnAsEntity(world, pos.func_177972_a(facing), cell);
                }
                world.func_184133_a(player, pos, SoundEvents.field_187614_cJ, SoundCategory.PLAYERS, 0.5f, 0.6f);
                world.func_184138_a(pos, state, state, 3);
                if (!player.field_70170_p.field_72995_K) {
                    BlockUseCriterion.trigger((EntityPlayerMP)player, this.func_176221_a(state, (IBlockAccess)world, pos), ItemStack.field_190927_a);
                }
                return true;
            }
            if (heldStack.func_77973_b() instanceof ItemCellMagmatic) {
                te.putCellInSlot(heldStack, slotIndex);
                player.func_184611_a(hand, ItemStack.field_190927_a);
                world.func_184133_a(player, pos, SoundEvents.field_187614_cJ, SoundCategory.PLAYERS, 0.5f, 0.5f);
                world.func_184138_a(pos, state, state, 3);
                if (!player.field_70170_p.field_72995_K) {
                    BlockUseCriterion.trigger((EntityPlayerMP)player, this.func_176221_a(state, (IBlockAccess)world, pos), heldStack);
                }
                return true;
            }
        } else if (heldStack.func_77973_b() instanceof ItemVentPlate) {
            if (Rotation.CLOCKWISE_90.func_185831_a(blockFacing).equals((Object)facing) && !te.hasPlate(EnumHammerPlate.EAST)) {
                te.attachPlate(EnumHammerPlate.EAST);
                world.func_184138_a(pos, state, state, 3);
                if (!player.field_70170_p.field_72995_K) {
                    BlockUseCriterion.trigger((EntityPlayerMP)player, this.func_176221_a(state, (IBlockAccess)world, pos), heldStack);
                }
                heldStack.func_190918_g(1);
                return true;
            }
            if (Rotation.COUNTERCLOCKWISE_90.func_185831_a(blockFacing).equals((Object)facing) && !te.hasPlate(EnumHammerPlate.WEST)) {
                te.attachPlate(EnumHammerPlate.WEST);
                world.func_184138_a(pos, state, state, 3);
                if (!player.field_70170_p.field_72995_K) {
                    BlockUseCriterion.trigger((EntityPlayerMP)player, this.func_176221_a(state, (IBlockAccess)world, pos), heldStack);
                }
                heldStack.func_190918_g(1);
                return true;
            }
        }
        return BlockInteraction.attemptInteraction(world, state.func_185899_b((IBlockAccess)world, pos), pos, player, hand, facing, hitX, hitY, hitZ);
    }

    public static void spawnAsEntity(World worldIn, BlockPos pos, ItemStack stack) {
        if (!worldIn.field_72995_K && !stack.func_190926_b() && worldIn.func_82736_K().func_82766_b("doTileDrops") && !worldIn.restoringBlockSnapshots) {
            if (((Boolean)captureDrops.get()).booleanValue()) {
                ((NonNullList)capturedDrops.get()).add((Object)stack);
                return;
            }
            EntityItem entityitem = new EntityItem(worldIn, (double)pos.func_177958_n() + 0.5, (double)pos.func_177956_o() + 0.5, (double)pos.func_177952_p() + 0.5, stack);
            entityitem.func_174869_p();
            worldIn.func_72838_d((Entity)entityitem);
        }
    }

    @Override
    public BlockInteraction[] getPotentialInteractions(IBlockState state, EnumFacing face, Collection<Capability> capabilities) {
        return (BlockInteraction[])Arrays.stream(interactions).filter(interaction -> interaction.isPotentialInteraction(state, (EnumFacing)state.func_177229_b((IProperty)propFacing), face, capabilities)).toArray(BlockInteraction[]::new);
    }

    public BlockRenderLayer func_180664_k() {
        return BlockRenderLayer.CUTOUT;
    }

    public boolean hasTileEntity(IBlockState state) {
        return true;
    }

    public TileEntity func_149915_a(World world, int meta) {
        return new TileEntityHammerBase();
    }

    protected BlockStateContainer func_180661_e() {
        return new BlockStateContainer((Block)this, new IProperty[]{propFacing, propCell1, propCell1Charged, propCell2, propCell2Charged, EnumHammerPlate.EAST.prop, EnumHammerPlate.WEST.prop, EnumHammerConfig.propE, EnumHammerConfig.propW});
    }

    public IBlockState func_180642_a(World worldIn, BlockPos pos, EnumFacing facing, float hitX, float hitY, float hitZ, int meta, EntityLivingBase placer) {
        return this.func_176223_P().func_177226_a((IProperty)propFacing, (Comparable)placer.func_174811_aO().func_176734_d());
    }

    public IBlockState func_176203_a(int meta) {
        return this.func_176223_P().func_177226_a((IProperty)propFacing, (Comparable)EnumFacing.func_176731_b((int)(meta & 0xF)));
    }

    public int func_176201_c(IBlockState state) {
        return ((EnumFacing)state.func_177229_b((IProperty)propFacing)).func_176736_b();
    }

    public IBlockState func_185499_a(IBlockState state, Rotation rot) {
        return state.func_177226_a((IProperty)propFacing, (Comparable)rot.func_185831_a((EnumFacing)state.func_177229_b((IProperty)propFacing)));
    }

    public IBlockState func_185471_a(IBlockState state, Mirror mirrorIn) {
        return state.func_185907_a(mirrorIn.func_185800_a((EnumFacing)state.func_177229_b((IProperty)propFacing)));
    }

    static {
        interactions = new BlockInteraction[]{new BlockInteraction(Capability.pry, 1, EnumHammerPlate.EAST.face, 5.0f, 11.0f, 9.0f, 11.0f, EnumHammerPlate.EAST.prop, true, (world, pos, blockState, player, hand, hitFace) -> BlockHammerBase.removePlate(world, pos, blockState, player, EnumHammerPlate.EAST, hitFace)), new BlockInteraction(Capability.pry, 1, EnumHammerPlate.WEST.face, 5.0f, 11.0f, 9.0f, 11.0f, EnumHammerPlate.WEST.prop, true, (world, pos, blockState, player, hand, hitFace) -> BlockHammerBase.removePlate(world, pos, blockState, player, EnumHammerPlate.WEST, hitFace)), new BlockInteraction(Capability.hammer, 1, EnumFacing.EAST, 6.0f, 10.0f, 2.0f, 9.0f, EnumHammerPlate.EAST.prop, false, (world, pos, blockState, player, hand, hitFace) -> BlockHammerBase.reconfigure(world, pos, blockState, player, EnumFacing.EAST)), new BlockInteraction(Capability.hammer, 1, EnumFacing.WEST, 6.0f, 10.0f, 2.0f, 9.0f, EnumHammerPlate.WEST.prop, false, (world, pos, blockState, player, hand, hitFace) -> BlockHammerBase.reconfigure(world, pos, blockState, player, EnumFacing.WEST))};
    }
}

