/*
 * Decompiled with CFR 0.152.
 */
package se.mickelus.tetra.blocks.workbench;

import java.util.Arrays;
import java.util.HashMap;
import java.util.Map;
import javax.annotation.Nullable;
import net.minecraft.block.state.IBlockState;
import net.minecraft.entity.Entity;
import net.minecraft.entity.item.EntityItem;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.inventory.IInventory;
import net.minecraft.inventory.ItemStackHelper;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.network.NetworkManager;
import net.minecraft.network.play.server.SPacketUpdateTileEntity;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.NonNullList;
import org.apache.commons.lang3.ArrayUtils;
import se.mickelus.tetra.NBTHelper;
import se.mickelus.tetra.blocks.workbench.BlockWorkbench;
import se.mickelus.tetra.blocks.workbench.CraftWorkbenchPacket;
import se.mickelus.tetra.blocks.workbench.TweakWorkbenchPacket;
import se.mickelus.tetra.blocks.workbench.UpdateWorkbenchPacket;
import se.mickelus.tetra.blocks.workbench.action.RepairAction;
import se.mickelus.tetra.blocks.workbench.action.WorkbenchAction;
import se.mickelus.tetra.blocks.workbench.action.WorkbenchActionPacket;
import se.mickelus.tetra.capabilities.Capability;
import se.mickelus.tetra.capabilities.CapabilityHelper;
import se.mickelus.tetra.items.ItemModular;
import se.mickelus.tetra.module.ItemUpgradeRegistry;
import se.mickelus.tetra.module.schema.UpgradeSchema;
import se.mickelus.tetra.network.PacketHandler;
import se.mickelus.tetra.util.CastOptional;

public class TileEntityWorkbench
extends TileEntity
implements IInventory {
    private static final String STACKS_KEY = "stacks";
    private static final String SLOT_KEY = "slot";
    private static final String CURRENT_SLOT_KEY = "current_slot";
    private static final String SCHEMA_KEY = "schema";
    public static final int MATERIAL_SLOT_COUNT = 4;
    private NonNullList<ItemStack> stacks;
    private ItemStack previousTarget = ItemStack.field_190927_a;
    private UpgradeSchema currentSchema;
    private String currentSlot;
    private Map<String, Runnable> changeListeners;
    private static WorkbenchAction[] actions = new WorkbenchAction[]{new RepairAction()};

    public TileEntityWorkbench() {
        this.stacks = NonNullList.func_191197_a((int)4, (Object)ItemStack.field_190927_a);
        this.changeListeners = new HashMap<String, Runnable>();
    }

    public static void initConfigActions(WorkbenchAction[] actions) {
        TileEntityWorkbench.actions = (WorkbenchAction[])ArrayUtils.addAll((Object[])TileEntityWorkbench.actions, (Object[])actions);
    }

    public WorkbenchAction[] getAvailableActions(EntityPlayer player) {
        ItemStack itemStack = this.getTargetItemStack();
        return (WorkbenchAction[])Arrays.stream(actions).filter(action -> action.canPerformOn(player, itemStack)).toArray(WorkbenchAction[]::new);
    }

    public void performAction(EntityPlayer player, String actionKey) {
        if (this.field_145850_b.field_72995_K) {
            PacketHandler.sendToServer(new WorkbenchActionPacket(this.field_174879_c, actionKey));
            return;
        }
        IBlockState blockState = this.field_145850_b.func_180495_p(this.func_174877_v());
        ItemStack targetStack = this.getTargetItemStack();
        Arrays.stream(actions).filter(action -> action.getKey().equals(actionKey)).findFirst().filter(action -> action.canPerformOn(player, targetStack)).filter(action -> this.checkActionCapabilities(player, (WorkbenchAction)action, targetStack)).ifPresent(action -> {
            for (Capability capability : action.getRequiredCapabilitiesFor(targetStack)) {
                int requiredLevel = action.getCapabilityLevel(targetStack, capability);
                ItemStack providingStack = CapabilityHelper.getProvidingItemStack(capability, requiredLevel, player);
                if (!providingStack.func_190926_b()) {
                    if (!(providingStack.func_77973_b() instanceof ItemModular)) continue;
                    ((ItemModular)providingStack.func_77973_b()).onActionConsumeCapability(providingStack, targetStack, player, capability, requiredLevel, true);
                    continue;
                }
                if (!(this.func_145838_q() instanceof BlockWorkbench)) continue;
                ((BlockWorkbench)this.func_145838_q()).onActionConsumeCapability(this.field_145850_b, this.func_174877_v(), blockState, targetStack, player, true);
            }
            action.perform(player, targetStack, this);
        });
    }

    private boolean checkActionCapabilities(EntityPlayer player, WorkbenchAction action, ItemStack itemStack) {
        return Arrays.stream(action.getRequiredCapabilitiesFor(itemStack)).allMatch(capability -> CapabilityHelper.getCombinedCapabilityLevel(player, this.func_145831_w(), this.func_174877_v(), this.field_145850_b.func_180495_p(this.func_174877_v()), capability) >= action.getCapabilityLevel(itemStack, (Capability)((Object)capability)));
    }

    public UpgradeSchema getCurrentSchema() {
        return this.currentSchema;
    }

    public void setCurrentSchema(UpgradeSchema schema, String currentSlot) {
        this.currentSchema = schema;
        this.currentSlot = currentSlot;
        this.changeListeners.values().forEach(Runnable::run);
        this.sync();
    }

    public void clearSchema() {
        this.setCurrentSchema(null, null);
    }

    public void update(UpgradeSchema currentSchema, String currentSlot, EntityPlayer player) {
        if (currentSchema == null && player != null) {
            this.emptyMaterialSlots(player);
        }
        this.currentSchema = currentSchema;
        this.currentSlot = currentSlot;
        this.sync();
    }

    public String getCurrentSlot() {
        return this.currentSlot;
    }

    private void sync() {
        if (this.field_145850_b.field_72995_K) {
            PacketHandler.sendToServer(new UpdateWorkbenchPacket(this.field_174879_c, this.currentSchema, this.currentSlot));
        } else {
            this.field_145850_b.func_184138_a(this.field_174879_c, this.func_145838_q().func_176223_P(), this.func_145838_q().func_176223_P(), 3);
            this.func_70296_d();
        }
    }

    public ItemStack getTargetItemStack() {
        ItemStack stack = this.func_70301_a(0);
        if (stack == null) {
            return ItemStack.field_190927_a;
        }
        ItemStack placeholder = ItemUpgradeRegistry.instance.getReplacement(stack);
        if (!placeholder.func_190926_b()) {
            return placeholder;
        }
        return stack;
    }

    public ItemStack[] getMaterials() {
        return this.stacks.subList(1, 4).toArray(new ItemStack[3]);
    }

    public void initiateCrafting(EntityPlayer player) {
        if (this.field_145850_b.field_72995_K) {
            PacketHandler.sendToServer(new CraftWorkbenchPacket(this.field_174879_c));
        }
        this.craft(player);
        this.sync();
    }

    public void craft(EntityPlayer player) {
        ItemStack targetStack = this.getTargetItemStack();
        ItemStack upgradedStack = ItemStack.field_190927_a;
        IBlockState blockState = this.field_145850_b.func_180495_p(this.func_174877_v());
        int[] availableCapabilities = CapabilityHelper.getCombinedCapabilityLevels(player, this.func_145831_w(), this.func_174877_v(), blockState);
        ItemStack[] materialsCopy = (ItemStack[])Arrays.stream(this.getMaterials()).map(ItemStack::func_77946_l).toArray(ItemStack[]::new);
        if (this.currentSchema != null && this.currentSchema.canApplyUpgrade(player, targetStack, this.getMaterials(), this.currentSlot, availableCapabilities)) {
            upgradedStack = this.currentSchema.applyUpgrade(targetStack, this.getMaterials(), true, this.currentSlot, player);
            if (upgradedStack.func_77973_b() instanceof ItemModular) {
                ((ItemModular)upgradedStack.func_77973_b()).assemble(upgradedStack, this.field_145850_b);
            }
            for (Capability capability : this.currentSchema.getRequiredCapabilities(targetStack, materialsCopy)) {
                int requiredLevel;
                ItemStack providingStack = CapabilityHelper.getProvidingItemStack(capability, requiredLevel = this.currentSchema.getRequiredCapabilityLevel(targetStack, materialsCopy, capability), player);
                if (!providingStack.func_190926_b()) {
                    if (!(providingStack.func_77973_b() instanceof ItemModular)) continue;
                    upgradedStack = ((ItemModular)providingStack.func_77973_b()).onCraftConsumeCapability(providingStack, upgradedStack, player, capability, requiredLevel, true);
                    continue;
                }
                if (!(this.func_145838_q() instanceof BlockWorkbench)) continue;
                upgradedStack = ((BlockWorkbench)this.func_145838_q()).onCraftConsumeCapability(this.field_145850_b, this.func_174877_v(), blockState, upgradedStack, player, true);
            }
            int xpCost = this.currentSchema.getExperienceCost(targetStack, materialsCopy, this.getCurrentSlot());
            if (xpCost > 0) {
                player.func_82242_a(-xpCost);
            }
        }
        this.emptyMaterialSlots(player);
        this.func_70299_a(0, upgradedStack);
    }

    public void applyTweaks(EntityPlayer player, String slot, Map<String, Integer> tweaks) {
        if (this.field_145850_b.field_72995_K) {
            PacketHandler.sendToServer(new TweakWorkbenchPacket(this.field_174879_c, slot, tweaks));
        }
        this.tweak(player, slot, tweaks);
        this.sync();
    }

    public void tweak(EntityPlayer player, String slot, Map<String, Integer> tweaks) {
        ItemStack tweakedStack = this.getTargetItemStack().func_77946_l();
        CastOptional.cast(tweakedStack.func_77973_b(), ItemModular.class).ifPresent(item -> item.tweak(tweakedStack, slot, tweaks));
        this.func_70299_a(0, tweakedStack);
    }

    public void addChangeListener(String key, Runnable runnable) {
        this.changeListeners.put(key, runnable);
    }

    public void removeChangeListener(String key) {
        this.changeListeners.remove(key);
    }

    public void func_70296_d() {
        super.func_70296_d();
        if (this.field_145850_b.field_72995_K) {
            this.changeListeners.values().forEach(Runnable::run);
        }
    }

    @Nullable
    public SPacketUpdateTileEntity func_189518_D_() {
        return new SPacketUpdateTileEntity(this.field_174879_c, 0, this.func_189517_E_());
    }

    public NBTTagCompound func_189517_E_() {
        return this.func_189515_b(new NBTTagCompound());
    }

    public void handleUpdateTag(NBTTagCompound tag) {
        super.handleUpdateTag(tag);
    }

    public void onDataPacket(NetworkManager net, SPacketUpdateTileEntity packet) {
        this.func_145839_a(packet.func_148857_g());
    }

    public void func_145839_a(NBTTagCompound compound) {
        super.func_145839_a(compound);
        NBTHelper.readItemStacks(compound, this.stacks);
        String schemaKey = compound.func_74779_i(SCHEMA_KEY);
        this.currentSchema = ItemUpgradeRegistry.instance.getSchema(schemaKey);
        if (compound.func_74764_b(CURRENT_SLOT_KEY)) {
            this.currentSlot = compound.func_74779_i(CURRENT_SLOT_KEY);
        }
        if (this.field_145850_b != null && this.field_145850_b.field_72995_K) {
            this.changeListeners.values().forEach(Runnable::run);
        }
    }

    public NBTTagCompound func_189515_b(NBTTagCompound compound) {
        super.func_189515_b(compound);
        NBTHelper.writeItemStacks(this.stacks, compound);
        if (this.currentSchema != null) {
            compound.func_74778_a(SCHEMA_KEY, this.currentSchema.getKey());
        }
        if (this.currentSlot != null) {
            compound.func_74778_a(CURRENT_SLOT_KEY, this.currentSlot);
        }
        return compound;
    }

    private void emptyMaterialSlots(EntityPlayer player) {
        for (int i = 1; i < this.stacks.size(); ++i) {
            this.transferStackToPlayer(player, i);
        }
        this.func_70296_d();
    }

    private void emptyMaterialSlots() {
        if (!this.field_145850_b.field_72995_K) {
            for (int i = 1; i < this.stacks.size(); ++i) {
                ItemStack materialStack = this.func_70304_b(i);
                if (materialStack.func_190926_b()) continue;
                EntityItem entityitem = new EntityItem(this.field_145850_b, (double)this.field_174879_c.func_177958_n() + 0.5, (double)this.field_174879_c.func_177956_o() + 1.1, (double)this.field_174879_c.func_177952_p() + 0.5, materialStack);
                entityitem.func_174869_p();
                this.field_145850_b.func_72838_d((Entity)entityitem);
            }
        } else {
            for (int i = 1; i < this.stacks.size(); ++i) {
                this.func_70304_b(i);
            }
        }
    }

    private void transferStackToPlayer(EntityPlayer player, int index) {
        ItemStack itemStack = this.func_70301_a(index);
        if (!itemStack.func_190926_b() && !player.field_71071_by.func_70441_a(itemStack)) {
            player.func_71019_a(itemStack, false);
        }
    }

    public int func_70302_i_() {
        if (this.currentSchema != null) {
            return this.currentSchema.getNumMaterialSlots() + 1;
        }
        return 1;
    }

    public boolean func_191420_l() {
        for (ItemStack itemstack : this.stacks) {
            if (itemstack.func_190926_b()) continue;
            return false;
        }
        return true;
    }

    @Nullable
    public ItemStack func_70301_a(int index) {
        return (ItemStack)this.stacks.get(index);
    }

    @Nullable
    public ItemStack func_70298_a(int index, int count) {
        ItemStack itemstack = ItemStackHelper.func_188382_a(this.stacks, (int)index, (int)count);
        if (!itemstack.func_190926_b()) {
            this.func_70296_d();
        }
        return itemstack;
    }

    @Nullable
    public ItemStack func_70304_b(int index) {
        ItemStack itemstack = ItemStackHelper.func_188383_a(this.stacks, (int)index);
        if (!itemstack.func_190926_b()) {
            this.func_70296_d();
        }
        return itemstack;
    }

    public void func_70299_a(int index, @Nullable ItemStack itemStack) {
        if (index == 0 && (itemStack.func_190926_b() || !ItemStack.func_77989_b((ItemStack)this.getTargetItemStack(), (ItemStack)itemStack))) {
            this.currentSchema = null;
            this.currentSlot = null;
            this.emptyMaterialSlots();
        }
        this.stacks.set(index, (Object)itemStack);
        if (!itemStack.func_190926_b() && itemStack.func_190916_E() > this.func_70297_j_()) {
            itemStack.func_190920_e(this.func_70297_j_());
        }
    }

    public int func_70297_j_() {
        return 64;
    }

    public boolean func_70300_a(EntityPlayer player) {
        return true;
    }

    public void func_174889_b(EntityPlayer player) {
    }

    public void func_174886_c(EntityPlayer player) {
    }

    public boolean func_94041_b(int index, ItemStack stack) {
        if (index == 0) {
            return true;
        }
        if (this.currentSchema != null) {
            return this.currentSchema.acceptsMaterial(this.getTargetItemStack(), index - 1, stack);
        }
        return false;
    }

    public int func_174887_a_(int id) {
        return 0;
    }

    public void func_174885_b(int id, int value) {
    }

    public int func_174890_g() {
        return 0;
    }

    public void func_174888_l() {
        this.stacks.clear();
    }

    public String func_70005_c_() {
        return "workbench";
    }

    public boolean func_145818_k_() {
        return false;
    }
}

