/*
 * Decompiled with CFR 0.152.
 */
package se.mickelus.tetra.blocks.workbench;

import io.netty.buffer.ByteBuf;
import java.io.IOException;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.util.math.BlockPos;
import se.mickelus.tetra.blocks.workbench.TileEntityWorkbench;
import se.mickelus.tetra.module.ItemUpgradeRegistry;
import se.mickelus.tetra.module.schema.UpgradeSchema;
import se.mickelus.tetra.network.AbstractPacket;

public class UpdateWorkbenchPacket
extends AbstractPacket {
    private BlockPos pos;
    private UpgradeSchema schema;
    private String selectedSlot;

    public UpdateWorkbenchPacket() {
    }

    public UpdateWorkbenchPacket(BlockPos pos, UpgradeSchema schema, String selectedSlot) {
        this.pos = pos;
        this.schema = schema;
        this.selectedSlot = selectedSlot;
    }

    @Override
    public void toBytes(ByteBuf buffer) {
        buffer.writeInt(this.pos.func_177958_n());
        buffer.writeInt(this.pos.func_177956_o());
        buffer.writeInt(this.pos.func_177952_p());
        try {
            if (this.schema != null) {
                UpdateWorkbenchPacket.writeString(this.schema.getKey(), buffer);
            } else {
                UpdateWorkbenchPacket.writeString("", buffer);
            }
            if (this.selectedSlot != null) {
                UpdateWorkbenchPacket.writeString(this.selectedSlot, buffer);
            } else {
                UpdateWorkbenchPacket.writeString("", buffer);
            }
        }
        catch (IOException exception) {
            System.err.println("An error occurred when writing schema name to packet buffer");
        }
    }

    @Override
    public void fromBytes(ByteBuf buffer) {
        int x = buffer.readInt();
        int y = buffer.readInt();
        int z = buffer.readInt();
        this.pos = new BlockPos(x, y, z);
        try {
            String schemaKey = UpdateWorkbenchPacket.readString(buffer);
            this.schema = ItemUpgradeRegistry.instance.getSchema(schemaKey);
            this.selectedSlot = UpdateWorkbenchPacket.readString(buffer);
            if ("".equals(this.selectedSlot)) {
                this.selectedSlot = null;
            }
        }
        catch (IOException exception) {
            System.err.println("An error occurred when reading schema name from packet buffer");
        }
    }

    @Override
    public void handle(EntityPlayer player) {
        TileEntityWorkbench workbench = (TileEntityWorkbench)player.field_70170_p.func_175625_s(this.pos);
        if (workbench != null) {
            workbench.update(this.schema, this.selectedSlot, player);
        }
    }
}

