/*
 * Decompiled with CFR 0.152.
 */
package se.mickelus.tetra.blocks.workbench.gui;

import net.minecraft.client.resources.I18n;
import net.minecraft.item.ItemStack;
import se.mickelus.tetra.blocks.workbench.gui.GuiCapabilityRequirementList;
import se.mickelus.tetra.blocks.workbench.gui.GuiExperience;
import se.mickelus.tetra.gui.GuiButton;
import se.mickelus.tetra.gui.GuiElement;
import se.mickelus.tetra.gui.GuiString;
import se.mickelus.tetra.gui.GuiStringSmall;
import se.mickelus.tetra.gui.GuiTextSmall;
import se.mickelus.tetra.gui.GuiTexture;
import se.mickelus.tetra.gui.impl.GuiMagicUsage;
import se.mickelus.tetra.module.data.GlyphData;
import se.mickelus.tetra.module.schema.SchemaType;
import se.mickelus.tetra.module.schema.UpgradeSchema;

public class GuiSchemaDetail
extends GuiElement {
    private static final String WORKBENCH_TEXTURE = "textures/gui/workbench.png";
    private static final int MAX_NUM_SLOTS = 2;
    private UpgradeSchema schema;
    private GuiElement glyph;
    private GuiString title;
    private GuiTextSmall description;
    private GuiButton craftButton;
    private GuiString[] slotNames;
    private GuiString[] slotQuantities;
    private GuiTexture[] slotBorders;
    private GuiMagicUsage magicCapacity;
    private GuiCapabilityRequirementList capabilityIndicatorList;
    private GuiExperience experienceIndicator;

    public GuiSchemaDetail(int x, int y, Runnable backListener, Runnable craftListener) {
        super(x, y, 224, 67);
        this.addChild(new GuiButton(-4, this.height - 2, 40, 8, "< " + I18n.func_135052_a((String)"workbench.schema_detail.back", (Object[])new Object[0]), backListener));
        this.glyph = new GuiElement(3, 3, 16, 16);
        this.addChild(this.glyph);
        this.title = new GuiString(19, 6, 100, "");
        this.addChild(this.title);
        this.description = new GuiTextSmall(5, 17, 105, "");
        this.addChild(this.description);
        this.slotNames = new GuiString[2];
        this.slotQuantities = new GuiString[2];
        this.slotBorders = new GuiTexture[2];
        for (int i = 0; i < 2; ++i) {
            this.slotNames[i] = new GuiString(140, 9 + i * 17, "");
            this.slotNames[i].setVisible(false);
            this.addChild(this.slotNames[i]);
            this.slotQuantities[i] = new GuiStringSmall(139, 18 + i * 18, "");
            this.slotQuantities[i].setVisible(false);
            this.addChild(this.slotQuantities[i]);
            this.slotBorders[i] = new GuiTexture(121, 5 + i * 18, 16, 16, 52, 16, WORKBENCH_TEXTURE);
            this.slotBorders[i].setVisible(false);
            this.addChild(this.slotBorders[i]);
        }
        this.magicCapacity = new GuiMagicUsage(121, 28, 80);
        this.addChild(this.magicCapacity);
        this.capabilityIndicatorList = new GuiCapabilityRequirementList(80, 39);
        this.addChild(this.capabilityIndicatorList);
        this.experienceIndicator = new GuiExperience(170, 42, "workbench.schema_detail.experience");
        this.addChild(this.experienceIndicator);
        this.craftButton = new GuiButton(138, 44, 30, 8, I18n.func_135052_a((String)"workbench.schema_detail.craft", (Object[])new Object[0]), craftListener);
        this.addChild(this.craftButton);
    }

    public void update(UpgradeSchema schema, ItemStack itemStack, String slot, ItemStack[] materials, int[] availableCapabilities, int playerLevel) {
        int i;
        GuiTexture glyphTexture;
        this.schema = schema;
        this.title.setString(schema.getName());
        this.title.setColor(schema.getRarity().tint);
        this.description.setString(schema.getDescription(itemStack));
        this.glyph.clearChildren();
        GlyphData glyphData = schema.getGlyph();
        GuiTexture border = null;
        if (schema.getType() == SchemaType.major) {
            border = new GuiTexture(0, 2, 16, 9, 52, 3, WORKBENCH_TEXTURE);
            glyphTexture = new GuiTexture(-1, -1, 16, 16, glyphData.textureX, glyphData.textureY, glyphData.textureLocation);
        } else if (schema.getType() == SchemaType.minor) {
            border = new GuiTexture(2, 1, 11, 11, 68, 0, WORKBENCH_TEXTURE);
            glyphTexture = new GuiTexture(4, 3, 8, 8, glyphData.textureX, glyphData.textureY, glyphData.textureLocation);
        } else if (schema.getType() == SchemaType.improvement) {
            border = new GuiTexture(0, 2, 16, 9, 52, 3, WORKBENCH_TEXTURE);
            glyphTexture = new GuiTexture(-1, -1, 16, 16, glyphData.textureX, glyphData.textureY, glyphData.textureLocation);
        } else {
            glyphTexture = new GuiTexture(-1, -1, 16, 16, glyphData.textureX, glyphData.textureY, glyphData.textureLocation);
        }
        if (border != null) {
            border.setOpacity(0.3f);
            border.setColor(schema.getRarity().tint);
            this.glyph.addChild(border);
        }
        glyphTexture.setColor(schema.getRarity().tint);
        this.glyph.addChild(glyphTexture);
        if (schema.getType() == SchemaType.improvement) {
            this.glyph.addChild(new GuiTexture(7, 7, 7, 7, 68, 16, WORKBENCH_TEXTURE));
        }
        for (i = 0; i < schema.getNumMaterialSlots(); ++i) {
            this.slotNames[i].setString(schema.getSlotName(itemStack, i));
            this.slotNames[i].setVisible(true);
            this.slotBorders[i].setVisible(true);
            if (schema.acceptsMaterial(itemStack, i, materials[i])) {
                int requiredCount = schema.getRequiredQuantity(itemStack, i, materials[i]);
                if (!materials[i].func_190926_b() && requiredCount > 1) {
                    this.slotQuantities[i].setString("/" + requiredCount);
                    this.slotQuantities[i].setColor(materials[i].func_190916_E() < requiredCount ? 0xFF5555 : 0xFFFFFF);
                }
                this.slotQuantities[i].setVisible(!materials[i].func_190926_b() && requiredCount > 1);
                continue;
            }
            this.slotQuantities[i].setVisible(false);
        }
        for (i = schema.getNumMaterialSlots(); i < 2; ++i) {
            this.slotNames[i].setVisible(false);
            this.slotQuantities[i].setVisible(false);
            this.slotBorders[i].setVisible(false);
        }
        this.capabilityIndicatorList.update(schema, itemStack, materials, availableCapabilities);
        int xpCost = schema.getExperienceCost(itemStack, materials, slot);
        this.experienceIndicator.setVisible(xpCost > 0);
        if (xpCost > 0) {
            this.experienceIndicator.update(xpCost, xpCost <= playerLevel);
        }
    }

    public void updateMagicCapacity(UpgradeSchema schema, String slot, ItemStack itemStack, ItemStack previewStack) {
        if (slot != null && (schema != null && SchemaType.major.equals((Object)schema.getType()) && this.magicCapacity.providesCapacity(itemStack, previewStack, slot) || this.magicCapacity.hasChanged(itemStack, previewStack, slot))) {
            this.magicCapacity.update(itemStack, previewStack, slot);
            this.magicCapacity.setVisible(true);
        } else {
            this.magicCapacity.setVisible(false);
        }
    }

    public void updateAvailableCapabilities(int[] availableCapabilities) {
        this.capabilityIndicatorList.updateAvailableCapabilities(availableCapabilities);
    }

    public void toggleButton(boolean enabled) {
        this.craftButton.setEnabled(enabled);
    }
}

