/*
 * Decompiled with CFR 0.152.
 */
package se.mickelus.tetra.blocks.workbench.gui;

import java.io.IOException;
import java.util.Arrays;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.stream.Collectors;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.FontRenderer;
import net.minecraft.client.gui.inventory.GuiContainer;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.inventory.Container;
import net.minecraft.inventory.Slot;
import net.minecraft.item.ItemStack;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.World;
import net.minecraftforge.fml.client.config.GuiUtils;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;
import se.mickelus.tetra.blocks.workbench.ContainerWorkbench;
import se.mickelus.tetra.blocks.workbench.TileEntityWorkbench;
import se.mickelus.tetra.blocks.workbench.gui.GuiActionList;
import se.mickelus.tetra.blocks.workbench.gui.GuiIntegrityBar;
import se.mickelus.tetra.blocks.workbench.gui.GuiInventoryInfo;
import se.mickelus.tetra.blocks.workbench.gui.GuiModuleList;
import se.mickelus.tetra.blocks.workbench.gui.GuiSlotDetail;
import se.mickelus.tetra.blocks.workbench.gui.GuiStatGroup;
import se.mickelus.tetra.capabilities.CapabilityHelper;
import se.mickelus.tetra.gui.GuiAttachment;
import se.mickelus.tetra.gui.GuiElement;
import se.mickelus.tetra.gui.GuiTexture;
import se.mickelus.tetra.gui.GuiTextureOffset;
import se.mickelus.tetra.items.ItemModular;
import se.mickelus.tetra.module.schema.UpgradeSchema;
import se.mickelus.tetra.util.CastOptional;

@SideOnly(value=Side.CLIENT)
public class GuiWorkbench
extends GuiContainer {
    private static GuiWorkbench instance;
    private static final String WORKBENCH_TEXTURE = "textures/gui/workbench.png";
    private static final String INVENTORY_TEXTURE = "textures/gui/player-inventory.png";
    private EntityPlayer viewingPlayer;
    private final TileEntityWorkbench tileEntity;
    private final ContainerWorkbench container;
    private GuiElement defaultGui;
    private GuiModuleList moduleList;
    private GuiStatGroup statGroup;
    private GuiIntegrityBar integrityBar;
    private GuiActionList actionList;
    private final GuiInventoryInfo inventoryInfo;
    private String selectedSlot;
    private int previewMaterialSlot = -1;
    private GuiSlotDetail slotDetail;
    private ItemStack currentTarget = ItemStack.field_190927_a;
    private ItemStack currentPreview = ItemStack.field_190927_a;
    private UpgradeSchema currentSchema = null;
    private ItemStack[] currentMaterials;
    private boolean hadItem = false;

    public GuiWorkbench(ContainerWorkbench container, TileEntityWorkbench tileEntity, EntityPlayer viewingPlayer) {
        super((Container)container);
        this.field_146291_p = false;
        this.field_146999_f = 320;
        this.field_147000_g = 240;
        this.tileEntity = tileEntity;
        this.container = container;
        this.viewingPlayer = viewingPlayer;
        this.field_146289_q = Minecraft.func_71410_x().field_71466_p;
        this.defaultGui = new GuiElement(0, 0, this.field_146999_f, this.field_147000_g);
        this.defaultGui.addChild(new GuiTextureOffset(134, 40, 51, 51, WORKBENCH_TEXTURE));
        this.defaultGui.addChild(new GuiTexture(72, 153, 179, 106, INVENTORY_TEXTURE));
        this.moduleList = new GuiModuleList(164, 49, this::selectSlot, this::updateSlotHoverPreview);
        this.defaultGui.addChild(this.moduleList);
        this.statGroup = new GuiStatGroup(60, 0);
        this.defaultGui.addChild(this.statGroup);
        this.integrityBar = new GuiIntegrityBar(160, 90);
        this.defaultGui.addChild(this.integrityBar);
        this.inventoryInfo = new GuiInventoryInfo(84, 164, viewingPlayer);
        this.defaultGui.addChild(this.inventoryInfo);
        this.actionList = new GuiActionList(0, 120);
        this.actionList.setAttachmentAnchor(GuiAttachment.topCenter);
        this.actionList.setAttachmentPoint(GuiAttachment.middleCenter);
        this.defaultGui.addChild(this.actionList);
        this.slotDetail = new GuiSlotDetail(46, 102, schema -> tileEntity.setCurrentSchema((UpgradeSchema)schema, this.selectedSlot), () -> this.selectSlot(null), this::craftUpgrade, this::previewTweaks, this::applyTweaks);
        this.defaultGui.addChild(this.slotDetail);
        tileEntity.addChangeListener("gui.workbench", this::onTileEntityChange);
        this.currentMaterials = new ItemStack[4];
        Arrays.fill(this.currentMaterials, ItemStack.field_190927_a);
        instance = this;
    }

    public void func_73863_a(int mouseX, int mouseY, float partialTicks) {
        this.func_146276_q_();
        super.func_73863_a(mouseX, mouseY, partialTicks);
        this.func_191948_b(mouseX, mouseY);
        this.func_146979_b(mouseX, mouseY);
    }

    protected void func_146976_a(float partialTicks, int mouseX, int mouseY) {
        int x = (this.field_146294_l - this.field_146999_f) / 2;
        int y = (this.field_146295_m - this.field_147000_g) / 2;
        this.defaultGui.draw(x, y, this.field_146294_l, this.field_146295_m, mouseX, mouseY, 1.0f);
    }

    protected void func_191948_b(int mouseX, int mouseY) {
        super.func_191948_b(mouseX, mouseY);
        List<String> tooltipLines = this.defaultGui.getTooltipLines();
        if (tooltipLines != null) {
            tooltipLines = tooltipLines.stream().map(line -> line.replace("\\n", "\n")).collect(Collectors.toList());
            GuiUtils.drawHoveringText(tooltipLines, (int)mouseX, (int)mouseY, (int)this.field_146294_l, (int)this.field_146295_m, (int)-1, (FontRenderer)this.field_146289_q);
        }
        this.updateMaterialHoverPreview();
    }

    protected void func_73864_a(int mouseX, int mouseY, int mouseButton) throws IOException {
        super.func_73864_a(mouseX, mouseY, mouseButton);
        this.defaultGui.onClick(mouseX, mouseY);
    }

    protected void func_146286_b(int mouseX, int mouseY, int state) {
        super.func_146286_b(mouseX, mouseY, state);
        this.defaultGui.mouseReleased(mouseX, mouseY);
    }

    private void selectSlot(String slotKey) {
        this.selectedSlot = slotKey;
        this.tileEntity.clearSchema();
        this.moduleList.setFocus(this.selectedSlot);
        if (this.selectedSlot != null) {
            this.slotDetail.onTileEntityChange(this.viewingPlayer, this.tileEntity, this.tileEntity.getTargetItemStack(), this.selectedSlot, this.tileEntity.getCurrentSchema());
        }
        this.slotDetail.setVisible(this.selectedSlot != null);
    }

    private void deselectSchema() {
        this.tileEntity.clearSchema();
    }

    private void craftUpgrade() {
        this.tileEntity.initiateCrafting(this.viewingPlayer);
    }

    private void previewTweaks(Map<String, Integer> tweakMap) {
        ItemStack previewStack = this.currentTarget.func_77946_l();
        CastOptional.cast(previewStack.func_77973_b(), ItemModular.class).map(item -> item.getModuleFromSlot(previewStack, this.selectedSlot)).ifPresent(module -> tweakMap.forEach((tweakKey, step) -> {
            if (module.hasTweak(previewStack, (String)tweakKey)) {
                module.setTweakStep(previewStack, (String)tweakKey, (int)step);
            }
        }));
        this.statGroup.update(this.currentTarget, previewStack, null, null, this.viewingPlayer);
    }

    private void applyTweaks(Map<String, Integer> tweakMap) {
        this.tileEntity.applyTweaks(this.viewingPlayer, this.selectedSlot, tweakMap);
    }

    private void onTileEntityChange() {
        boolean slotChanged;
        ItemStack newTarget = this.tileEntity.getTargetItemStack();
        ItemStack newPreview = ItemStack.field_190927_a;
        UpgradeSchema newSchema = this.tileEntity.getCurrentSchema();
        String currentSlot = this.tileEntity.getCurrentSlot();
        if (newTarget.func_77973_b() instanceof ItemModular && this.currentSchema != null) {
            newPreview = this.buildPreviewStack(this.currentSchema, newTarget, this.tileEntity.getMaterials());
        }
        boolean targetItemChanged = !ItemStack.func_77989_b((ItemStack)this.currentTarget, (ItemStack)newTarget);
        boolean previewChanged = !ItemStack.func_77989_b((ItemStack)this.currentPreview, (ItemStack)newPreview);
        boolean schemaChanged = !Objects.equals(this.currentSchema, newSchema);
        boolean materialsChanged = this.diffMaterials(this.tileEntity.getMaterials());
        this.currentPreview = newPreview;
        this.currentSchema = newSchema;
        if (targetItemChanged) {
            ItemStack.func_77989_b((ItemStack)this.currentTarget, (ItemStack)newTarget);
            this.currentTarget = newTarget.func_77946_l();
            this.selectedSlot = null;
        }
        boolean bl = slotChanged = !Objects.equals(this.selectedSlot, currentSlot);
        if (!this.currentTarget.func_190926_b() && currentSlot != null) {
            this.selectedSlot = currentSlot;
        }
        this.container.updateSlots();
        if (slotChanged || targetItemChanged) {
            this.actionList.updateActions(this.currentTarget, this.tileEntity.getAvailableActions(this.viewingPlayer), this.viewingPlayer, action -> this.tileEntity.performAction(this.viewingPlayer, action.getKey()));
        }
        if (targetItemChanged || previewChanged || schemaChanged || slotChanged || materialsChanged) {
            this.updateItemDisplay(this.currentTarget, this.currentPreview);
            if (this.currentTarget.func_77973_b() instanceof ItemModular) {
                this.slotDetail.onTileEntityChange(this.viewingPlayer, this.tileEntity, this.currentTarget, this.selectedSlot, this.currentSchema);
            }
        }
        this.inventoryInfo.update(this.currentSchema, this.currentTarget);
        if (!this.currentTarget.func_190926_b()) {
            if (!this.hadItem) {
                this.hadItem = true;
                if (targetItemChanged && currentSlot == null) {
                    this.itemShowAnimation();
                }
            }
        } else {
            this.hadItem = false;
        }
        if (!this.currentTarget.func_190926_b()) {
            if (this.currentSchema == null && this.selectedSlot == null) {
                this.actionList.setVisible(true);
                this.slotDetail.setVisible(false);
            } else if (this.currentTarget.func_77973_b() instanceof ItemModular) {
                this.actionList.setVisible(false);
                this.slotDetail.setVisible(this.selectedSlot != null);
            }
        } else {
            this.actionList.setVisible(false);
            this.slotDetail.setVisible(false);
        }
    }

    private boolean diffMaterials(ItemStack[] newMaterials) {
        int i;
        boolean isDiff = false;
        for (i = 0; i < newMaterials.length; ++i) {
            if (ItemStack.func_77989_b((ItemStack)newMaterials[i], (ItemStack)this.currentMaterials[i])) continue;
            isDiff = true;
            break;
        }
        for (i = 0; i < newMaterials.length; ++i) {
            this.currentMaterials[i] = newMaterials[i].func_77946_l();
        }
        return isDiff;
    }

    public void func_73876_c() {
        super.func_73876_c();
        World world = this.tileEntity.func_145831_w();
        BlockPos pos = this.tileEntity.func_174877_v();
        int[] availableCapabilities = CapabilityHelper.getCombinedCapabilityLevels(this.viewingPlayer, world, pos, world.func_180495_p(pos));
        this.inventoryInfo.update(this.tileEntity.getCurrentSchema(), this.currentTarget);
        if (this.tileEntity.getCurrentSchema() != null && this.slotDetail.isVisible()) {
            this.slotDetail.update(this.viewingPlayer, this.tileEntity, availableCapabilities);
        }
        if (this.actionList.isVisible()) {
            this.actionList.updateCapabilities(availableCapabilities);
        }
    }

    private void updateItemDisplay(ItemStack itemStack, ItemStack previewStack) {
        this.moduleList.update(itemStack, previewStack, this.selectedSlot);
        this.statGroup.update(itemStack, previewStack, null, null, this.viewingPlayer);
        this.integrityBar.setItemStack(itemStack, previewStack);
        this.slotDetail.updatePreview(this.currentSchema, this.selectedSlot, itemStack, previewStack);
    }

    private void itemShowAnimation() {
        this.moduleList.showAnimation();
        this.statGroup.showAnimation();
        this.integrityBar.showAnimation();
        this.actionList.showAnimation();
    }

    private void updateSlotHoverPreview(String slot, String improvement) {
        if (this.tileEntity.getCurrentSlot() == null) {
            ItemStack itemStack = this.tileEntity.getTargetItemStack();
            this.statGroup.update(itemStack, ItemStack.field_190927_a, slot, improvement, this.viewingPlayer);
        }
    }

    private void updateMaterialHoverPreview() {
        int newPreviewMaterialSlot = -1;
        Slot hoveredSlot = this.getSlotUnderMouse();
        UpgradeSchema currentSchema = this.tileEntity.getCurrentSchema();
        if (currentSchema != null && hoveredSlot != null && hoveredSlot.func_75216_d()) {
            newPreviewMaterialSlot = hoveredSlot.getSlotIndex();
        }
        if (newPreviewMaterialSlot != this.previewMaterialSlot) {
            ItemStack[] materials = this.tileEntity.getMaterials();
            if (newPreviewMaterialSlot != -1 && Arrays.stream(materials).allMatch(ItemStack::func_190926_b)) {
                ItemStack previewStack = this.buildPreviewStack(currentSchema, this.tileEntity.getTargetItemStack(), new ItemStack[]{hoveredSlot.func_75211_c()});
                this.updateItemDisplay(this.tileEntity.getTargetItemStack(), previewStack);
            } else {
                ItemStack previewStack = ItemStack.field_190927_a;
                if (currentSchema != null) {
                    previewStack = this.buildPreviewStack(currentSchema, this.tileEntity.getTargetItemStack(), materials);
                }
                this.updateItemDisplay(this.tileEntity.getTargetItemStack(), previewStack);
            }
            this.previewMaterialSlot = newPreviewMaterialSlot;
        }
    }

    private ItemStack buildPreviewStack(UpgradeSchema schema, ItemStack targetStack, ItemStack[] materials) {
        if (schema.isMaterialsValid(targetStack, materials)) {
            return schema.applyUpgrade(targetStack, materials, false, this.tileEntity.getCurrentSlot(), null);
        }
        return ItemStack.field_190927_a;
    }

    protected void func_73869_a(char typedChar, int keyCode) throws IOException {
        this.slotDetail.keyTyped(typedChar);
        super.func_73869_a(typedChar, keyCode);
    }
}

