/*
 * Decompiled with CFR 0.152.
 */
package se.mickelus.tetra.client.model;

import com.google.common.collect.ImmutableMap;
import com.google.common.collect.Maps;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import java.util.function.Function;
import java.util.stream.Collectors;
import net.minecraft.client.renderer.block.model.IBakedModel;
import net.minecraft.client.renderer.block.model.ItemCameraTransforms;
import net.minecraft.client.renderer.block.model.ModelBlock;
import net.minecraft.client.renderer.block.model.ModelRotation;
import net.minecraft.client.renderer.texture.TextureAtlasSprite;
import net.minecraft.client.renderer.vertex.VertexFormat;
import net.minecraft.util.ResourceLocation;
import net.minecraftforge.client.model.IModel;
import net.minecraftforge.client.model.PerspectiveMapWrapper;
import net.minecraftforge.client.model.SimpleModelState;
import net.minecraftforge.common.model.IModelState;
import se.mickelus.tetra.client.model.BakedWrapper;
import se.mickelus.tetra.client.model.ModularOverrideList;
import se.mickelus.tetra.module.ItemUpgradeRegistry;

public class ModularModel
implements IModel {
    private final ModelBlock modelBlock;

    public ModularModel(ModelBlock modelBlock) {
        this.modelBlock = modelBlock;
    }

    public Collection<ResourceLocation> getDependencies() {
        return Collections.EMPTY_LIST;
    }

    public Collection<ResourceLocation> getTextures() {
        return ItemUpgradeRegistry.instance.getAllModules().stream().flatMap(itemModule -> Arrays.stream(itemModule.getAllTextures())).collect(Collectors.toList());
    }

    public IBakedModel bake(IModelState state, VertexFormat format, Function<ResourceLocation, TextureAtlasSprite> bakedTextureGetter) {
        if (this.modelBlock == null) {
            return null;
        }
        ItemCameraTransforms transforms = this.modelBlock.func_181682_g();
        HashMap tMap = Maps.newHashMap();
        tMap.putAll(PerspectiveMapWrapper.getTransforms((ItemCameraTransforms)transforms));
        tMap.putAll(PerspectiveMapWrapper.getTransforms((IModelState)state));
        SimpleModelState perState = new SimpleModelState(ImmutableMap.copyOf((Map)tMap));
        return new BakedWrapper((IModelState)perState, format, ModularOverrideList.INSTANCE, bakedTextureGetter);
    }

    public IModelState getDefaultState() {
        return ModelRotation.X0_Y0;
    }

    public ModularModel retexture(ImmutableMap<String, String> textures) {
        return this;
    }
}

