/*
 * Decompiled with CFR 0.152.
 */
package se.mickelus.tetra.data;

import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import java.io.BufferedReader;
import java.io.File;
import java.io.IOException;
import java.io.Reader;
import java.nio.file.FileSystem;
import java.nio.file.FileSystems;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.util.Arrays;
import java.util.Objects;
import java.util.stream.Stream;
import net.minecraft.advancements.critereon.ItemPredicate;
import net.minecraft.block.Block;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.storage.loot.LootContext;
import net.minecraft.world.storage.loot.LootEntry;
import net.minecraft.world.storage.loot.LootPool;
import net.minecraft.world.storage.loot.RandomValueRange;
import net.minecraft.world.storage.loot.conditions.LootCondition;
import net.minecraft.world.storage.loot.conditions.LootConditionManager;
import net.minecraft.world.storage.loot.functions.LootFunction;
import net.minecraft.world.storage.loot.functions.LootFunctionManager;
import net.minecraftforge.fml.common.Loader;
import org.apache.commons.io.FilenameUtils;
import se.mickelus.tetra.blocks.PropertyMatcher;
import se.mickelus.tetra.data.BlockDeserializer;
import se.mickelus.tetra.data.BlockPosDeserializer;
import se.mickelus.tetra.data.GlyphDeserializer;
import se.mickelus.tetra.data.ItemPredicateDeserializer;
import se.mickelus.tetra.data.PropertyMatcherDeserializer;
import se.mickelus.tetra.data.ReplacementDeserializer;
import se.mickelus.tetra.data.ResourceLocationDeserializer;
import se.mickelus.tetra.generation.GenerationFeature;
import se.mickelus.tetra.loot.LootEntryDeserializer;
import se.mickelus.tetra.loot.LootPoolDeserializer;
import se.mickelus.tetra.module.Priority;
import se.mickelus.tetra.module.ReplacementDefinition;
import se.mickelus.tetra.module.data.CapabilityData;
import se.mickelus.tetra.module.data.EffectData;
import se.mickelus.tetra.module.data.GlyphData;
import se.mickelus.tetra.module.data.SynergyData;
import se.mickelus.tetra.module.schema.Material;
import se.mickelus.tetra.module.schema.SchemaDefinition;

public class DataHandler {
    private final File source;
    public final Gson gson;
    private File configDir;
    public static DataHandler instance;

    public DataHandler(File source) {
        this.source = source;
        this.configDir = Loader.instance().getConfigDir();
        this.gson = new GsonBuilder().registerTypeAdapter(CapabilityData.class, (Object)new CapabilityData.Deserializer()).registerTypeAdapter(EffectData.class, (Object)new EffectData.Deserializer()).registerTypeAdapter(GlyphData.class, (Object)new GlyphDeserializer()).registerTypeAdapter(Priority.class, (Object)new Priority.PriorityAdapter()).registerTypeAdapter(ItemPredicate.class, (Object)new ItemPredicateDeserializer()).registerTypeAdapter(PropertyMatcher.class, (Object)new PropertyMatcherDeserializer()).registerTypeAdapter(Material.class, (Object)new Material.MaterialDeserializer()).registerTypeAdapter(ReplacementDefinition.class, (Object)new ReplacementDeserializer()).registerTypeAdapter(BlockPos.class, (Object)new BlockPosDeserializer()).registerTypeAdapter(Block.class, (Object)new BlockDeserializer()).registerTypeAdapter(ResourceLocation.class, (Object)new ResourceLocationDeserializer()).registerTypeAdapter(LootPool.class, (Object)new LootPoolDeserializer()).registerTypeAdapter(LootEntry.class, (Object)new LootEntryDeserializer()).registerTypeAdapter(LootEntry.class, (Object)new LootEntryDeserializer()).registerTypeAdapter(RandomValueRange.class, (Object)new RandomValueRange.Serializer()).registerTypeAdapter(LootFunction.class, (Object)new LootFunctionManager.Serializer()).registerTypeAdapter(LootCondition.class, (Object)new LootConditionManager.Serializer()).registerTypeAdapter(LootContext.EntityTarget.class, (Object)new LootContext.EntityTarget.Serializer()).create();
        instance = this;
    }

    public <T> T getModuleData(String moduleKey, Class<T> dataClass) {
        return this.getData(String.format("modules/%s", moduleKey), dataClass);
    }

    public SchemaDefinition[] getSchemaDefinitions(String schemaName) {
        return this.getData(String.format("schemas/%s", schemaName), SchemaDefinition[].class);
    }

    public SynergyData[] getSynergyData(String path) {
        SynergyData[] data;
        for (SynergyData entry : data = this.getData(path, SynergyData[].class)) {
            Arrays.sort(entry.moduleVariants);
            Arrays.sort(entry.modules);
        }
        return data;
    }

    public ReplacementDefinition[] getReplacementDefinition(String path) {
        return (ReplacementDefinition[])Arrays.stream((Object[])this.getData(String.format("replacements/%s", path), ReplacementDefinition[].class)).filter(replacementDefinition -> replacementDefinition.predicate != null).toArray(ReplacementDefinition[]::new);
    }

    public <T> T getData(String path, Class<T> dataClass) {
        String pathString = String.format("data/%s/%s.json", "tetra", path);
        File configOverride = new File(this.configDir, String.format("%s/%s.json", "tetra", path));
        try {
            T data = null;
            if (configOverride.exists()) {
                data = this.readData(configOverride.toPath(), dataClass);
            } else if (this.source.isFile()) {
                try (FileSystem fs = FileSystems.newFileSystem(this.source.toPath(), null);){
                    data = this.readData(fs.getPath(pathString, new String[0]), dataClass);
                }
            } else if (this.source.isDirectory()) {
                data = this.readData(this.source.toPath().resolve(pathString), dataClass);
            }
            if (data != null) {
                return data;
            }
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        System.err.printf("Could not read data from '%s'. Initializing from empty array.\n", path);
        return (T)this.gson.fromJson("[]", dataClass);
    }

    public <T> T getAsset(String path, Class<T> assetClass) {
        return this.getAsset("tetra", path, assetClass);
    }

    public <T> T getAsset(String namespace, String path, Class<T> assetClass) {
        String pathString = String.format("assets/%s/%s.json", namespace, path);
        File configOverride = new File(this.configDir, String.format("%s/assets/%s/%s.json", "tetra", namespace, path));
        try {
            T asset = null;
            if (configOverride.exists()) {
                asset = this.readData(configOverride.toPath(), assetClass);
            } else if (this.source.isFile()) {
                try (FileSystem fs = FileSystems.newFileSystem(this.source.toPath(), null);){
                    asset = this.readData(fs.getPath(pathString, new String[0]), assetClass);
                }
            } else if (this.source.isDirectory()) {
                asset = this.readData(this.source.toPath().resolve(pathString), assetClass);
            }
            if (asset != null) {
                return asset;
            }
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        System.err.printf("Could not read assets from '%s'. Initializing from empty array.\n", path);
        return (T)this.gson.fromJson("[]", assetClass);
    }

    private <T> T readData(Path path, Class<T> dataClass) throws IOException {
        if (path != null && Files.exists(path, new LinkOption[0])) {
            try (BufferedReader reader = Files.newBufferedReader(path);){
                Object object = this.gson.fromJson((Reader)reader, dataClass);
                return (T)object;
            }
        }
        return null;
    }

    public GenerationFeature[] getGenerationFeatures() {
        String pathString = String.format("assets/%s/structures", "tetra");
        try {
            GenerationFeature[] features = null;
            if (this.source.isFile()) {
                try (FileSystem fs = FileSystems.newFileSystem(this.source.toPath(), null);){
                    features = this.getGenerationFeatures(fs.getPath(pathString, new String[0]));
                }
            } else if (this.source.isDirectory()) {
                features = this.getGenerationFeatures(this.source.toPath().resolve(pathString));
            }
            if (features != null) {
                return features;
            }
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        return new GenerationFeature[0];
    }

    private GenerationFeature[] getGenerationFeatures(Path structuresPath) throws IOException {
        if (structuresPath != null && Files.exists(structuresPath, new LinkOption[0])) {
            try (Stream<Path> stream = Files.list(structuresPath);){
                GenerationFeature[] generationFeatureArray = (GenerationFeature[])stream.filter(path -> FilenameUtils.isExtension((String)path.toString(), (String)"json")).map(this::getGenerationFeature).filter(Objects::nonNull).toArray(GenerationFeature[]::new);
                return generationFeatureArray;
            }
        }
        return null;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private GenerationFeature getGenerationFeature(Path path) {
        try (BufferedReader reader = Files.newBufferedReader(path);){
            GenerationFeature generationFeature2 = (GenerationFeature)this.gson.fromJson((Reader)reader, GenerationFeature.class);
            if (generationFeature2 != null && generationFeature2.location == null) {
                generationFeature2.location = new ResourceLocation("tetra", FilenameUtils.removeExtension((String)path.getFileName().toString()));
            }
            GenerationFeature generationFeature = generationFeature2;
            return generationFeature;
        }
        catch (IOException e) {
            e.printStackTrace();
            System.err.println("Failed to read generation feature from: " + path);
            return null;
        }
    }

    public LootPool[] getExtendedLootPools(ResourceLocation poolLocation) {
        return this.getAsset(poolLocation.func_110624_b(), String.format("loot_pools_extended/%s", poolLocation.func_110623_a()), LootPool[].class);
    }
}

