/*
 * Decompiled with CFR 0.152.
 */
package se.mickelus.tetra.data;

import com.google.gson.JsonDeserializationContext;
import com.google.gson.JsonDeserializer;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonParseException;
import com.google.gson.JsonSyntaxException;
import java.lang.reflect.Type;
import java.util.Map;
import net.minecraft.advancements.critereon.ItemPredicate;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.util.JsonUtils;
import net.minecraft.util.ResourceLocation;
import se.mickelus.tetra.items.ItemModular;
import se.mickelus.tetra.module.ItemModule;
import se.mickelus.tetra.module.ItemModuleMajor;
import se.mickelus.tetra.module.ItemUpgradeRegistry;
import se.mickelus.tetra.module.ReplacementDefinition;

public class ReplacementDeserializer
implements JsonDeserializer<ReplacementDefinition> {
    public ReplacementDefinition deserialize(JsonElement element, Type typeOfT, JsonDeserializationContext context) throws JsonParseException {
        ReplacementDefinition replacement = new ReplacementDefinition();
        JsonObject jsonObject = element.getAsJsonObject();
        try {
            replacement.predicate = ItemPredicate.func_192492_a((JsonElement)JsonUtils.func_152754_s((JsonObject)jsonObject, (String)"predicate"));
        }
        catch (JsonSyntaxException e) {
            return replacement;
        }
        ResourceLocation resourcelocation = new ResourceLocation(JsonUtils.func_151200_h((JsonObject)jsonObject, (String)"item"));
        Item item = (Item)Item.field_150901_e.func_82594_a((Object)resourcelocation);
        if (item == null) {
            throw new JsonSyntaxException("Failed to parse replacement data from " + jsonObject.getAsString());
        }
        replacement.itemStack = new ItemStack(item);
        if (item instanceof ItemModular) {
            for (Map.Entry moduleDefinition : JsonUtils.func_152754_s((JsonObject)jsonObject, (String)"modules").entrySet()) {
                String moduleKey = ((JsonElement)moduleDefinition.getValue()).getAsJsonArray().get(0).getAsString();
                String moduleVariant = ((JsonElement)moduleDefinition.getValue()).getAsJsonArray().get(1).getAsString();
                ItemModule module = ItemUpgradeRegistry.instance.getModule(moduleKey);
                if (module == null) {
                    throw new JsonSyntaxException("Failed to parse replacement data due to missing module: " + moduleKey);
                }
                module.addModule(replacement.itemStack, moduleVariant, null);
            }
            if (jsonObject.has("improvements")) {
                for (Map.Entry improvement : JsonUtils.func_152754_s((JsonObject)jsonObject, (String)"improvements").entrySet()) {
                    String[] temp = ((String)improvement.getKey()).split(":");
                    ItemModuleMajor.addImprovement(replacement.itemStack, temp[0], temp[1], ((JsonElement)improvement.getValue()).getAsInt());
                }
            }
        }
        return replacement;
    }
}

