/*
 * Decompiled with CFR 0.152.
 */
package se.mickelus.tetra.generation;

import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Random;
import java.util.stream.Collectors;
import javax.annotation.Nullable;
import net.minecraft.command.CommandBase;
import net.minecraft.command.CommandException;
import net.minecraft.command.ICommand;
import net.minecraft.command.ICommandSender;
import net.minecraft.server.MinecraftServer;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.ChunkPos;
import se.mickelus.tetra.generation.GenerationFeature;
import se.mickelus.tetra.generation.WorldGenFeatures;

public class TGenCommand
extends CommandBase {
    public String func_71517_b() {
        return "tgen";
    }

    public String func_71518_a(ICommandSender sender) {
        return "tgen feature [x y z]";
    }

    public int func_82362_a() {
        return 2;
    }

    public void func_184881_a(MinecraftServer server, ICommandSender sender, String[] args) throws CommandException {
        BlockPos senderPos = sender.func_180425_c();
        ChunkPos chunkPos = new ChunkPos(senderPos);
        if (args.length == 0) {
            TGenCommand.func_152373_a((ICommandSender)sender, (ICommand)this, (String)("Too few arguments: " + this.func_71518_a(sender)), (Object[])new Object[]{chunkPos});
            return;
        }
        ResourceLocation featureLocation = new ResourceLocation(args[0]);
        GenerationFeature feature = WorldGenFeatures.instance.getFeature(featureLocation);
        if (feature == null) {
            TGenCommand.func_152373_a((ICommandSender)sender, (ICommand)this, (String)("Feature not found " + featureLocation), (Object[])new Object[]{chunkPos});
        }
        if (args.length == 3) {
            chunkPos = new ChunkPos(TGenCommand.func_175755_a((String)args[1]), TGenCommand.func_175755_a((String)args[2]));
        }
        long seed = sender.func_130014_f_().func_72905_C();
        Random random = new Random(seed);
        long xSeed = random.nextLong() >> 3;
        long zSeed = random.nextLong() >> 3;
        long chunkSeed = xSeed * (long)chunkPos.field_77276_a + zSeed * (long)chunkPos.field_77275_b ^ seed;
        random.setSeed(chunkSeed);
        WorldGenFeatures.instance.generateFeatureRoot(feature, chunkPos.field_77276_a, chunkPos.field_77275_b, sender.func_130014_f_(), random);
        TGenCommand.func_152373_a((ICommandSender)sender, (ICommand)this, (String)("Generated feature " + featureLocation), (Object[])new Object[]{chunkPos});
    }

    public List<String> func_184883_a(MinecraftServer server, ICommandSender sender, String[] args, @Nullable BlockPos targetPos) {
        if (args.length == 1) {
            return Arrays.stream(WorldGenFeatures.instance.getFeatures()).map(feature -> feature.location.toString()).filter(location -> location.contains(args[0])).collect(Collectors.toList());
        }
        return Collections.emptyList();
    }
}

