/*
 * Decompiled with CFR 0.152.
 */
package se.mickelus.tetra.gui.animation;

import java.util.function.Consumer;
import se.mickelus.tetra.gui.animation.KeyframeAnimation;

public class AnimationChain {
    private final KeyframeAnimation[] animations;
    private KeyframeAnimation activeAnimation;
    private boolean looping = false;
    private Consumer<Boolean> stopHandler;

    public AnimationChain(KeyframeAnimation ... animations) {
        this.animations = animations;
        for (int i = 0; i < animations.length; ++i) {
            int index = i;
            animations[i].onStop(isActive -> {
                if (isActive.booleanValue()) {
                    this.startNext(index);
                } else if (this.stopHandler != null) {
                    this.stopHandler.accept(false);
                }
            });
        }
    }

    public AnimationChain setLooping(boolean looping) {
        this.looping = looping;
        return this;
    }

    public AnimationChain onStop(Consumer<Boolean> handler) {
        this.stopHandler = handler;
        return this;
    }

    public void stop() {
        if (this.activeAnimation != null) {
            this.activeAnimation.stop();
        }
    }

    public void start() {
        this.activeAnimation = this.animations[0];
        this.activeAnimation.start();
    }

    private void startNext(int currentIndex) {
        if (currentIndex + 1 >= this.animations.length) {
            if (this.looping) {
                this.activeAnimation = this.animations[0];
            } else {
                if (this.stopHandler != null) {
                    this.stopHandler.accept(true);
                }
                this.activeAnimation = null;
            }
        } else {
            this.activeAnimation = this.animations[currentIndex + 1];
        }
        if (this.activeAnimation != null) {
            this.activeAnimation.start();
        }
    }
}

