/*
 * Decompiled with CFR 0.152.
 */
package se.mickelus.tetra.gui.impl;

import com.mojang.realmsclient.gui.ChatFormatting;
import java.util.Collections;
import java.util.List;
import net.minecraft.client.resources.I18n;
import net.minecraft.item.ItemStack;
import se.mickelus.tetra.gui.GuiAttachment;
import se.mickelus.tetra.gui.GuiElement;
import se.mickelus.tetra.gui.GuiString;
import se.mickelus.tetra.gui.GuiStringSmall;
import se.mickelus.tetra.gui.impl.statbar.GuiBar;
import se.mickelus.tetra.items.ItemModular;
import se.mickelus.tetra.util.CastOptional;

public class GuiMagicUsage
extends GuiElement {
    protected GuiString valueString;
    protected GuiBar bar;
    protected List<String> tooltip;

    public GuiMagicUsage(int x, int y, int barLength) {
        super(x, y, barLength, 12);
        this.addChild(new GuiStringSmall(0, 0, I18n.func_135052_a((String)"item.modular.magic_capacity.label", (Object[])new Object[0])));
        this.valueString = new GuiStringSmall(0, 0, "");
        this.valueString.setAttachment(GuiAttachment.topRight);
        this.addChild(this.valueString);
        this.bar = new GuiBar(0, 0, barLength, 0.0, 0.0);
        this.addChild(this.bar);
    }

    public void update(ItemStack itemStack, ItemStack previewStack, String slot) {
        if (!previewStack.func_190926_b()) {
            int value = GuiMagicUsage.getCost(itemStack, slot);
            int diffValue = GuiMagicUsage.getCost(previewStack, slot) - value;
            int max = GuiMagicUsage.getGain(itemStack, slot);
            int diffMax = GuiMagicUsage.getGain(previewStack, slot) - max;
            this.bar.setMax(Math.max(max + diffMax, max));
            this.tooltip = Collections.singletonList(I18n.func_135052_a((String)"item.modular.magic_capacity.description", (Object[])new Object[]{max, value + diffValue}));
            if (diffMax != 0) {
                this.bar.setValue(max, max + diffMax);
                this.valueString.setString(String.format("%s(%+d)%s %d/%d", diffMax < 0 ? ChatFormatting.RED : ChatFormatting.GREEN, diffMax, ChatFormatting.RESET, max + diffMax, max + diffMax));
            } else if (diffValue != 0) {
                this.bar.setValue(max - value, max - value - diffValue);
                this.valueString.setString(String.format("%s(%+d)%s %d/%d", diffValue > 0 ? ChatFormatting.RED : ChatFormatting.GREEN, -diffValue, ChatFormatting.RESET, max - value - diffValue, max));
            } else {
                this.bar.setValue(max - value, max - value);
                this.valueString.setString(String.format("%d/%d", max - value, max));
            }
        } else {
            int value = GuiMagicUsage.getCost(itemStack, slot);
            int max = GuiMagicUsage.getGain(itemStack, slot);
            this.tooltip = Collections.singletonList(I18n.func_135052_a((String)"item.modular.magic_capacity.description", (Object[])new Object[]{max, value}));
            this.valueString.setString(String.format("%d/%d", max - value, max));
            this.bar.setMax(max);
            this.bar.setValue(max - value, max - value);
        }
    }

    private static int getGain(ItemStack itemStack, String slot) {
        return CastOptional.cast(itemStack.func_77973_b(), ItemModular.class).map(item -> item.getModuleFromSlot(itemStack, slot)).map(module -> module.getMagicCapacityGain(itemStack)).orElse(0);
    }

    private static int getCost(ItemStack itemStack, String slot) {
        return CastOptional.cast(itemStack.func_77973_b(), ItemModular.class).map(item -> item.getModuleFromSlot(itemStack, slot)).map(module -> module.getMagicCapacityCost(itemStack)).orElse(0);
    }

    public boolean hasChanged(ItemStack itemStack, ItemStack previewStack, String slot) {
        return !previewStack.func_190926_b() && (GuiMagicUsage.getCost(itemStack, slot) != GuiMagicUsage.getCost(previewStack, slot) || GuiMagicUsage.getGain(itemStack, slot) != GuiMagicUsage.getGain(previewStack, slot));
    }

    public boolean providesCapacity(ItemStack itemStack, ItemStack previewStack, String slot) {
        return GuiMagicUsage.getGain(itemStack, slot) > 0 || GuiMagicUsage.getGain(previewStack, slot) > 0;
    }

    @Override
    public List<String> getTooltipLines() {
        if (this.hasFocus()) {
            return this.tooltip;
        }
        return super.getTooltipLines();
    }
}

