/*
 * Decompiled with CFR 0.152.
 */
package se.mickelus.tetra.gui.impl;

import se.mickelus.tetra.items.ItemModular;
import se.mickelus.tetra.items.duplex_tool.ItemDuplexToolModular;
import se.mickelus.tetra.items.toolbelt.ItemToolbeltModular;

public class GuiModuleOffsets {
    static GuiModuleOffsets[] defaultMajorOffsets = new GuiModuleOffsets[]{new GuiModuleOffsets(4, 0), new GuiModuleOffsets(4, 0, 4, 18), new GuiModuleOffsets(4, 0, 4, 18, -4, 0), new GuiModuleOffsets(4, 0, 4, 18, -4, 0, -4, 18)};
    static GuiModuleOffsets[] defaultMinorOffsets = new GuiModuleOffsets[]{new GuiModuleOffsets(-21, 12), new GuiModuleOffsets(-18, 5, -18, 18), new GuiModuleOffsets(-12, -1, -21, 12, -12, 25)};
    static GuiModuleOffsets toolbeltMajorOffsets = new GuiModuleOffsets(-14, 18, 4, 0, 4, 18);
    static GuiModuleOffsets toolbeltMinorOffsets = new GuiModuleOffsets(-13, 0);
    static GuiModuleOffsets duplexMajorOffsets = new GuiModuleOffsets(-13, -1, 3, 19, -13, 19);
    static GuiModuleOffsets duplexMinorOffsets = new GuiModuleOffsets(6, 1);
    private int[] offsetX;
    private int[] offsetY;
    private boolean[] alignment;

    public GuiModuleOffsets(int ... offsets) {
        this.offsetX = new int[offsets.length / 2];
        this.offsetY = new int[offsets.length / 2];
        this.alignment = new boolean[offsets.length / 2];
        for (int i = 0; i < offsets.length / 2; ++i) {
            this.offsetX[i] = offsets[i * 2];
            this.offsetY[i] = offsets[i * 2 + 1];
            this.alignment[i] = this.offsetX[i] > 0;
        }
    }

    public int size() {
        return this.offsetX.length;
    }

    public int getX(int index) {
        return this.offsetX[index];
    }

    public int getY(int index) {
        return this.offsetY[index];
    }

    public boolean getAlignment(int index) {
        return this.alignment[index];
    }

    public static GuiModuleOffsets getMajorOffsets(ItemModular item) {
        if (item instanceof ItemToolbeltModular) {
            return toolbeltMajorOffsets;
        }
        if (item instanceof ItemDuplexToolModular) {
            return duplexMajorOffsets;
        }
        return defaultMajorOffsets[item.getNumMajorModules() - 1];
    }

    public static GuiModuleOffsets getMinorOffsets(ItemModular item) {
        if (item instanceof ItemToolbeltModular) {
            return toolbeltMinorOffsets;
        }
        if (item instanceof ItemDuplexToolModular) {
            return duplexMinorOffsets;
        }
        return defaultMinorOffsets[item.getNumMinorModules() - 1];
    }
}

