/*
 * Decompiled with CFR 0.152.
 */
package se.mickelus.tetra.gui.impl;

import java.util.Collections;
import java.util.List;
import net.minecraft.client.resources.I18n;
import net.minecraft.item.ItemStack;
import net.minecraft.util.text.TextFormatting;
import se.mickelus.tetra.ConfigHandler;
import se.mickelus.tetra.gui.GuiAttachment;
import se.mickelus.tetra.gui.GuiElement;
import se.mickelus.tetra.gui.GuiString;
import se.mickelus.tetra.gui.GuiStringSmall;
import se.mickelus.tetra.gui.impl.statbar.GuiBar;
import se.mickelus.tetra.module.ItemModuleMajor;

public class GuiSettleProgress
extends GuiElement {
    protected GuiString labelString = new GuiStringSmall(0, 0, I18n.func_135052_a((String)"item.modular.settle_progress.label", (Object[])new Object[0]));
    protected GuiString valueString;
    protected GuiBar bar;
    protected List<String> tooltip;

    public GuiSettleProgress(int x, int y, int barLength) {
        super(x, y, barLength, 12);
        this.addChild(this.labelString);
        this.valueString = new GuiStringSmall(0, 0, "");
        this.valueString.setAttachment(GuiAttachment.topRight);
        this.addChild(this.valueString);
        this.bar = new GuiBar(0, 0, barLength, 0.0, 1.0);
        this.addChild(this.bar);
    }

    public void update(ItemStack itemStack, ItemModuleMajor module) {
        boolean isGain;
        int value = module.getSettleProgress(itemStack);
        int limit = module.getSettleLimit(itemStack);
        float progress = (1.0f * (float)limit - (float)value) / (float)limit;
        int settleMaxCount = module.getSettleMaxCount(itemStack);
        boolean fullySettled = settleMaxCount <= module.getImprovementLevel(itemStack, "settled");
        boolean isArrested = module.getImprovementLevel(itemStack, "arrested") != -1;
        boolean bl = isGain = module.getIntegrityGain(itemStack) > 0;
        if (isArrested) {
            this.labelString.setString(TextFormatting.RED + I18n.func_135052_a((String)"arrested.name", (Object[])new Object[0]));
            this.labelString.setAttachment(GuiAttachment.topCenter);
            this.tooltip = Collections.singletonList(I18n.func_135052_a((String)"arrested.description", (Object[])new Object[0]));
            this.valueString.setString("");
            this.bar.setValue(0.0, 0.0);
        } else if (fullySettled) {
            this.labelString.setString(TextFormatting.GREEN + I18n.func_135052_a((String)"item.modular.settle_full.label", (Object[])new Object[0]));
            this.labelString.setAttachment(GuiAttachment.topCenter);
            this.tooltip = isGain ? Collections.singletonList(I18n.func_135052_a((String)"item.modular.settle_full_gain.description", (Object[])new Object[0])) : Collections.singletonList(I18n.func_135052_a((String)"item.modular.settle_full_cost.description", (Object[])new Object[0]));
            this.valueString.setString("");
            this.bar.setValue(1.0, 1.0);
        } else if (settleMaxCount == 0) {
            this.labelString.setString(I18n.func_135052_a((String)"item.modular.settle_full_null.label", (Object[])new Object[0]));
            this.labelString.setAttachment(GuiAttachment.topCenter);
            this.tooltip = Collections.singletonList(I18n.func_135052_a((String)"item.modular.settle_full_null.description", (Object[])new Object[0]));
            this.valueString.setString("");
            this.bar.setValue(1.0, 1.0);
        } else {
            float durabilityPenalty = Math.max((float)module.getImprovementLevel(itemStack, "settled") * ConfigHandler.settleLimitLevelMultiplier, 1.0f) * (float)module.getDurability(itemStack) * ConfigHandler.settleLimitDurabilityMultiplier;
            this.labelString.setString(I18n.func_135052_a((String)"item.modular.settle_progress.label", (Object[])new Object[0]));
            this.labelString.setAttachment(GuiAttachment.topLeft);
            this.tooltip = Collections.singletonList(I18n.func_135052_a((String)(isGain ? "item.modular.settle_progress_gain.description" : "item.modular.settle_progress_cost.description"), (Object[])new Object[]{limit - value, limit, ConfigHandler.settleLimitBase, (int)durabilityPenalty}));
            this.valueString.setString(String.format("%.0f%%", Float.valueOf(100.0f * progress)));
            this.bar.setValue(1.0f * progress, 1.0f * progress);
        }
    }

    @Override
    public List<String> getTooltipLines() {
        if (this.hasFocus()) {
            return this.tooltip;
        }
        return super.getTooltipLines();
    }
}

