/*
 * Decompiled with CFR 0.152.
 */
package se.mickelus.tetra.gui.impl;

import se.mickelus.tetra.gui.GuiAttachment;
import se.mickelus.tetra.gui.GuiClickable;
import se.mickelus.tetra.gui.GuiRect;
import se.mickelus.tetra.gui.GuiString;
import se.mickelus.tetra.gui.animation.AnimationChain;
import se.mickelus.tetra.gui.animation.Applier;
import se.mickelus.tetra.gui.animation.KeyframeAnimation;
import se.mickelus.tetra.gui.impl.GuiKeybinding;

public class GuiTabVerticalButton
extends GuiClickable {
    private boolean hasContent = false;
    private boolean isActive;
    private GuiRect indicator;
    private GuiString label;
    private GuiKeybinding keybinding;
    private AnimationChain indicatorFlash;
    private KeyframeAnimation labelShow;
    private KeyframeAnimation labelHide;
    private KeyframeAnimation keybindShow;
    private KeyframeAnimation keybindHide;

    public GuiTabVerticalButton(int x, int y, String label, String keybinding, Runnable onClickHandler, boolean initiallyActive) {
        super(x, y, 0, 15, onClickHandler);
        this.setAttachmentPoint(GuiAttachment.topRight);
        this.indicator = new GuiRect(0, 0, 1, 15, 0xFFFFFF);
        this.indicator.setAttachment(GuiAttachment.topRight);
        this.addChild(this.indicator);
        this.indicatorFlash = new AnimationChain(new KeyframeAnimation(40, this.indicator).applyTo(new Applier.TranslateX(-3.0f)), new KeyframeAnimation(60, this.indicator).applyTo(new Applier.TranslateX(0.0f)));
        this.label = new GuiString(-5, 4, label);
        this.label.setAttachment(GuiAttachment.topRight);
        this.label.setOpacity(0.0f);
        this.addChild(this.label);
        this.labelShow = new KeyframeAnimation(100, this.label).applyTo(new Applier.Opacity(1.0f), new Applier.TranslateX(-5.0f));
        this.labelHide = new KeyframeAnimation(150, this.label).applyTo(new Applier.Opacity(0.0f), new Applier.TranslateX(-2.0f));
        this.keybinding = new GuiKeybinding(0, 2, keybinding);
        this.keybinding.setOpacity(0.0f);
        this.keybindShow = new KeyframeAnimation(100, this.keybinding).applyTo(new Applier.Opacity(1.0f), new Applier.TranslateX(0.0f));
        this.keybindHide = new KeyframeAnimation(150, this.keybinding).applyTo(new Applier.Opacity(0.0f), new Applier.TranslateX(3.0f));
        if (keybinding != null) {
            this.addChild(this.keybinding);
        }
        this.width = this.label.getWidth() + 10;
        this.isActive = initiallyActive;
        this.updateStyling();
    }

    private void updateStyling() {
        if (this.isActive) {
            this.indicator.setOpacity(1.0f);
        } else if (this.hasContent) {
            this.indicator.setOpacity(0.5f);
        } else {
            this.indicator.setOpacity(0.25f);
        }
        this.indicator.setColor(this.hasFocus() ? 0xFFFFCC : 0xFFFFFF);
    }

    public void setHasContent(boolean hasContent) {
        this.hasContent = hasContent;
        this.updateStyling();
    }

    public void setActive(boolean isActive) {
        this.isActive = isActive;
        this.updateStyling();
        if (isActive) {
            this.indicatorFlash.stop();
            this.indicatorFlash.start();
        }
    }

    @Override
    protected void onFocus() {
        this.updateStyling();
        this.labelHide.stop();
        this.keybindHide.stop();
        this.labelShow.stop();
        this.keybindShow.stop();
        this.labelShow.start();
        this.keybindShow.start();
    }

    @Override
    protected void onBlur() {
        this.updateStyling();
        this.labelShow.stop();
        this.keybindShow.stop();
        this.labelHide.stop();
        this.keybindHide.stop();
        this.labelHide.start();
        this.keybindHide.start();
    }
}

