/*
 * Decompiled with CFR 0.152.
 */
package se.mickelus.tetra.gui.impl.statbar;

import java.util.Collections;
import java.util.List;
import net.minecraft.client.resources.I18n;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.ItemStack;
import se.mickelus.tetra.gui.GuiAlignment;
import se.mickelus.tetra.gui.GuiAttachment;
import se.mickelus.tetra.gui.GuiRect;
import se.mickelus.tetra.gui.GuiString;
import se.mickelus.tetra.gui.GuiStringSmall;
import se.mickelus.tetra.gui.impl.statbar.GuiBar;
import se.mickelus.tetra.gui.impl.statbar.GuiBarSegmented;
import se.mickelus.tetra.gui.impl.statbar.GuiStatBase;
import se.mickelus.tetra.gui.impl.statbar.getter.ILabelGetter;
import se.mickelus.tetra.gui.impl.statbar.getter.IStatGetter;
import se.mickelus.tetra.gui.impl.statbar.getter.ITooltipGetter;
import se.mickelus.tetra.gui.impl.statbar.getter.LabelGetterBasic;
import se.mickelus.tetra.gui.impl.statbar.getter.StatGetterIntegrity;
import se.mickelus.tetra.gui.impl.statbar.getter.TooltipGetterInteger;
import se.mickelus.tetra.items.ItemModular;
import se.mickelus.tetra.util.CastOptional;

public class GuiStatBarIntegrity
extends GuiStatBase {
    protected double max = 9.0;
    protected GuiString labelString = new GuiStringSmall(0, 0, I18n.func_135052_a((String)"stats.integrity", (Object[])new Object[0]));
    protected GuiString valueString = new GuiStringSmall(0, 0, "");
    protected GuiBar barPositive;
    protected GuiBar barNegative;
    protected List<String> tooltip;
    protected IStatGetter statGetter;
    protected ILabelGetter labelGetter;
    protected ITooltipGetter tooltipGetterPositive;
    protected ITooltipGetter tooltipGetterNegative;

    public GuiStatBarIntegrity(int x, int y) {
        super(x, y, 59, 12);
        this.valueString.setAttachment(GuiAttachment.topRight);
        this.barNegative = new GuiBarSegmented(-1, 0, 27, 0.0, this.max, true);
        this.barNegative.setAlignment(GuiAlignment.right);
        this.addChild(this.barNegative);
        this.barPositive = new GuiBarSegmented(1, 0, 27, 0.0, this.max);
        this.barPositive.setAttachment(GuiAttachment.topRight);
        this.addChild(this.barPositive);
        this.addChild(this.labelString);
        this.addChild(this.valueString);
        this.addChild(new GuiRect(29, 5, 1, 3, 0x7F7F7F));
        this.statGetter = new StatGetterIntegrity();
        this.labelGetter = LabelGetterBasic.integerLabel;
        this.tooltipGetterPositive = new TooltipGetterInteger("stats.integrity.tooltip_positive", this.statGetter);
        this.tooltipGetterNegative = new TooltipGetterInteger("stats.integrity.tooltip_negative", this.statGetter, true);
    }

    @Override
    public void setAlignment(GuiAlignment alignment) {
    }

    @Override
    public void update(EntityPlayer player, ItemStack currentStack, ItemStack previewStack, String slot, String improvement) {
        double diffValue;
        double value;
        if (!previewStack.func_190926_b()) {
            value = this.statGetter.getValue(player, currentStack);
            diffValue = this.statGetter.getValue(player, previewStack);
        } else {
            value = this.statGetter.getValue(player, currentStack);
            if (slot != null) {
                diffValue = value;
                value -= this.getSlotValue(player, currentStack, slot, improvement);
            } else {
                diffValue = value;
            }
        }
        this.tooltip = value < 0.0 ? Collections.singletonList(this.tooltipGetterNegative.getTooltip(player, previewStack)) : Collections.singletonList(this.tooltipGetterPositive.getTooltip(player, previewStack));
        this.updateValue(value, diffValue);
    }

    @Override
    public boolean shouldShow(EntityPlayer player, ItemStack currentStack, ItemStack previewStack, String slot, String improvement) {
        return this.statGetter.shouldShow(player, currentStack, previewStack);
    }

    protected double getSlotValue(EntityPlayer player, ItemStack itemStack, String slot, String improvement) {
        return CastOptional.cast(itemStack.func_77973_b(), ItemModular.class).map(item -> {
            if (improvement != null) {
                return this.statGetter.getValue(player, itemStack, slot, improvement);
            }
            return this.statGetter.getValue(player, itemStack, slot);
        }).orElse(0.0);
    }

    public void updateValue(double value, double diffValue) {
        this.barNegative.setValue(value > 0.0 ? 0.0 : -value, diffValue > 0.0 ? 0.0 : -diffValue);
        this.barPositive.setValue(value < 0.0 ? 0.0 : value, diffValue < 0.0 ? 0.0 : diffValue);
        this.updateValueLabel(value, diffValue);
    }

    private void updateValueLabel(double value, double diffValue) {
        this.valueString.setString(this.labelGetter.getLabel(value, diffValue, false));
    }

    @Override
    public List<String> getTooltipLines() {
        if (this.hasFocus()) {
            return this.tooltip;
        }
        return super.getTooltipLines();
    }
}

