/*
 * Decompiled with CFR 0.152.
 */
package se.mickelus.tetra.items;

import com.google.common.collect.ImmutableList;
import com.mojang.realmsclient.gui.ChatFormatting;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.Random;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import javax.annotation.Nullable;
import net.minecraft.client.resources.I18n;
import net.minecraft.client.util.ITooltipFlag;
import net.minecraft.enchantment.EnchantmentDurability;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraft.init.SoundEvents;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.text.TextFormatting;
import net.minecraft.world.World;
import net.minecraftforge.fml.common.FMLCommonHandler;
import net.minecraftforge.fml.relauncher.Side;
import org.apache.commons.lang3.ArrayUtils;
import org.apache.commons.lang3.EnumUtils;
import org.apache.commons.lang3.text.WordUtils;
import org.lwjgl.input.Keyboard;
import se.mickelus.tetra.ConfigHandler;
import se.mickelus.tetra.NBTHelper;
import se.mickelus.tetra.capabilities.Capability;
import se.mickelus.tetra.capabilities.ICapabilityProvider;
import se.mickelus.tetra.items.IItemModular;
import se.mickelus.tetra.items.TetraItem;
import se.mickelus.tetra.module.ItemEffect;
import se.mickelus.tetra.module.ItemModule;
import se.mickelus.tetra.module.ItemModuleMajor;
import se.mickelus.tetra.module.ItemUpgradeRegistry;
import se.mickelus.tetra.module.data.ImprovementData;
import se.mickelus.tetra.module.data.ModuleData;
import se.mickelus.tetra.module.data.SynergyData;
import se.mickelus.tetra.module.improvement.DestabilizationEffect;
import se.mickelus.tetra.module.improvement.HonePacket;
import se.mickelus.tetra.module.schema.Material;
import se.mickelus.tetra.network.PacketHandler;

public abstract class ItemModular
extends TetraItem
implements IItemModular,
ICapabilityProvider {
    protected static final String repairCountKey = "repairCount";
    protected static final String cooledStrengthKey = "cooledStrength";
    private static final String honeProgressKey = "honing_progress";
    private static final String honeAvailableKey = "honing_available";
    private static final String honeCountKey = "honing_count";
    protected int honeBase = 450;
    protected int honeIntegrityMultiplier = 200;
    protected String[] majorModuleKeys;
    protected String[] minorModuleKeys;
    protected String[] requiredModules = new String[0];
    protected int baseDurability = 0;
    protected int baseIntegrity = 0;
    protected SynergyData[] synergies = new SynergyData[0];

    public int getMaxDamage(ItemStack stack) {
        return (int)((float)(this.getAllModules(stack).stream().map(itemModule -> itemModule.getDurability(stack)).reduce(0, Integer::sum) + this.baseDurability) * this.getDurabilityMultiplier(stack));
    }

    public float getDurabilityMultiplier(ItemStack itemStack) {
        return this.getAllModules(itemStack).stream().map(itemModule -> Float.valueOf(itemModule.getDurabilityMultiplier(itemStack))).reduce(Float.valueOf(1.0f), (a, b) -> Float.valueOf(a.floatValue() * b.floatValue())).floatValue();
    }

    public static int getIntegrityGain(ItemStack itemStack) {
        if (itemStack.func_77973_b() instanceof ItemModular) {
            return ((ItemModular)itemStack.func_77973_b()).getAllModules(itemStack).stream().map(module -> module.getIntegrityGain(itemStack)).reduce(0, Integer::sum);
        }
        return 0;
    }

    public static int getIntegrityCost(ItemStack itemStack) {
        if (itemStack.func_77973_b() instanceof ItemModular) {
            return ((ItemModular)itemStack.func_77973_b()).getAllModules(itemStack).stream().map(module -> module.getIntegrityCost(itemStack)).reduce(0, Integer::sum);
        }
        return 0;
    }

    protected Collection<ItemModule> getAllModules(ItemStack stack) {
        NBTTagCompound stackTag = NBTHelper.getTag(stack);
        if (stackTag != null) {
            return Stream.concat(Arrays.stream(this.majorModuleKeys), Arrays.stream(this.minorModuleKeys)).map(arg_0 -> ((NBTTagCompound)stackTag).func_74779_i(arg_0)).map(ItemUpgradeRegistry.instance::getModule).filter(Objects::nonNull).collect(Collectors.toList());
        }
        return Collections.emptyList();
    }

    @Override
    public ItemModuleMajor[] getMajorModules(ItemStack itemStack) {
        ItemModuleMajor[] modules = new ItemModuleMajor[this.majorModuleKeys.length];
        NBTTagCompound stackTag = NBTHelper.getTag(itemStack);
        for (int i = 0; i < this.majorModuleKeys.length; ++i) {
            String moduleName = stackTag.func_74779_i(this.majorModuleKeys[i]);
            ItemModule module = ItemUpgradeRegistry.instance.getModule(moduleName);
            if (!(module instanceof ItemModuleMajor)) continue;
            modules[i] = (ItemModuleMajor)module;
        }
        return modules;
    }

    @Override
    public ItemModule[] getMinorModules(ItemStack itemStack) {
        ItemModule[] modules = new ItemModule[this.minorModuleKeys.length];
        NBTTagCompound stackTag = NBTHelper.getTag(itemStack);
        for (int i = 0; i < this.minorModuleKeys.length; ++i) {
            ItemModule module;
            String moduleName = stackTag.func_74779_i(this.minorModuleKeys[i]);
            modules[i] = module = ItemUpgradeRegistry.instance.getModule(moduleName);
        }
        return modules;
    }

    @Override
    public boolean isModuleRequired(String moduleSlot) {
        return ArrayUtils.contains((Object[])this.requiredModules, (Object)moduleSlot);
    }

    @Override
    public int getNumMajorModules() {
        return this.majorModuleKeys.length;
    }

    @Override
    public String[] getMajorModuleKeys() {
        return this.majorModuleKeys;
    }

    @Override
    public String[] getMajorModuleNames() {
        return (String[])Arrays.stream(this.majorModuleKeys).map(key -> I18n.func_135052_a((String)key, (Object[])new Object[0])).toArray(String[]::new);
    }

    @Override
    public int getNumMinorModules() {
        return this.minorModuleKeys.length;
    }

    @Override
    public String[] getMinorModuleKeys() {
        return this.minorModuleKeys;
    }

    @Override
    public String[] getMinorModuleNames() {
        return (String[])Arrays.stream(this.minorModuleKeys).map(key -> I18n.func_135052_a((String)key, (Object[])new Object[0])).toArray(String[]::new);
    }

    @Override
    public ImmutableList<ResourceLocation> getTextures(ItemStack itemStack) {
        return this.getAllModules(itemStack).stream().sorted(Comparator.comparing(ItemModule::getRenderLayer)).flatMap(itemModule -> Arrays.stream(itemModule.getTextures(itemStack))).collect(Collectors.collectingAndThen(Collectors.toList(), ImmutableList::copyOf));
    }

    public boolean hasModule(ItemStack itemStack, ItemModule module) {
        return this.getAllModules(itemStack).stream().anyMatch(module::equals);
    }

    public ItemModule getModuleFromSlot(ItemStack itemStack, String slot) {
        return ItemUpgradeRegistry.instance.getModule(NBTHelper.getTag(itemStack).func_74779_i(slot));
    }

    public void applyDamage(int amount, ItemStack itemStack, EntityLivingBase responsibleEntity) {
        int maxDamage;
        int damage = itemStack.func_77952_i();
        if (damage < (maxDamage = itemStack.func_77958_k())) {
            int reducedAmount = this.getReducedDamage(amount, itemStack, responsibleEntity);
            itemStack.func_77972_a(reducedAmount, responsibleEntity);
            if (damage + reducedAmount >= maxDamage && responsibleEntity.field_70170_p.field_72995_K) {
                responsibleEntity.func_184185_a(SoundEvents.field_187769_eM, 1.0f, 1.0f);
            }
        }
    }

    public void tickProgression(EntityLivingBase entity, ItemStack itemStack, int multiplier) {
        if (!ConfigHandler.moduleProgression) {
            return;
        }
        this.tickHoningProgression(entity, itemStack, multiplier);
        for (ItemModuleMajor module : this.getMajorModules(itemStack)) {
            module.tickProgression(entity, itemStack, multiplier);
        }
    }

    public void tickHoningProgression(EntityLivingBase entity, ItemStack itemStack, int multiplier) {
        if (!ConfigHandler.moduleProgression) {
            return;
        }
        NBTTagCompound tag = NBTHelper.getTag(itemStack);
        if (!ItemModular.isHoneable(itemStack)) {
            int honingProgress = tag.func_74764_b(honeProgressKey) ? tag.func_74762_e(honeProgressKey) : this.getHoningBase(itemStack);
            tag.func_74768_a(honeProgressKey, honingProgress -= multiplier);
            if (honingProgress <= 0 && !ItemModular.isHoneable(itemStack)) {
                tag.func_74757_a(honeAvailableKey, true);
                if (entity instanceof EntityPlayer && FMLCommonHandler.instance().getEffectiveSide().isServer()) {
                    PacketHandler.sendTo(new HonePacket(itemStack), (EntityPlayerMP)entity);
                }
            }
        }
    }

    public int getHoningProgress(ItemStack itemStack) {
        NBTTagCompound tag = NBTHelper.getTag(itemStack);
        if (tag.func_74764_b(honeProgressKey)) {
            return tag.func_74762_e(honeProgressKey);
        }
        return this.getHoningBase(itemStack);
    }

    public void setHoningProgress(ItemStack itemStack, int progress) {
        NBTHelper.getTag(itemStack).func_74768_a(honeProgressKey, progress);
    }

    public int getHoningBase(ItemStack itemStack) {
        return Math.max(this.honeBase + this.honeIntegrityMultiplier * -ItemModular.getIntegrityCost(itemStack), 1);
    }

    public int getHonedCount(ItemStack itemStack) {
        return NBTHelper.getTag(itemStack).func_74762_e(honeCountKey);
    }

    public static boolean isHoneable(ItemStack itemStack) {
        return NBTHelper.getTag(itemStack).func_74764_b(honeAvailableKey);
    }

    public static int getHoningSeed(ItemStack itemStack) {
        return NBTHelper.getTag(itemStack).func_74762_e(honeCountKey) + 1;
    }

    public static void removeHoneable(ItemStack itemStack) {
        NBTTagCompound tag = NBTHelper.getTag(itemStack);
        tag.func_82580_o(honeAvailableKey);
        tag.func_82580_o(honeProgressKey);
        tag.func_74768_a(honeCountKey, tag.func_74762_e(honeCountKey) + 1);
    }

    public void setDamage(ItemStack itemStack, int damage) {
        super.setDamage(itemStack, Math.min(itemStack.func_77958_k(), damage));
    }

    private int getReducedDamage(int amount, ItemStack itemStack, EntityLivingBase responsibleEntity) {
        if (amount > 0) {
            int level = this.getEffectLevel(itemStack, ItemEffect.unbreaking);
            int reduction = 0;
            for (int i = 0; i < amount; ++i) {
                if (!EnchantmentDurability.func_92097_a((ItemStack)itemStack, (int)level, (Random)responsibleEntity.field_70170_p.field_73012_v)) continue;
                ++reduction;
            }
            return amount - reduction;
        }
        return amount;
    }

    public boolean isBroken(ItemStack itemStack) {
        return itemStack.func_77958_k() != 0 && itemStack.func_77952_i() >= itemStack.func_77958_k();
    }

    public void func_77624_a(ItemStack itemStack, @Nullable World playerIn, List<String> tooltip, ITooltipFlag advanced) {
        if (this.isBroken(itemStack)) {
            tooltip.add(TextFormatting.DARK_RED.toString() + TextFormatting.ITALIC + I18n.func_135052_a((String)"item.modular.broken", (Object[])new Object[0]));
        }
        if (Keyboard.isKeyDown((int)42) || Keyboard.isKeyDown((int)54)) {
            Arrays.stream(this.getMajorModules(itemStack)).filter(Objects::nonNull).forEach(module -> {
                tooltip.add("\u00bb " + module.getName(itemStack));
                Arrays.stream(module.getImprovements(itemStack)).map(improvement -> String.format(" %s- %s", ChatFormatting.DARK_GRAY, this.getImprovementTooltip(improvement.key, improvement.level))).forEach(tooltip::add);
            });
            Arrays.stream(this.getMinorModules(itemStack)).filter(Objects::nonNull).map(module -> "* " + module.getName(itemStack)).forEach(tooltip::add);
            if (ConfigHandler.moduleProgression) {
                if (ItemModular.isHoneable(itemStack)) {
                    tooltip.add(ChatFormatting.AQUA + " > " + ChatFormatting.GRAY + I18n.func_135052_a((String)"hone.available", (Object[])new Object[0]));
                } else {
                    int progress = this.getHoningProgress(itemStack);
                    int base = this.getHoningBase(itemStack);
                    tooltip.add(ChatFormatting.DARK_AQUA + " > " + ChatFormatting.GRAY + I18n.func_135052_a((String)"hone.progress", (Object[])new Object[]{String.format("%.1f", Float.valueOf(100.0f * (float)(base - progress) / (float)base))}));
                }
            }
        } else {
            Arrays.stream(this.getMajorModules(itemStack)).filter(Objects::nonNull).flatMap(module -> Arrays.stream(module.getImprovements(itemStack))).filter(improvement -> improvement.enchantment).collect(Collectors.groupingBy(ModuleData::getKey, Collectors.summingInt(ImprovementData::getLevel))).entrySet().stream().map(entry -> this.getImprovementTooltip((String)entry.getKey(), (Integer)entry.getValue())).forEach(tooltip::add);
        }
    }

    private String getImprovementTooltip(String key, int level) {
        String tooltip = I18n.func_135052_a((String)(key + ".name"), (Object[])new Object[0]);
        if (level > 0) {
            tooltip = tooltip + " " + I18n.func_135052_a((String)("enchantment.level." + level), (Object[])new Object[0]);
        }
        return tooltip.replaceAll("\u00c2\u00a7[0-9a-f]", "");
    }

    private Optional<ItemModule> getRepairModule(ItemStack itemStack) {
        List modules = this.getAllModules(itemStack).stream().filter(itemModule -> itemModule.getRepairMaterial(itemStack) != null).collect(Collectors.toList());
        if (modules.size() > 0) {
            int repairCount = this.getRepairCount(itemStack);
            return Optional.of(modules.get(repairCount % modules.size()));
        }
        return Optional.empty();
    }

    public String getRepairModuleName(ItemStack itemStack) {
        return this.getRepairModule(itemStack).map(module -> module.getName(itemStack)).orElse(null);
    }

    public String getRepairSlot(ItemStack itemStack) {
        return this.getRepairModule(itemStack).map(ItemModule::getSlot).orElse(null);
    }

    public Material getRepairMaterial(ItemStack itemStack) {
        return this.getRepairModule(itemStack).map(module -> module.getRepairMaterial(itemStack)).orElse(null);
    }

    public int getRepairMaterialCount(ItemStack itemStack) {
        return this.getRepairModule(itemStack).map(module -> module.getRepairMaterial((ItemStack)itemStack).count).orElse(0);
    }

    public int getRepairAmount(ItemStack itemStack) {
        return this.getRepairModule(itemStack).map(module -> (int)((float)module.getRepairAmount(itemStack) * this.getDurabilityMultiplier(itemStack))).orElse(0);
    }

    public Collection<Capability> getRepairRequiredCapabilities(ItemStack itemStack) {
        return this.getRepairModule(itemStack).map(module -> module.getRepairRequiredCapabilities(itemStack)).orElse(Collections.emptyList());
    }

    public int getRepairRequiredCapabilityLevel(ItemStack itemStack, Capability capability) {
        return this.getRepairModule(itemStack).filter(module -> module.getRepairRequiredCapabilities(itemStack).contains((Object)capability)).map(module -> module.getRepairRequiredCapabilityLevel(itemStack, capability)).map(level -> Math.max(1, level)).orElse(0);
    }

    public int getRepairRequiredExperience(ItemStack itemStack) {
        return this.getRepairModule(itemStack).map(module -> module.getMagicCapacity(itemStack)).map(capacity -> Math.max(0, -capacity.intValue())).orElse(0);
    }

    private int getRepairCount(ItemStack itemStack) {
        return NBTHelper.getTag(itemStack).func_74762_e(repairCountKey);
    }

    private void incrementRepairCount(ItemStack itemStack) {
        NBTTagCompound tag = NBTHelper.getTag(itemStack);
        tag.func_74768_a(repairCountKey, tag.func_74762_e(repairCountKey) + 1);
    }

    public void repair(ItemStack itemStack) {
        this.setDamage(itemStack, this.getDamage(itemStack) - this.getRepairAmount(itemStack));
        this.incrementRepairCount(itemStack);
    }

    @Override
    public ItemStack getDefaultStack() {
        return new ItemStack((Item)this);
    }

    @Override
    public void assemble(ItemStack itemStack, World world) {
        if (itemStack.func_77952_i() > itemStack.func_77958_k()) {
            itemStack.func_77964_b(itemStack.func_77958_k());
        }
        this.applyDestabilizationEffects(itemStack, world);
    }

    private void applyDestabilizationEffects(ItemStack itemStack, World world) {
        if (!world.field_72995_K) {
            Arrays.stream(this.getMajorModules(itemStack)).filter(Objects::nonNull).forEach(module -> {
                int instability = -module.getMagicCapacity(itemStack);
                for (DestabilizationEffect effect : DestabilizationEffect.getEffectsForImprovement(instability, module.getImprovements(itemStack))) {
                    int currentEffectLevel = module.getImprovementLevel(itemStack, effect.destabilizationKey);
                    int newLevel = currentEffectLevel >= 0 ? currentEffectLevel + 1 : (effect.minLevel == effect.maxLevel ? effect.minLevel : effect.minLevel + world.field_73012_v.nextInt(effect.maxLevel - effect.minLevel));
                    if (!module.acceptsImprovementLevel(effect.destabilizationKey, newLevel) || !(effect.probability * (float)instability > world.field_73012_v.nextFloat())) continue;
                    module.addImprovement(itemStack, effect.destabilizationKey, newLevel);
                }
            });
        }
    }

    public void tweak(ItemStack itemStack, String slot, Map<String, Integer> tweaks) {
        ItemModule module = this.getModuleFromSlot(itemStack, slot);
        float durabilityFactor = 0.0f;
        if (module == null || !module.isTweakable(itemStack)) {
            return;
        }
        if (itemStack.func_77984_f()) {
            durabilityFactor = (float)itemStack.func_77952_i() * 1.0f / (float)itemStack.func_77958_k();
        }
        tweaks.forEach((tweakKey, step) -> {
            if (module.hasTweak(itemStack, (String)tweakKey)) {
                module.setTweakStep(itemStack, (String)tweakKey, (int)step);
            }
        });
        if (itemStack.func_77984_f()) {
            itemStack.func_77964_b((int)(durabilityFactor * (float)itemStack.func_77958_k() - durabilityFactor * durabilityFactor * (float)module.getDurability(itemStack)));
        }
    }

    public int getCapabilityLevel(ItemStack itemStack, String capability) {
        if (EnumUtils.isValidEnum(Capability.class, (String)capability)) {
            return this.getCapabilityLevel(itemStack, Capability.valueOf(capability));
        }
        return -1;
    }

    @Override
    public int getCapabilityLevel(ItemStack itemStack, Capability capability) {
        if (this.isBroken(itemStack)) {
            return -1;
        }
        int base = this.getAllModules(itemStack).stream().map(module -> module.getCapabilityLevel(itemStack, capability)).max(Integer::compare).orElse(-1);
        int synergyBonus = Arrays.stream(this.getSynergyData(itemStack)).map(synergyData -> synergyData.capabilities).mapToInt(capabilityData -> capabilityData.getLevel(capability)).sum();
        return base + synergyBonus;
    }

    public float getCapabilityEfficiency(ItemStack itemStack, String capability) {
        if (EnumUtils.isValidEnum(Capability.class, (String)capability)) {
            return this.getCapabilityEfficiency(itemStack, Capability.valueOf(capability));
        }
        return -1.0f;
    }

    @Override
    public float getCapabilityEfficiency(ItemStack itemStack, Capability capability) {
        if (this.isBroken(itemStack)) {
            return 0.0f;
        }
        int highestLevel = this.getAllModules(itemStack).stream().map(module -> module.getCapabilityLevel(itemStack, capability)).max(Integer::compare).orElse(-1);
        float efficiency = this.getAllModules(itemStack).stream().filter(module -> module.getCapabilityLevel(itemStack, capability) >= highestLevel).map(module -> Float.valueOf(module.getCapabilityEfficiency(itemStack, capability))).max(Float::compare).orElse(Float.valueOf(1.0f)).floatValue() + (float)this.getAllModules(itemStack).stream().filter(module -> module.getCapabilityLevel(itemStack, capability) == 0).mapToDouble(module -> module.getCapabilityEfficiency(itemStack, capability)).sum();
        return Math.max(0.0f, efficiency + (float)Arrays.stream(this.getSynergyData(itemStack)).map(synergyData -> synergyData.capabilities).mapToDouble(capabilityData -> capabilityData.getEfficiency(capability)).sum());
    }

    @Override
    public Collection<Capability> getCapabilities(ItemStack itemStack) {
        if (this.isBroken(itemStack)) {
            return Collections.emptyList();
        }
        return this.getAllModules(itemStack).stream().flatMap(module -> module.getCapabilities(itemStack).stream()).collect(Collectors.toSet());
    }

    public ItemStack onCraftConsumeCapability(ItemStack providerStack, ItemStack targetStack, EntityPlayer player, Capability capability, int capabilityLevel, boolean consumeResources) {
        ItemStack result = targetStack.func_77946_l();
        return result;
    }

    public ItemStack onActionConsumeCapability(ItemStack providerStack, ItemStack targetStack, EntityPlayer player, Capability capability, int capabilityLevel, boolean consumeResources) {
        ItemStack result = targetStack.func_77946_l();
        return result;
    }

    public int getEffectLevel(ItemStack itemStack, ItemEffect effect) {
        if (this.isBroken(itemStack)) {
            return -1;
        }
        return this.getAllModules(itemStack).stream().mapToInt(module -> module.getEffectLevel(itemStack, effect)).sum();
    }

    public double getEffectEfficiency(ItemStack itemStack, ItemEffect effect) {
        if (this.isBroken(itemStack)) {
            return 0.0;
        }
        return this.getAllModules(itemStack).stream().mapToDouble(module -> module.getEffectEfficiency(itemStack, effect)).sum();
    }

    public Collection<ItemEffect> getEffects(ItemStack itemStack) {
        if (this.isBroken(itemStack)) {
            return Collections.emptyList();
        }
        return this.getAllModules(itemStack).stream().flatMap(module -> module.getEffects(itemStack).stream()).distinct().collect(Collectors.toSet());
    }

    public boolean func_77636_d(ItemStack itemStack) {
        return Arrays.stream(this.getImprovements(itemStack)).anyMatch(improvement -> improvement.enchantment);
    }

    public boolean shouldCauseReequipAnimation(ItemStack oldStack, ItemStack newStack, boolean slotChanged) {
        return slotChanged;
    }

    public ImprovementData[] getImprovements(ItemStack itemStack) {
        return (ImprovementData[])Arrays.stream(this.getMajorModules(itemStack)).filter(Objects::nonNull).flatMap(module -> Arrays.stream(module.getImprovements(itemStack))).toArray(ImprovementData[]::new);
    }

    protected String getDisplayNamePrefixes(ItemStack itemStack) {
        return Stream.concat(Arrays.stream(this.getImprovements(itemStack)).map(improvement -> improvement.key + ".prefix").filter(I18n::func_188566_a).map(x$0 -> I18n.func_135052_a((String)x$0, (Object[])new Object[0])), this.getAllModules(itemStack).stream().sorted(Comparator.comparing(module -> module.getItemPrefixPriority(itemStack))).map(module -> module.getItemPrefix(itemStack)).filter(Objects::nonNull)).limit(2L).reduce("", (result, prefix) -> result + prefix + " ");
    }

    public String func_77653_i(ItemStack itemStack) {
        if (FMLCommonHandler.instance().getEffectiveSide().equals((Object)Side.SERVER)) {
            return "";
        }
        String name = Arrays.stream(this.getSynergyData(itemStack)).map(synergyData -> synergyData.name).filter(Objects::nonNull).filter(I18n::func_188566_a).map(x$0 -> I18n.func_135052_a((String)x$0, (Object[])new Object[0])).findFirst().orElse(null);
        if (name == null) {
            name = this.getAllModules(itemStack).stream().sorted(Comparator.comparing(module -> module.getItemNamePriority(itemStack))).map(module -> module.getItemName(itemStack)).filter(Objects::nonNull).findFirst().orElse("");
        }
        String prefixes = this.getDisplayNamePrefixes(itemStack);
        return WordUtils.capitalize((String)(prefixes + name));
    }

    public SynergyData[] getAllSynergyData(ItemStack itemStack) {
        return this.synergies;
    }

    public SynergyData[] getSynergyData(ItemStack itemStack) {
        if (this.synergies.length > 0) {
            ArrayList<SynergyData> result = new ArrayList<SynergyData>();
            String[] moduleKeys = (String[])this.getAllModules(itemStack).stream().map(ItemModule::getUnlocalizedName).sorted().toArray(String[]::new);
            String[] variantKeys = (String[])this.getAllModules(itemStack).stream().map(module -> module.getData(itemStack)).map(data -> data.key).sorted().toArray(String[]::new);
            for (SynergyData synergy : this.synergies) {
                int variantMatches = 0;
                int moduleMatches = 0;
                for (String variantKey : variantKeys) {
                    if (variantMatches == synergy.moduleVariants.length) break;
                    if (!variantKey.equals(synergy.moduleVariants[variantMatches])) continue;
                    ++variantMatches;
                }
                for (String moduleKey : moduleKeys) {
                    if (moduleMatches == synergy.modules.length) break;
                    if (!moduleKey.equals(synergy.modules[moduleMatches])) continue;
                    ++moduleMatches;
                }
                if ((synergy.moduleVariants.length <= 0 || variantMatches != synergy.moduleVariants.length) && (synergy.modules.length <= 0 || moduleMatches != synergy.modules.length)) continue;
                result.add(synergy);
            }
            return result.toArray(new SynergyData[result.size()]);
        }
        return new SynergyData[0];
    }
}

