/*
 * Decompiled with CFR 0.152.
 */
package se.mickelus.tetra.items.journal.gui.craft;

import java.util.Arrays;
import java.util.function.Consumer;
import se.mickelus.tetra.blocks.workbench.gui.GuiSchemaListItem;
import se.mickelus.tetra.gui.GuiElement;
import se.mickelus.tetra.gui.animation.Applier;
import se.mickelus.tetra.gui.animation.KeyframeAnimation;
import se.mickelus.tetra.items.ItemModular;
import se.mickelus.tetra.module.ItemUpgradeRegistry;
import se.mickelus.tetra.module.schema.SchemaRarity;
import se.mickelus.tetra.module.schema.SchemaType;
import se.mickelus.tetra.module.schema.UpgradeSchema;
import se.mickelus.tetra.util.Filter;

public class GuiJournalSchemas
extends GuiElement {
    private Consumer<UpgradeSchema> onSchemaSelect;
    private KeyframeAnimation openAnimation;
    private KeyframeAnimation showAnimation;
    private KeyframeAnimation hideAnimation;

    public GuiJournalSchemas(int x, int y, int width, int height, Consumer<UpgradeSchema> onSchemaSelect) {
        super(x, y, width, height);
        this.onSchemaSelect = onSchemaSelect;
        this.openAnimation = new KeyframeAnimation(80, this).applyTo(new Applier.Opacity(0.0f, 1.0f), new Applier.TranslateY(y - 5, y)).withDelay(120);
        this.showAnimation = new KeyframeAnimation(80, this).applyTo(new Applier.Opacity(1.0f), new Applier.TranslateY(y));
        this.hideAnimation = new KeyframeAnimation(60, this).applyTo(new Applier.Opacity(0.0f), new Applier.TranslateY(y - 5)).onStop(complete -> {
            this.isVisible = false;
        });
    }

    public void update(ItemModular item, String slot) {
        int offset = 0;
        int pageLines = 8;
        UpgradeSchema[] schemas = (UpgradeSchema[])Arrays.stream(ItemUpgradeRegistry.instance.getSchemas(slot)).filter(schema -> !schema.isHoning()).filter(schema -> !schema.getRarity().equals((Object)SchemaRarity.temporary)).filter(schema -> !schema.getType().equals((Object)SchemaType.improvement)).filter(Filter.distinct(UpgradeSchema::getName)).toArray(UpgradeSchema[]::new);
        int count = schemas.length;
        this.clearChildren();
        for (int i = 0; i < count; ++i) {
            UpgradeSchema schema2 = schemas[i + offset];
            this.addChild(new GuiSchemaListItem(i / pageLines * 106, i % pageLines * 14, 103, schema2, () -> this.onSchemaSelect.accept(schema2)));
        }
    }

    public void animateOpen() {
        this.openAnimation.start();
    }

    @Override
    protected void onShow() {
        super.onShow();
        this.hideAnimation.stop();
        this.showAnimation.start();
    }

    @Override
    protected boolean onHide() {
        this.showAnimation.stop();
        this.hideAnimation.start();
        return false;
    }
}

