/*
 * Decompiled with CFR 0.152.
 */
package se.mickelus.tetra.items.journal.gui.craft;

import java.util.Arrays;
import java.util.Map;
import net.minecraft.client.Minecraft;
import net.minecraft.client.entity.EntityPlayerSP;
import net.minecraft.client.resources.I18n;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.ItemStack;
import se.mickelus.tetra.blocks.workbench.gui.GuiCapabilityRequirement;
import se.mickelus.tetra.capabilities.Capability;
import se.mickelus.tetra.capabilities.CapabilityHelper;
import se.mickelus.tetra.gui.GuiElement;
import se.mickelus.tetra.gui.GuiItem;
import se.mickelus.tetra.gui.GuiString;
import se.mickelus.tetra.gui.GuiStringSmall;
import se.mickelus.tetra.gui.animation.Applier;
import se.mickelus.tetra.gui.animation.KeyframeAnimation;
import se.mickelus.tetra.gui.impl.GuiSynergyIndicator;
import se.mickelus.tetra.items.journal.gui.craft.GuiJournalImprovement;
import se.mickelus.tetra.items.journal.gui.craft.GuiJournalStats;
import se.mickelus.tetra.module.ItemUpgradeRegistry;
import se.mickelus.tetra.module.schema.OutcomePreview;
import se.mickelus.tetra.module.schema.SchemaType;
import se.mickelus.tetra.module.schema.UpgradeSchema;

public class GuiJournalVariantDetail
extends GuiElement {
    private GuiString variantLabel = new GuiString(0, 0, "");
    private GuiSynergyIndicator synergyIndicator;
    private GuiString improvementsLabel;
    private GuiElement improvements;
    private GuiElement requiredCapabilities;
    private GuiItem material;
    private GuiJournalStats stats;
    private int[] capabilityLevels;
    private KeyframeAnimation openAnimation;
    private KeyframeAnimation showAnimation;
    private KeyframeAnimation hideAnimation;

    public GuiJournalVariantDetail(int x, int y, int width) {
        super(x, y, width, 100);
        this.addChild(this.variantLabel);
        this.synergyIndicator = new GuiSynergyIndicator(0, -1, true);
        this.addChild(this.synergyIndicator);
        GuiStringSmall requirementsLabel = new GuiStringSmall(0, 13, I18n.func_135052_a((String)"journal.craft.requirements", (Object[])new Object[0]));
        requirementsLabel.setColor(0x7F7F7F);
        this.addChild(requirementsLabel);
        this.requiredCapabilities = new GuiElement(0, 20, width, this.height);
        this.addChild(this.requiredCapabilities);
        this.material = new GuiItem(0, 20);
        this.addChild(this.material);
        EntityPlayerSP player = Minecraft.func_71410_x().field_71439_g;
        this.capabilityLevels = new int[Capability.values().length];
        for (int i = 0; i < this.capabilityLevels.length; ++i) {
            this.capabilityLevels[i] = CapabilityHelper.getPlayerCapabilityLevel((EntityPlayer)player, Capability.values()[i]);
        }
        this.improvementsLabel = new GuiStringSmall(57, 13, I18n.func_135052_a((String)"journal.craft.improvements", (Object[])new Object[0]));
        this.improvementsLabel.setColor(0x7F7F7F);
        this.addChild(this.improvementsLabel);
        this.improvements = new GuiElement(57, 18, width, this.height);
        this.addChild(this.improvements);
        GuiStringSmall statsLabel = new GuiStringSmall(120, 13, I18n.func_135052_a((String)"journal.craft.stats", (Object[])new Object[0]));
        statsLabel.setColor(0x7F7F7F);
        this.addChild(statsLabel);
        this.stats = new GuiJournalStats(120, 20);
        this.addChild(this.stats);
        this.openAnimation = new KeyframeAnimation(80, this).applyTo(new Applier.Opacity(0.0f, 1.0f), new Applier.TranslateY(y - 4, y)).withDelay(120);
        this.showAnimation = new KeyframeAnimation(60, this).applyTo(new Applier.Opacity(1.0f), new Applier.TranslateY(y));
        this.hideAnimation = new KeyframeAnimation(60, this).applyTo(new Applier.Opacity(0.0f), new Applier.TranslateY(y - 5)).onStop(complete -> {
            if (complete.booleanValue()) {
                this.isVisible = false;
            }
        });
    }

    public void updateVariant(OutcomePreview selectedOutcome, OutcomePreview hoveredOutcome, String slot) {
        if (selectedOutcome != null || hoveredOutcome != null) {
            int i;
            OutcomePreview baseOutcome = hoveredOutcome != null ? hoveredOutcome : selectedOutcome;
            this.variantLabel.setString(I18n.func_135052_a((String)baseOutcome.key, (Object[])new Object[0]));
            this.synergyIndicator.setX(this.variantLabel.getWidth() + 4);
            this.synergyIndicator.update(baseOutcome.itemStack, slot);
            ItemStack improvementStack = baseOutcome.itemStack;
            UpgradeSchema[] improvementSchemas = (UpgradeSchema[])Arrays.stream(ItemUpgradeRegistry.instance.getSchemas(slot)).filter(improvementSchema -> SchemaType.improvement.equals((Object)improvementSchema.getType())).filter(improvementSchema -> improvementSchema.isApplicableForItem(improvementStack)).toArray(UpgradeSchema[]::new);
            this.improvementsLabel.setVisible(improvementSchemas.length > 0);
            this.improvements.setVisible(improvementSchemas.length > 0);
            if (improvementSchemas.length > 0) {
                this.improvements.clearChildren();
                for (i = 0; i < improvementSchemas.length; ++i) {
                    this.improvements.addChild(new GuiJournalImprovement(0, i * 18, improvementSchemas[i]));
                }
            }
            this.requiredCapabilities.clearChildren();
            i = 0;
            for (Map.Entry entry : baseOutcome.capabilities.valueMap.entrySet()) {
                GuiCapabilityRequirement requirement = new GuiCapabilityRequirement(20, i * 18, (Capability)((Object)entry.getKey()));
                requirement.updateRequirement((Integer)entry.getValue(), this.capabilityLevels[((Capability)((Object)entry.getKey())).ordinal()]);
                this.requiredCapabilities.addChild(requirement);
                ++i;
            }
            if (baseOutcome.materials.length > 0) {
                this.material.setItem(baseOutcome.materials[0]);
            } else {
                this.material.setItem(null);
            }
            this.stats.update(selectedOutcome != null ? selectedOutcome.itemStack : hoveredOutcome.itemStack, baseOutcome.itemStack, null, null, (EntityPlayer)Minecraft.func_71410_x().field_71439_g);
            this.show();
        } else {
            this.hide();
        }
    }

    public void animateOpen() {
        this.stats.realignBars();
        this.openAnimation.start();
    }

    public void show() {
        this.hideAnimation.stop();
        this.setVisible(true);
        this.showAnimation.start();
    }

    public void hide() {
        this.showAnimation.stop();
        this.hideAnimation.start();
    }
}

