/*
 * Decompiled with CFR 0.152.
 */
package se.mickelus.tetra.items.journal.gui.craft;

import java.util.Arrays;
import java.util.function.Consumer;
import net.minecraft.client.resources.I18n;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import se.mickelus.tetra.gui.GuiElement;
import se.mickelus.tetra.gui.GuiStringSmall;
import se.mickelus.tetra.gui.animation.Applier;
import se.mickelus.tetra.gui.animation.KeyframeAnimation;
import se.mickelus.tetra.items.ItemModular;
import se.mickelus.tetra.items.journal.gui.craft.GuiJournalVariantItem;
import se.mickelus.tetra.items.journal.gui.craft.GuiJournalVariantMajorItem;
import se.mickelus.tetra.module.schema.OutcomePreview;
import se.mickelus.tetra.module.schema.SchemaType;
import se.mickelus.tetra.module.schema.UpgradeSchema;

public class GuiJournalVariants
extends GuiElement {
    private GuiElement variantsContainer;
    private GuiJournalVariantItem[] variants;
    private KeyframeAnimation labelAnimation;
    private KeyframeAnimation[] itemAnimations;
    private Consumer<OutcomePreview> onVariantHover;
    private Consumer<OutcomePreview> onVariantBlur;
    private Consumer<OutcomePreview> onVariantSelect;

    public GuiJournalVariants(int x, int y, int width, Consumer<OutcomePreview> onVariantHover, Consumer<OutcomePreview> onVariantBlur, Consumer<OutcomePreview> onVariantSelect) {
        super(x, y, width, 50);
        GuiStringSmall variantsLabel = new GuiStringSmall(0, 0, I18n.func_135052_a((String)"journal.craft.variants", (Object[])new Object[0]));
        variantsLabel.setColor(0x7F7F7F);
        this.addChild(variantsLabel);
        this.variants = new GuiJournalVariantItem[0];
        this.variantsContainer = new GuiElement(0, 8, width, this.height);
        this.addChild(this.variantsContainer);
        this.labelAnimation = new KeyframeAnimation(100, variantsLabel).applyTo(new Applier.Opacity(0.0f, 1.0f), new Applier.TranslateX(x - 5, x));
        this.itemAnimations = new KeyframeAnimation[0];
        this.onVariantHover = onVariantHover;
        this.onVariantBlur = onVariantBlur;
        this.onVariantSelect = onVariantSelect;
    }

    public void update(ItemModular item, String slot, UpgradeSchema schema) {
        this.variantsContainer.clearChildren();
        OutcomePreview[] outcomes = (OutcomePreview[])Arrays.stream(schema.getPreviews(new ItemStack((Item)item), slot)).filter(preview -> preview.materials.length != 0).toArray(OutcomePreview[]::new);
        this.variants = new GuiJournalVariantItem[outcomes.length];
        this.itemAnimations = new KeyframeAnimation[outcomes.length];
        for (int i = 0; i < outcomes.length; ++i) {
            if (SchemaType.minor.equals((Object)outcomes[i].type)) {
                this.variants[i] = new GuiJournalVariantItem(i / 2 * 15, i % 2 * 15, outcomes[i], this.onVariantHover, this.onVariantBlur, this.onVariantSelect);
                this.variantsContainer.addChild(this.variants[i]);
                this.itemAnimations[i] = new KeyframeAnimation(80, this.variants[i]).applyTo(new Applier.Opacity(0.0f, 1.0f), new Applier.TranslateY(-5.0f, 0.0f, true)).withDelay(40 + 40 * (i / 2));
                continue;
            }
            this.variants[i] = new GuiJournalVariantMajorItem(i / 2 * 20 + i % 2 * 10, i % 2 * 15, outcomes[i], this.onVariantHover, this.onVariantBlur, this.onVariantSelect);
            this.variantsContainer.addChild(this.variants[i]);
            this.itemAnimations[i] = new KeyframeAnimation(80, this.variants[i]).applyTo(new Applier.Opacity(0.0f, 1.0f), new Applier.TranslateX(-5.0f, 0.0f, true), new Applier.TranslateY(-5.0f, 0.0f, true)).withDelay(40 + 40 * (i / 2));
        }
    }

    public void updateSelection(OutcomePreview outcome) {
        for (GuiJournalVariantItem variant : this.variants) {
            variant.updateSelection(outcome);
        }
    }

    @Override
    protected void onShow() {
        this.labelAnimation.start();
        Arrays.stream(this.itemAnimations).forEach(KeyframeAnimation::start);
    }
}

