/*
 * Decompiled with CFR 0.152.
 */
package se.mickelus.tetra.items.toolbelt;

import io.netty.buffer.ByteBuf;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.util.EnumHand;
import se.mickelus.tetra.items.toolbelt.UtilToolbelt;
import se.mickelus.tetra.items.toolbelt.inventory.ToolbeltSlotType;
import se.mickelus.tetra.network.AbstractPacket;

public class EquipToolbeltItemPacket
extends AbstractPacket {
    private ToolbeltSlotType slotType;
    private int toolbeltItemIndex;
    private EnumHand hand;

    public EquipToolbeltItemPacket() {
    }

    public EquipToolbeltItemPacket(ToolbeltSlotType inventoryType, int toolbeltSlot, EnumHand hand) {
        this.slotType = inventoryType;
        this.toolbeltItemIndex = toolbeltSlot;
        this.hand = hand;
    }

    @Override
    public void toBytes(ByteBuf buffer) {
        buffer.writeInt(this.slotType.ordinal());
        buffer.writeInt(this.hand.ordinal());
        buffer.writeInt(this.toolbeltItemIndex);
    }

    @Override
    public void fromBytes(ByteBuf buffer) {
        int handOrdinal;
        int typeOrdinal = buffer.readInt();
        if (typeOrdinal < ToolbeltSlotType.values().length) {
            this.slotType = ToolbeltSlotType.values()[typeOrdinal];
        }
        if ((handOrdinal = buffer.readInt()) < EnumHand.values().length) {
            this.hand = EnumHand.values()[handOrdinal];
        }
        this.toolbeltItemIndex = buffer.readInt();
    }

    @Override
    public void handle(EntityPlayer player) {
        if (this.toolbeltItemIndex > -1) {
            UtilToolbelt.equipItemFromToolbelt(player, this.slotType, this.toolbeltItemIndex, this.hand);
        } else {
            UtilToolbelt.storeItemInToolbelt(player);
        }
    }
}

