/*
 * Decompiled with CFR 0.152.
 */
package se.mickelus.tetra.items.toolbelt;

import net.minecraft.block.state.IBlockState;
import net.minecraft.client.Minecraft;
import net.minecraft.client.settings.KeyBinding;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.ItemStack;
import net.minecraft.util.EnumHand;
import net.minecraft.util.math.RayTraceResult;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.TextComponentTranslation;
import net.minecraftforge.client.event.RenderGameOverlayEvent;
import net.minecraftforge.client.settings.IKeyConflictContext;
import net.minecraftforge.client.settings.KeyConflictContext;
import net.minecraftforge.client.settings.KeyModifier;
import net.minecraftforge.fml.client.registry.ClientRegistry;
import net.minecraftforge.fml.common.eventhandler.EventPriority;
import net.minecraftforge.fml.common.eventhandler.SubscribeEvent;
import net.minecraftforge.fml.common.gameevent.InputEvent;
import se.mickelus.tetra.items.toolbelt.EquipToolbeltItemPacket;
import se.mickelus.tetra.items.toolbelt.UtilToolbelt;
import se.mickelus.tetra.items.toolbelt.gui.OverlayGuiToolbelt;
import se.mickelus.tetra.items.toolbelt.inventory.ToolbeltSlotType;
import se.mickelus.tetra.network.PacketHandler;

public class OverlayToolbelt {
    public static OverlayToolbelt instance;
    private final Minecraft mc;
    public static final String bindingGroup = "toolbelt.binding.group";
    public KeyBinding accessBinding;
    public KeyBinding restockBinding;
    private long openTime = -1L;
    private boolean isActive = false;
    private OverlayGuiToolbelt gui;

    public OverlayToolbelt(Minecraft mc) {
        this.mc = mc;
        this.gui = new OverlayGuiToolbelt(mc);
        this.accessBinding = new KeyBinding("toolbelt.binding.access", (IKeyConflictContext)KeyConflictContext.IN_GAME, 47, bindingGroup);
        this.restockBinding = new KeyBinding("toolbelt.binding.restock", (IKeyConflictContext)KeyConflictContext.IN_GAME, KeyModifier.SHIFT, 47, bindingGroup);
        ClientRegistry.registerKeyBinding((KeyBinding)this.accessBinding);
        ClientRegistry.registerKeyBinding((KeyBinding)this.restockBinding);
        instance = this;
    }

    @SubscribeEvent
    public void onKeyInput(InputEvent.KeyInputEvent event) {
        if (this.restockBinding.func_151468_f()) {
            this.equipToolbeltItem(ToolbeltSlotType.quickslot, -1, EnumHand.OFF_HAND);
        } else if (this.accessBinding.func_151468_f() && this.mc.field_71415_G) {
            this.showView();
        }
    }

    @SubscribeEvent(priority=EventPriority.NORMAL)
    public void onRenderOverlay(RenderGameOverlayEvent.Post event) {
        if (event.getType() != RenderGameOverlayEvent.ElementType.HOTBAR) {
            return;
        }
        if (!this.accessBinding.func_151470_d() && this.isActive) {
            this.hideView();
        }
        this.gui.draw();
    }

    private void showView() {
        boolean canOpen = this.updateGuiData();
        if (canOpen) {
            this.mc.field_71415_G = false;
            this.mc.field_71417_B.func_74373_b();
            this.isActive = true;
            this.openTime = System.currentTimeMillis();
        }
    }

    private void hideView() {
        this.mc.field_71415_G = true;
        this.gui.setVisible(false);
        this.mc.field_71417_B.func_74372_a();
        this.isActive = false;
        int focusIndex = this.findIndex();
        if (focusIndex != -1) {
            this.equipToolbeltItem(this.findSlotType(), focusIndex, EnumHand.OFF_HAND);
        } else if (System.currentTimeMillis() - this.openTime < 500L) {
            this.quickEquip();
        }
    }

    private void equipToolbeltItem(ToolbeltSlotType slotType, int toolbeltItemIndex, EnumHand hand) {
        EquipToolbeltItemPacket packet = new EquipToolbeltItemPacket(slotType, toolbeltItemIndex, hand);
        PacketHandler.sendToServer(packet);
        if (toolbeltItemIndex > -1) {
            UtilToolbelt.equipItemFromToolbelt((EntityPlayer)this.mc.field_71439_g, slotType, toolbeltItemIndex, hand);
        } else {
            boolean storeItemSuccess = UtilToolbelt.storeItemInToolbelt((EntityPlayer)this.mc.field_71439_g);
            if (!storeItemSuccess) {
                this.mc.field_71439_g.func_146105_b((ITextComponent)new TextComponentTranslation("toolbelt.full", new Object[0]), true);
            }
        }
    }

    private void quickEquip() {
        IBlockState blockState;
        int index;
        if (this.mc.field_71476_x.field_72313_a == RayTraceResult.Type.BLOCK && (index = UtilToolbelt.getQuickAccessSlotIndex((EntityPlayer)this.mc.field_71439_g, this.mc.field_71476_x, blockState = this.mc.field_71441_e.func_180495_p(this.mc.field_71476_x.func_178782_a()))) > -1) {
            this.equipToolbeltItem(ToolbeltSlotType.quickslot, index, EnumHand.MAIN_HAND);
        }
    }

    private boolean updateGuiData() {
        ItemStack itemStack = UtilToolbelt.findToolbelt((EntityPlayer)this.mc.field_71439_g);
        if (!itemStack.func_190926_b()) {
            this.gui.setInventories(itemStack);
            this.gui.setVisible(true);
            return true;
        }
        return false;
    }

    private int findIndex() {
        return this.gui.getFocusIndex();
    }

    private ToolbeltSlotType findSlotType() {
        return this.gui.getFocusType();
    }
}

